/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.player.base.MidiInstrument;
import org.herac.tuxguitar.player.base.MidiPercussion;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiPlayerMode;
import org.herac.tuxguitar.player.base.MidiPort;
import org.herac.tuxguitar.player.base.MidiPortEmpty;
import org.herac.tuxguitar.player.base.MidiPortProvider;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.player.base.MidiSequenceParser;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.player.base.MidiSequencerEmpty;
import org.herac.tuxguitar.player.base.MidiSequencerProvider;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGLock;

public class MidiPlayer {
    private static final int MAX_CHANNELS = 16;
    private static final int TIMER_DELAY = 10;
    protected static TGLock lock = new TGLock();
    private TGSongManager songManager;
    private MidiSequencer sequencer;
    private MidiPort port;
    private MidiPlayerMode mode;
    private String sequencerKey;
    private String portKey;
    private List portProviders;
    private List sequencerProviders;
    private boolean running;
    private boolean paused;
    private boolean changeTickPosition;
    private boolean metronomeEnabled;
    private int metronomeTrack;
    private int infoTrack;
    private boolean anySolo;
    protected long tickPosition;
    protected boolean starting;

    public void init(TGSongManager tGSongManager) {
        this.songManager = tGSongManager;
        this.portProviders = new ArrayList();
        this.sequencerProviders = new ArrayList();
        this.getSequencer();
        this.getMode();
        this.reset();
    }

    public MidiInstrument[] getInstruments() {
        return MidiInstrument.INSTRUMENT_LIST;
    }

    public MidiPercussion[] getPercussions() {
        return MidiPercussion.PERCUSSION_LIST;
    }

    public void reset() {
        this.stop();
        this.tickPosition = 1000L;
        this.setChangeTickPosition(false);
    }

    public void close() {
        try {
            this.closeSequencer();
            this.closePort();
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void stop(boolean bl) {
        try {
            this.setPaused(bl);
            if (this.isRunning()) {
                this.getSequencer().stop();
            }
            this.setRunning(false);
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void stop() {
        this.stop(false);
    }

    public void pause() {
        this.stop(true);
    }

    public synchronized void play() throws MidiPlayerException {
        try {
            this.getMidiPort().check();
            this.setStarting(true);
            this.stop();
            this.systemReset();
            this.addSecuence();
            this.updatePrograms();
            this.updateControllers();
            this.updateDefaultControllers();
            this.setMetronomeEnabled(this.isMetronomeEnabled());
            this.setChangeTickPosition(true);
            this.setRunning(true);
            this.getSequencer().start();
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public synchronized void run() {
                    lock.lock();
                    try {
                        MidiPlayer.this.setStarting(false);
                        long l = 0L;
                        long l2 = 0L;
                        while (MidiPlayer.this.getSequencer().isRunning() && MidiPlayer.this.isRunning()) {
                            MidiSequencer midiSequencer = MidiPlayer.this.getSequencer();
                            synchronized (midiSequencer) {
                                if (MidiPlayer.this.isChangeTickPosition()) {
                                    MidiPlayer.this.changeTickPosition();
                                }
                                MidiPlayer.this.tickPosition = MidiPlayer.this.getSequencer().getTickPosition();
                                while ((l2 = System.currentTimeMillis()) - l < 10L) {
                                    MidiPlayer.this.getSequencer().wait(1L);
                                }
                                l = l2;
                            }
                        }
                        if (MidiPlayer.this.isRunning()) {
                            if (MidiPlayer.this.tickPosition >= MidiPlayer.this.getSequencer().getTickLength() - 500L) {
                                MidiPlayer.this.finish();
                            } else {
                                MidiPlayer.this.stop(MidiPlayer.this.isPaused());
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        MidiPlayer.this.setStarting(false);
                        MidiPlayer.this.reset();
                        throwable.printStackTrace();
                    }
                    lock.unlock();
                }
            }).start();
        }
        catch (Throwable throwable) {
            this.setStarting(false);
            this.reset();
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
    }

    protected void finish() {
        try {
            if (this.getMode().isLoop()) {
                this.setStarting(true);
                this.reset();
                this.getMode().notifyLoop();
                this.play();
                return;
            }
            this.reset();
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    protected boolean isStarting() {
        return this.starting;
    }

    protected void setStarting(boolean bl) {
        this.starting = bl;
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }

    public boolean isRunning() {
        try {
            return this.running || this.getSequencer().isRunning() || this.isStarting();
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
            return false;
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    protected boolean isChangeTickPosition() {
        return this.changeTickPosition;
    }

    private void setChangeTickPosition(boolean bl) {
        this.changeTickPosition = bl;
    }

    public void setTickPosition(long l) {
        this.tickPosition = l;
        this.setChangeTickPosition(true);
        if (!this.isRunning()) {
            this.changeTickPosition();
        }
    }

    public long getTickPosition() {
        return this.tickPosition;
    }

    protected void changeTickPosition() {
        try {
            if (this.isRunning()) {
                this.getSequencer().setTickPosition(this.tickPosition);
            }
            this.setChangeTickPosition(false);
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void systemReset() {
        try {
            this.getMidiPort().out().sendSystemReset();
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void addSecuence() {
        try {
            MidiSequenceParser midiSequenceParser = new MidiSequenceParser(this.songManager, 4, this.getMode().getCurrentPercent(), 0);
            MidiSequenceHandler midiSequenceHandler = this.getSequencer().createSequence(this.songManager.getSong().countTracks() + 2);
            midiSequenceParser.parse(midiSequenceHandler);
            this.infoTrack = midiSequenceHandler.getInfoTrack();
            this.metronomeTrack = midiSequenceHandler.getMetronomeTrack();
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    private void updateDefaultControllers() {
        try {
            for (int i = 0; i < 16; ++i) {
                this.getMidiPort().out().sendControlChange(i, 101, 0);
                this.getMidiPort().out().sendControlChange(i, 100, 0);
                this.getMidiPort().out().sendControlChange(i, 6, 12);
                this.getMidiPort().out().sendControlChange(i, 38, 0);
            }
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void updatePrograms() {
        try {
            Iterator iterator = this.songManager.getSong().getTracks();
            while (iterator.hasNext()) {
                TGTrack tGTrack = (TGTrack)iterator.next();
                this.getMidiPort().out().sendProgramChange(tGTrack.getChannel().getChannel(), tGTrack.getChannel().getInstrument());
                if (tGTrack.getChannel().getChannel() == tGTrack.getChannel().getEffectChannel()) continue;
                this.getMidiPort().out().sendProgramChange(tGTrack.getChannel().getEffectChannel(), tGTrack.getChannel().getInstrument());
            }
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void updateControllers() {
        this.anySolo = false;
        boolean bl = false;
        Iterator iterator = this.songManager.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            this.updateController(tGTrack);
            this.anySolo = !this.anySolo ? tGTrack.getChannel().isSolo() : this.anySolo;
            bl = bl || tGTrack.isPercussionTrack();
        }
        if (!bl && this.isMetronomeEnabled()) {
            this.updateController(9, (int)((double)this.songManager.getSong().getVolume() / 10.0 * 127.0), 64);
        }
        this.afterUpdate();
    }

    private void updateController(TGTrack tGTrack) {
        try {
            int n = (int)((double)this.songManager.getSong().getVolume() / 10.0 * (double)tGTrack.getChannel().getVolume());
            short s = tGTrack.getChannel().getBalance();
            this.updateController(tGTrack.getChannel().getChannel(), n, s);
            if (tGTrack.getChannel().getChannel() != tGTrack.getChannel().getEffectChannel()) {
                this.updateController(tGTrack.getChannel().getEffectChannel(), n, s);
            }
            this.getSequencer().setMute(tGTrack.getNumber(), tGTrack.getChannel().isMute());
            this.getSequencer().setSolo(tGTrack.getNumber(), tGTrack.getChannel().isSolo());
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    private void updateController(int n, int n2, int n3) {
        try {
            this.getMidiPort().out().sendControlChange(n, 7, n2);
            this.getMidiPort().out().sendControlChange(n, 10, n3);
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    private void afterUpdate() {
        try {
            this.getSequencer().setSolo(this.infoTrack, this.anySolo);
            this.getSequencer().setSolo(this.metronomeTrack, this.isMetronomeEnabled() && this.anySolo);
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public boolean isMetronomeEnabled() {
        return this.metronomeEnabled;
    }

    public void setMetronomeEnabled(boolean bl) {
        try {
            this.metronomeEnabled = bl;
            this.getSequencer().setMute(this.metronomeTrack, !this.isMetronomeEnabled());
            this.getSequencer().setSolo(this.metronomeTrack, this.isMetronomeEnabled() && this.anySolo);
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void playBeat(TGTrack tGTrack, List list) {
        short s = tGTrack.getChannel().getChannel();
        short s2 = tGTrack.getChannel().getInstrument();
        int n = (int)((double)this.songManager.getSong().getVolume() / 10.0 * (double)tGTrack.getChannel().getVolume());
        short s3 = tGTrack.getChannel().getBalance();
        short s4 = tGTrack.getChannel().getChorus();
        short s5 = tGTrack.getChannel().getReverb();
        short s6 = tGTrack.getChannel().getPhaser();
        short s7 = tGTrack.getChannel().getTremolo();
        int n2 = list.size();
        int[][] nArray = new int[n2][2];
        for (int i = 0; i < n2; ++i) {
            TGNote tGNote = (TGNote)list.get(i);
            nArray[i][0] = tGTrack.getOffset() + (tGNote.getValue() + ((TGString)tGTrack.getStrings().get(tGNote.getString() - 1)).getValue());
            nArray[i][1] = tGNote.getVelocity();
        }
        this.playBeat(s, s2, n, s3, s4, s5, s6, s7, nArray);
    }

    public void playBeat(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[][] nArray) {
        this.playBeat(n, n2, n3, n4, n5, n6, n7, n8, nArray, 500L, 0);
    }

    public void playBeat(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[][] nArray, long l, int n9) {
        try {
            int n10;
            this.getMidiPort().out().sendProgramChange(n, n2);
            this.getMidiPort().out().sendControlChange(n, 7, n3);
            this.getMidiPort().out().sendControlChange(n, 10, n4);
            this.getMidiPort().out().sendControlChange(n, 93, n5);
            this.getMidiPort().out().sendControlChange(n, 91, n6);
            this.getMidiPort().out().sendControlChange(n, 95, n7);
            this.getMidiPort().out().sendControlChange(n, 92, n8);
            for (n10 = 0; n10 < nArray.length; ++n10) {
                this.getMidiPort().out().sendNoteOn(n, nArray[n10][0], nArray[n10][1]);
                if (n9 <= 0) continue;
                Thread.sleep(n9);
            }
            Thread.sleep(l);
            for (n10 = 0; n10 < nArray.length; ++n10) {
                this.getMidiPort().out().sendNoteOff(n, nArray[n10][0], nArray[n10][1]);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public MidiPlayerMode getMode() {
        if (this.mode == null) {
            this.mode = new MidiPlayerMode();
        }
        return this.mode;
    }

    public MidiPort getMidiPort() {
        if (this.port == null) {
            this.port = new MidiPortEmpty();
        }
        return this.port;
    }

    protected MidiSequencer getSequencer() {
        if (this.sequencer == null) {
            this.sequencer = new MidiSequencerEmpty();
        }
        return this.sequencer;
    }

    public boolean loadSequencer(MidiSequencer midiSequencer) {
        try {
            this.closeSequencer();
            this.sequencer = midiSequencer;
            this.sequencer.open();
            this.sequencer.setMidiPort(this.getMidiPort());
        }
        catch (Throwable throwable) {
            this.sequencer = null;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadPort(MidiPort midiPort) {
        try {
            this.closePort();
            this.port = midiPort;
            this.port.open();
        }
        catch (Throwable throwable) {
            this.port = null;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.getSequencer().setMidiPort(this.getMidiPort());
            }
            catch (MidiPlayerException midiPlayerException) {
                midiPlayerException.printStackTrace();
            }
        }
        return true;
    }

    public void openPort(String string) {
        this.portKey = string;
        this.openPort(this.listPorts(), false);
    }

    public void openPort(List list, boolean bl) {
        try {
            if (this.portKey != null && !this.isMidiPortOpen(this.portKey)) {
                if (this.isRunning()) {
                    this.stop();
                }
                this.getMidiPort().close();
                for (int i = 0; i < list.size(); ++i) {
                    MidiPort midiPort = (MidiPort)list.get(i);
                    if (!midiPort.getKey().equals(this.portKey) || !this.loadPort(midiPort)) continue;
                    return;
                }
            }
            if (this.getMidiPort() instanceof MidiPortEmpty && !list.isEmpty() && bl) {
                this.loadPort((MidiPort)list.get(0));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void openSequencer(String string) {
        try {
            this.sequencerKey = string;
            this.openSequencer(this.listSequencers(), false);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void openSequencer(List list, boolean bl) throws MidiPlayerException {
        try {
            if (this.sequencerKey != null && !this.isSequencerOpen(this.sequencerKey)) {
                if (this.isRunning()) {
                    this.stop();
                }
                for (int i = 0; i < list.size(); ++i) {
                    MidiSequencer midiSequencer = (MidiSequencer)list.get(i);
                    if (!midiSequencer.getKey().equals(this.sequencerKey) || !this.loadSequencer(midiSequencer)) continue;
                    return;
                }
            }
            if (this.getSequencer() instanceof MidiSequencerEmpty && !list.isEmpty() && bl) {
                this.loadSequencer((MidiSequencer)list.get(0));
            }
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
    }

    public List listPorts() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.portProviders.iterator();
        while (iterator.hasNext()) {
            try {
                MidiPortProvider midiPortProvider = (MidiPortProvider)iterator.next();
                arrayList.addAll(midiPortProvider.listPorts());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return arrayList;
    }

    public List listSequencers() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.sequencerProviders.iterator();
        while (iterator.hasNext()) {
            try {
                MidiSequencerProvider midiSequencerProvider = (MidiSequencerProvider)iterator.next();
                arrayList.addAll(midiSequencerProvider.listSequencers());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return arrayList;
    }

    public void closeSequencer() throws MidiPlayerException {
        try {
            this.stop();
            if (lock.isLocked()) {
                lock.waitFor();
            }
            if (this.sequencer != null) {
                this.sequencer.close();
                this.sequencer = null;
            }
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
    }

    public void closePort() {
        try {
            this.stop();
            if (lock.isLocked()) {
                lock.waitFor();
            }
            if (this.port != null) {
                this.port.close();
                this.port = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isSequencerOpen(String string) {
        if (string != null) {
            String string2 = this.getSequencer().getKey();
            if (string2 == null) {
                return false;
            }
            return string2.equals(string);
        }
        return false;
    }

    public boolean isMidiPortOpen(String string) {
        if (string != null) {
            String string2 = this.getMidiPort().getKey();
            if (string2 == null) {
                return false;
            }
            return string2.equals(string);
        }
        return false;
    }

    public void addPortProvider(MidiPortProvider midiPortProvider) throws MidiPlayerException {
        this.portProviders.add(midiPortProvider);
        this.openPort(midiPortProvider.listPorts(), true);
    }

    public void addSequencerProvider(MidiSequencerProvider midiSequencerProvider) throws MidiPlayerException {
        this.sequencerProviders.add(midiSequencerProvider);
        this.openSequencer(midiSequencerProvider.listSequencers(), true);
    }

    public void removePortProvider(MidiPortProvider midiPortProvider) throws MidiPlayerException {
        this.portProviders.remove(midiPortProvider);
        MidiPort midiPort = this.getMidiPort();
        if (!(midiPort instanceof MidiPortEmpty) && midiPort != null) {
            Iterator iterator = midiPortProvider.listPorts().iterator();
            while (iterator.hasNext()) {
                MidiPort midiPort2 = (MidiPort)iterator.next();
                if (!midiPort2.getKey().equals(midiPort.getKey())) continue;
                this.closePort();
                this.getSequencer().setMidiPort(this.getMidiPort());
                break;
            }
        }
    }

    public void removeSequencerProvider(MidiSequencerProvider midiSequencerProvider) throws MidiPlayerException {
        this.sequencerProviders.remove(midiSequencerProvider);
        MidiSequencer midiSequencer = this.getSequencer();
        if (!(midiSequencer instanceof MidiSequencerEmpty) && midiSequencer != null) {
            Iterator iterator = midiSequencerProvider.listSequencers().iterator();
            while (iterator.hasNext()) {
                MidiSequencer midiSequencer2 = (MidiSequencer)iterator.next();
                if (!midiSequencer.getKey().equals(midiSequencer2.getKey())) continue;
                this.closeSequencer();
                break;
            }
        }
    }
}

