/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io;

import java.io.File;
import java.io.FileInputStream;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;

public class TGConverter {
    private TGSongManager manager = new TGSongManager();
    private String sourceFolder;
    private String destinationFolder;

    public TGConverter(String string, String string2) {
        this.sourceFolder = string;
        this.destinationFolder = string2;
    }

    public void convert(String string, String string2) {
        try {
            TGSong tGSong = TGFileFormatManager.instance().getLoader().load(this.manager.getFactory(), new FileInputStream(string));
            if (tGSong != null) {
                this.manager.setSong(tGSong);
                this.manager.autoCompleteSilences();
                System.out.print(string2);
                new File(new File(string2).getParent()).mkdirs();
                TGFileFormatManager.instance().getWriter().write(this.manager.getFactory(), this.manager.getSong(), string2);
                System.out.println(" [OK] ");
            } else if (string.endsWith(".gp3") || string.endsWith(".gp4") || string.endsWith(".gp5")) {
                System.err.println(string + " [Unsupported Version]");
            }
        }
        catch (Exception exception) {
            System.out.println(string2 + " [FAILED] ");
            System.out.println(" ********** REASON: " + exception.getClass().getName() + " ********** ");
            exception.printStackTrace();
            System.exit(1);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println(string2 + "  [FAILED]  ");
            System.out.println(" ********** REASON: OutOfMemoryError ********** ");
            System.gc();
        }
    }

    private void process(File file) {
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file.getPath() + "/" + stringArray[i]);
                if (file2.isDirectory()) {
                    this.process(file2);
                } else {
                    String string = file2.getAbsolutePath();
                    String string2 = this.getConvertFileName(string);
                    this.convert(string, string2);
                }
                stringArray[i] = null;
            }
        }
    }

    private String getConvertFileName(String string) {
        String string2 = this.destinationFolder + File.separator + string.substring(this.sourceFolder.length());
        if (string2.endsWith(".gp3") || string2.endsWith(".gp4") || string2.endsWith(".gp5")) {
            string2 = string2.replaceAll(".gp3", ".tg");
            string2 = string2.replaceAll(".gp4", ".tg");
            string2 = string2.replaceAll(".gp5", ".tg");
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 2) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            TGConverter tGConverter = new TGConverter(string, string2);
            File file = new File(string);
            tGConverter.process(file);
        } else {
            TGConverter.showHelp();
        }
        System.exit(0);
    }

    private static void showHelp() {
        System.out.println("usage options:  [SOURCE FOLDER] [DESTINATION FOLDER]");
    }
}

