/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;

public class UndoableTrackChannel
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private List undoChannels;
    private List redoChannels;
    private int undoVolume;
    private int redoVolume;

    private UndoableTrackChannel() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TGSong tGSong = TuxGuitar.instance().getSongManager().getSong();
        tGSong.setVolume(this.redoVolume);
        for (int i = 0; i < this.redoChannels.size(); ++i) {
            TGChannel tGChannel = (TGChannel)this.redoChannels.get(i);
            TGTrack tGTrack = tGSong.getTrack(i);
            tGChannel.copy(tGTrack.getChannel());
        }
        TuxGuitar.instance().getMixer().updateValues();
        TuxGuitar.instance().updateCache(true);
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getPlayer().updateControllers();
        }
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TGSong tGSong = TuxGuitar.instance().getSongManager().getSong();
        tGSong.setVolume(this.undoVolume);
        for (int i = 0; i < this.undoChannels.size(); ++i) {
            TGChannel tGChannel = (TGChannel)this.undoChannels.get(i);
            TGTrack tGTrack = tGSong.getTrack(i);
            tGChannel.copy(tGTrack.getChannel());
        }
        TuxGuitar.instance().getMixer().updateValues();
        TuxGuitar.instance().updateCache(true);
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getPlayer().updateControllers();
        }
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableTrackChannel startUndo() {
        TGSong tGSong = TuxGuitar.instance().getSongManager().getSong();
        TGFactory tGFactory = TuxGuitar.instance().getSongManager().getFactory();
        int n = tGSong.countTracks();
        UndoableTrackChannel undoableTrackChannel = new UndoableTrackChannel();
        undoableTrackChannel.doAction = 1;
        undoableTrackChannel.undoCaret = new UndoableCaretHelper();
        undoableTrackChannel.undoChannels = new ArrayList();
        undoableTrackChannel.undoVolume = tGSong.getVolume();
        for (int i = 0; i < n; ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            undoableTrackChannel.undoChannels.add(tGTrack.getChannel().clone(tGFactory));
        }
        return undoableTrackChannel;
    }

    public UndoableTrackChannel endUndo() {
        TGSong tGSong = TuxGuitar.instance().getSongManager().getSong();
        TGFactory tGFactory = TuxGuitar.instance().getSongManager().getFactory();
        int n = tGSong.countTracks();
        this.redoCaret = new UndoableCaretHelper();
        this.redoChannels = new ArrayList();
        this.redoVolume = tGSong.getVolume();
        for (int i = 0; i < n; ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            this.redoChannels.add(tGTrack.getChannel().clone(tGFactory));
        }
        return this;
    }
}

