/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.measure;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.helpers.TGSongSegment;
import org.herac.tuxguitar.song.helpers.TGSongSegmentHelper;

public class UndoableInsertMeasure
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private TGSongSegment tracksMeasures;
    private long insertPosition;
    private int toTrack;
    private int copyCount;
    private int fromNumber;
    private long theMove;

    public UndoableInsertMeasure(int n) {
        Caret caret = UndoableInsertMeasure.getCaret();
        this.doAction = 1;
        this.toTrack = n;
        this.undoCaret = new UndoableCaretHelper();
        this.insertPosition = caret.getPosition();
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TGSongSegmentHelper tGSongSegmentHelper = new TGSongSegmentHelper(TuxGuitar.instance().getSongManager());
        tGSongSegmentHelper.insertMeasures(this.tracksMeasures.clone(TuxGuitar.instance().getSongManager().getFactory()), this.fromNumber, this.theMove, this.toTrack);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        for (int i = 0; i < this.copyCount; ++i) {
            TuxGuitar.instance().getSongManager().removeMeasure(this.insertPosition);
        }
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public UndoableInsertMeasure endUndo(TGSongSegment tGSongSegment, int n, int n2, long l) {
        this.redoCaret = new UndoableCaretHelper();
        this.copyCount = n;
        this.tracksMeasures = tGSongSegment;
        this.fromNumber = n2;
        this.theMove = l;
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

