/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;

public class UndoableChangeTimeSignature
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long position;
    private TGTimeSignature redoableTimeSignature;
    private TGTimeSignature undoableTimeSignature;
    private List nextTimeSignaturePositions;
    private boolean toEnd;

    private UndoableChangeTimeSignature() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().changeTimeSignature(this.position, this.redoableTimeSignature.clone(TuxGuitar.instance().getSongManager().getFactory()), this.toEnd);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TuxGuitar.instance().getSongManager().changeTimeSignature(this.position, this.undoableTimeSignature.clone(TuxGuitar.instance().getSongManager().getFactory()), this.toEnd);
        if (this.toEnd) {
            Iterator iterator = this.nextTimeSignaturePositions.iterator();
            while (iterator.hasNext()) {
                TimeSignaturePosition timeSignaturePosition = (TimeSignaturePosition)iterator.next();
                TuxGuitar.instance().getSongManager().changeTimeSignature(timeSignaturePosition.getPosition(), timeSignaturePosition.getTimeSignature().clone(TuxGuitar.instance().getSongManager().getFactory()), true);
            }
        }
        if (this.shouldRemoveRightBeats()) {
            this.removeRightBeats(this.position, this.toEnd);
        }
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeTimeSignature startUndo() {
        UndoableChangeTimeSignature undoableChangeTimeSignature = new UndoableChangeTimeSignature();
        Caret caret = UndoableChangeTimeSignature.getCaret();
        undoableChangeTimeSignature.doAction = 1;
        undoableChangeTimeSignature.undoCaret = new UndoableCaretHelper();
        undoableChangeTimeSignature.position = caret.getPosition();
        undoableChangeTimeSignature.undoableTimeSignature = caret.getMeasure().getTimeSignature().clone(TuxGuitar.instance().getSongManager().getFactory());
        undoableChangeTimeSignature.nextTimeSignaturePositions = new ArrayList();
        TGTimeSignature tGTimeSignature = undoableChangeTimeSignature.undoableTimeSignature;
        Iterator iterator = TuxGuitar.instance().getSongManager().getFirstTrack().getMeasures();
        while (iterator.hasNext()) {
            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)iterator.next();
            if (tGMeasureImpl.getStart() <= undoableChangeTimeSignature.position) continue;
            TGTimeSignature tGTimeSignature2 = tGMeasureImpl.getTimeSignature();
            int n = tGTimeSignature.getNumerator();
            int n2 = tGTimeSignature.getDenominator().getValue();
            int n3 = tGTimeSignature2.getNumerator();
            int n4 = tGTimeSignature2.getDenominator().getValue();
            if (n != n3 || n2 != n4) {
                UndoableChangeTimeSignature undoableChangeTimeSignature2 = undoableChangeTimeSignature;
                undoableChangeTimeSignature2.getClass();
                TimeSignaturePosition timeSignaturePosition = undoableChangeTimeSignature2.new TimeSignaturePosition(tGMeasureImpl.getStart(), tGTimeSignature2.clone(TuxGuitar.instance().getSongManager().getFactory()));
                undoableChangeTimeSignature.nextTimeSignaturePositions.add(timeSignaturePosition);
            }
            tGTimeSignature = tGTimeSignature2;
        }
        return undoableChangeTimeSignature;
    }

    public UndoableChangeTimeSignature endUndo(TGTimeSignature tGTimeSignature, boolean bl) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoableTimeSignature = tGTimeSignature.clone(TuxGuitar.instance().getSongManager().getFactory());
        this.toEnd = bl;
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    private boolean shouldRemoveRightBeats() {
        long l;
        long l2 = (long)this.redoableTimeSignature.getNumerator() * this.redoableTimeSignature.getDenominator().getTime();
        return l2 > (l = (long)this.undoableTimeSignature.getNumerator() * this.undoableTimeSignature.getDenominator().getTime());
    }

    private void removeRightBeats(long l, boolean bl) {
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        int n = tGSongManager.getSong().countTracks();
        for (int i = 1; i <= n; ++i) {
            TGTrack tGTrack = tGSongManager.getTrack(i);
            TGMeasure tGMeasure = tGSongManager.getTrackManager().getMeasureAt(tGTrack, l);
            tGSongManager.getMeasureManager().removeBeatsBeforeEnd(tGMeasure, tGMeasure.getStart() + tGMeasure.getLength());
            if (!bl) continue;
            while ((tGMeasure = tGSongManager.getTrackManager().getNextMeasure(tGMeasure)) != null) {
                tGSongManager.getMeasureManager().removeBeatsBeforeEnd(tGMeasure, tGMeasure.getStart() + tGMeasure.getLength());
            }
        }
    }

    private class TimeSignaturePosition {
        private long position;
        private TGTimeSignature timeSignature;

        public TimeSignaturePosition(long l, TGTimeSignature tGTimeSignature) {
            this.position = l;
            this.timeSignature = tGTimeSignature;
        }

        public long getPosition() {
            return this.position;
        }

        public TGTimeSignature getTimeSignature() {
            return this.timeSignature;
        }
    }
}

