/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserCollection;

public class TGBrowserCollectionCombo {
    private Combo combo;
    private List collections;

    public TGBrowserCollectionCombo(Composite composite, int n) {
        this.combo = new Combo(composite, n);
        this.collections = new ArrayList();
        this.addFirstElement();
    }

    private void addFirstElement() {
        this.combo.add(TuxGuitar.getProperty("browser.collection.select"));
        this.combo.select(0);
    }

    public void add(TGBrowserCollection tGBrowserCollection) {
        this.combo.add(tGBrowserCollection.getData().getTitle());
        this.collections.add(tGBrowserCollection);
    }

    public TGBrowserCollection getSelection() {
        int n = this.combo.getSelectionIndex() - 1;
        if (n >= 0 && n < this.collections.size()) {
            return (TGBrowserCollection)this.collections.get(n);
        }
        return null;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.combo.addSelectionListener(selectionListener);
    }

    public void setLayoutData(Object object) {
        this.combo.setLayoutData(object);
    }

    public void removeAll() {
        this.combo.removeAll();
        this.collections.clear();
        this.addFirstElement();
    }

    public void select(int n) {
        this.combo.select(n + 1);
    }

    public void setEnabled(boolean bl) {
        this.combo.setEnabled(bl);
    }

    public boolean isEmpty() {
        return this.collections.isEmpty();
    }
}

