/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.table;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.table.TGTable;

public class TGTableRow {
    private TGTable table;
    private Composite row;
    private CLabel number;
    private CLabel name;
    private CLabel instrument;
    private Composite painter;
    private MouseListener mouseListenerLabel;
    private MouseListener mouseListenerCanvas;
    private PaintListener paintListenerCanvas;

    public TGTableRow(TGTable tGTable) {
        this.table = tGTable;
        this.init();
    }

    public void init() {
        MouseListenerLabel mouseListenerLabel = new MouseListenerLabel();
        MouseListenerCanvas mouseListenerCanvas = new MouseListenerCanvas();
        PaintListenerCanvas paintListenerCanvas = new PaintListenerCanvas();
        this.row = new Composite(this.table.getRowControl(), 0);
        this.row.setLayoutData(new GridData(4, 128, true, false));
        this.number = new CLabel(this.row, 16384);
        this.number.addMouseListener(mouseListenerLabel);
        this.table.addRowItem(this.table.getColumnNumber(), this.number, true);
        this.name = new CLabel(this.row, 16384);
        this.name.addMouseListener(mouseListenerLabel);
        this.table.addRowItem(this.table.getColumnName(), this.name, true);
        this.instrument = new CLabel(this.row, 16384);
        this.instrument.addMouseListener(mouseListenerLabel);
        this.table.addRowItem(this.table.getColumnInstrument(), this.instrument, true);
        this.painter = new Composite(this.row, 0x20000000);
        this.painter.addMouseListener(mouseListenerCanvas);
        this.painter.addPaintListener(paintListenerCanvas);
        this.table.addRowItem(this.table.getColumnCanvas(), this.painter, false);
        this.row.pack();
    }

    public void setBackground(Color color) {
        this.number.setBackground(color);
        this.name.setBackground(color);
        this.instrument.setBackground(color);
    }

    public void dispose() {
        this.row.dispose();
    }

    public Composite getPainter() {
        return this.painter;
    }

    public CLabel getInstrument() {
        return this.instrument;
    }

    public CLabel getName() {
        return this.name;
    }

    public CLabel getNumber() {
        return this.number;
    }

    public MouseListener getMouseListenerLabel() {
        return this.mouseListenerLabel;
    }

    public void setMouseListenerLabel(MouseListener mouseListener) {
        this.mouseListenerLabel = mouseListener;
    }

    public MouseListener getMouseListenerCanvas() {
        return this.mouseListenerCanvas;
    }

    public void setMouseListenerCanvas(MouseListener mouseListener) {
        this.mouseListenerCanvas = mouseListener;
    }

    public PaintListener getPaintListenerCanvas() {
        return this.paintListenerCanvas;
    }

    public void setPaintListenerCanvas(PaintListener paintListener) {
        this.paintListenerCanvas = paintListener;
    }

    private class PaintListenerCanvas
    implements PaintListener {
        public void paintControl(PaintEvent paintEvent) {
            if (TGTableRow.this.getPaintListenerCanvas() != null) {
                TGTableRow.this.getPaintListenerCanvas().paintControl(paintEvent);
            }
        }
    }

    private class MouseListenerCanvas
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent mouseEvent) {
            if (TGTableRow.this.getMouseListenerCanvas() != null) {
                TGTableRow.this.getMouseListenerCanvas().mouseDoubleClick(mouseEvent);
            }
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (TGTableRow.this.getMouseListenerCanvas() != null) {
                TGTableRow.this.getMouseListenerCanvas().mouseDown(mouseEvent);
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (TGTableRow.this.getMouseListenerCanvas() != null) {
                TGTableRow.this.getMouseListenerCanvas().mouseUp(mouseEvent);
            }
        }
    }

    private class MouseListenerLabel
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent mouseEvent) {
            if (TGTableRow.this.getMouseListenerLabel() != null) {
                TGTableRow.this.getMouseListenerLabel().mouseDoubleClick(mouseEvent);
            }
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (TGTableRow.this.getMouseListenerLabel() != null) {
                TGTableRow.this.getMouseListenerLabel().mouseDown(mouseEvent);
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (TGTableRow.this.getMouseListenerLabel() != null) {
                TGTableRow.this.getMouseListenerLabel().mouseUp(mouseEvent);
            }
        }
    }
}

