/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.keybindings.editor;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.keybindings.KeyBinding;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingReserveds;
import org.herac.tuxguitar.gui.system.keybindings.editor.KeyBindingEditor;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class KeyBindingSelector {
    protected Shell dialog;
    protected KeyBindingEditor editor;
    protected KeyBinding keyBinding;

    public KeyBindingSelector(KeyBindingEditor keyBindingEditor, KeyBinding keyBinding) {
        this.editor = keyBindingEditor;
        this.keyBinding = keyBinding;
    }

    public KeyBinding select(Shell shell) {
        this.dialog = DialogUtils.newDialog(shell, 67680);
        this.dialog.setLayout(new GridLayout());
        final Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(4, 4, true, true));
        composite.setFocus();
        composite.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                KeyBinding keyBinding = new KeyBinding(keyEvent.keyCode, keyEvent.stateMask);
                if (keyBinding.equals(KeyBindingSelector.this.keyBinding) || KeyBindingSelector.this.isValid(keyBinding)) {
                    if (KeyBindingSelector.this.keyBinding == null) {
                        KeyBindingSelector.this.keyBinding = new KeyBinding();
                    }
                    KeyBindingSelector.this.keyBinding.setKey(keyBinding.getKey());
                    KeyBindingSelector.this.keyBinding.setMask(keyBinding.getMask());
                    KeyBindingSelector.this.dialog.dispose();
                } else {
                    composite.setFocus();
                }
            }
        });
        final Font font = new Font((Device)this.dialog.getDisplay(), "Sans", 15, 1);
        Label label = new Label(composite, 16384);
        label.setFont(font);
        label.setText(TuxGuitar.getProperty("key-bindings-editor-push-a-key"));
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                font.dispose();
            }
        });
        Composite composite2 = new Composite(this.dialog, 0);
        composite2.setLayout(new GridLayout(2, false));
        composite2.setLayoutData(new GridData(131072, 4, true, true));
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("clean"));
        button.setLayoutData(this.getButtonData());
        button.addMouseListener(new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                composite.setFocus();
            }
        });
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyBindingSelector.this.keyBinding = null;
                KeyBindingSelector.this.dialog.dispose();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.setLayoutData(this.getButtonData());
        button2.addMouseListener(new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                composite.setFocus();
            }
        });
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyBindingSelector.this.dialog.dispose();
            }
        });
        DialogUtils.openDialog(this.dialog, 11);
        return this.keyBinding;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected boolean isValid(KeyBinding keyBinding) {
        ConfirmDialog confirmDialog;
        if (KeyBindingReserveds.isReserved(keyBinding)) {
            MessageDialog.infoMessage(this.dialog, TuxGuitar.getProperty("key-bindings-editor-reserved-title"), TuxGuitar.getProperty("key-bindings-editor-reserved-message"));
            return false;
        }
        return !this.editor.exists(keyBinding) || (confirmDialog = new ConfirmDialog(TuxGuitar.getProperty("key-bindings-editor-override"))).confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO) != ConfirmDialog.STATUS_NO;
    }
}

