/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.marker;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.undo.undoables.UndoableJoined;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeMarker;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGMarker;

public class MarkerEditor {
    public static final int STATUS_NEW = 1;
    public static final int STATUS_EDIT = 2;
    private static final int MINIMUN_CONTROL_WIDTH = 180;
    private static final int MINIMUN_BUTTON_WIDTH = 80;
    private static final int MINIMUN_BUTTON_HEIGHT = 25;
    private int status;
    protected TGMarker marker;
    protected Shell dialog;
    protected Spinner measureSpinner;
    protected Text titleText;
    protected Button colorButton;
    protected boolean accepted;

    public MarkerEditor(TGMarker tGMarker) {
        this(tGMarker, 1);
    }

    public MarkerEditor(TGMarker tGMarker, int n) {
        this.marker = tGMarker.clone(TuxGuitar.instance().getSongManager().getFactory());
        this.status = n;
    }

    public boolean open(Shell shell) {
        this.accepted = false;
        this.dialog = DialogUtils.newDialog(shell, 67680);
        this.dialog.setLayout(new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("marker"));
        Group group = new Group(this.dialog, 16);
        group.setLayout(new GridLayout(2, false));
        group.setLayoutData(new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("marker"));
        final int n = TuxGuitar.instance().getSongManager().getSong().countMeasureHeaders();
        Label label = new Label(group, 0);
        label.setLayoutData(new GridData(131072, 0x1000000, true, true));
        label.setText(TuxGuitar.getProperty("measure"));
        this.measureSpinner = new Spinner(group, 2048);
        this.measureSpinner.setLayoutData(this.getAlignmentData(180, 4));
        this.measureSpinner.setMinimum(1);
        this.measureSpinner.setMaximum(n);
        this.measureSpinner.setSelection(this.marker.getMeasure());
        this.measureSpinner.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n2 = MarkerEditor.this.measureSpinner.getSelection();
                if (n2 < 1) {
                    MarkerEditor.this.measureSpinner.setSelection(1);
                } else if (n2 > n) {
                    MarkerEditor.this.measureSpinner.setSelection(n);
                }
            }
        });
        Label label2 = new Label(group, 0);
        label2.setLayoutData(new GridData(131072, 0x1000000, true, true));
        label2.setText(TuxGuitar.getProperty("title"));
        this.titleText = new Text(group, 2048);
        this.titleText.setLayoutData(this.getAlignmentData(180, 4));
        this.titleText.setText(this.marker.getTitle());
        Label label3 = new Label(group, 0);
        label3.setLayoutData(new GridData(131072, 0x1000000, true, true));
        label3.setText(TuxGuitar.getProperty("color"));
        this.colorButton = new Button(group, 8);
        this.colorButton.setLayoutData(this.getAlignmentData(180, 4));
        this.colorButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(MarkerEditor.this.dialog);
                colorDialog.setRGB(MarkerEditor.this.dialog.getDisplay().getSystemColor(2).getRGB());
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    MarkerEditor.this.marker.getColor().setR(rGB.red);
                    MarkerEditor.this.marker.getColor().setG(rGB.green);
                    MarkerEditor.this.marker.getColor().setB(rGB.blue);
                    MarkerEditor.this.colorButton.redraw();
                }
            }
        });
        this.colorButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Color color = new Color(MarkerEditor.this.dialog.getDisplay(), MarkerEditor.this.marker.getColor().getR(), MarkerEditor.this.marker.getColor().getG(), MarkerEditor.this.marker.getColor().getB());
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                tGPainter.setBackground(color);
                tGPainter.initPath(2);
                tGPainter.addRectangle(5.0f, 5.0f, MarkerEditor.this.colorButton.getSize().x - 10, MarkerEditor.this.colorButton.getSize().y - 10);
                tGPainter.closePath();
                tGPainter.dispose();
                color.dispose();
            }
        });
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(new GridData(0x1000008, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData(gridData);
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MarkerEditor.this.updateMarker();
                MarkerEditor.this.accepted = true;
                MarkerEditor.this.dialog.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.setLayoutData(gridData);
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MarkerEditor.this.dialog.dispose();
            }
        });
        DialogUtils.openDialog(this.dialog, 11);
        return this.accepted;
    }

    private GridData getAlignmentData(int n, int n2) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n;
        gridData.horizontalAlignment = n2;
        gridData.verticalAlignment = -1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        return gridData;
    }

    protected void updateMarker() {
        UndoableChangeMarker undoableChangeMarker;
        int n = this.marker.getMeasure();
        this.marker.setMeasure(this.measureSpinner.getSelection());
        this.marker.setTitle(this.titleText.getText());
        this.marker = this.marker.clone(TuxGuitar.instance().getSongManager().getFactory());
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        UndoableJoined undoableJoined = new UndoableJoined();
        if (this.status == 2 && n != this.marker.getMeasure()) {
            undoableChangeMarker = UndoableChangeMarker.startUndo(tGSongManager.getMarker(n));
            TuxGuitar.instance().getSongManager().removeMarker(n);
            undoableJoined.addUndoableEdit(undoableChangeMarker.endUndo(null));
        }
        undoableChangeMarker = UndoableChangeMarker.startUndo(tGSongManager.getMarker(this.marker.getMeasure()));
        TuxGuitar.instance().getSongManager().updateMarker(this.marker);
        undoableJoined.addUndoableEdit(undoableChangeMarker.endUndo(this.marker));
        TuxGuitar.instance().getUndoableManager().addEdit(undoableJoined.endUndo());
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
    }
}

