/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.herac.tuxguitar.gui.items.ItemManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ToolBarsReader {
    private static final String ITEM_TAG = "toolbar";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ENABLED = "enabled";

    public static void loadToolBars(ItemManager itemManager, File file) {
        try {
            if (file.exists()) {
                ToolBarsReader.loadToolBars(itemManager, ToolBarsReader.getDocument(file).getFirstChild());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static Document getDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return document;
    }

    private static void loadToolBars(ItemManager itemManager, Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!string.equals(ITEM_TAG)) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node3 = namedNodeMap.getNamedItem(ATTR_NAME);
            Node node4 = namedNodeMap.getNamedItem(ATTR_ENABLED);
            if (node3 == null || node4 == null || node3.getNodeValue() == null || node4.getNodeValue() == null) {
                System.err.println("Invalid ToolBar Attributes.");
                continue;
            }
            itemManager.setToolBarStatus(node3.getNodeValue(), Boolean.parseBoolean(node4.getNodeValue()), n++);
        }
    }
}

