/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ToolItems;

public class ViewToolItems
extends ToolItems {
    public static final String NAME = "view.items";
    private ToolItem showFretBoard;
    private ToolItem showMixer;
    private ToolItem showTransport;

    public ViewToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.showFretBoard = new ToolItem(toolBar, 32);
        this.showFretBoard.addSelectionListener(TuxGuitar.instance().getAction("action.view.show-fretboard"));
        this.showMixer = new ToolItem(toolBar, 32);
        this.showMixer.addSelectionListener(TuxGuitar.instance().getAction("action.view.show-mixer"));
        this.showTransport = new ToolItem(toolBar, 32);
        this.showTransport.addSelectionListener(TuxGuitar.instance().getAction("action.view.show-transport"));
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        this.showFretBoard.setSelection(TuxGuitar.instance().getFretBoardEditor().isVisible());
        this.showMixer.setSelection(!TuxGuitar.instance().getMixer().isDisposed());
        this.showTransport.setSelection(!TuxGuitar.instance().getTransport().isDisposed());
    }

    public void loadProperties() {
        this.showFretBoard.setToolTipText(TuxGuitar.getProperty("show-fretboard"));
        this.showMixer.setToolTipText(TuxGuitar.getProperty("show-mixer"));
        this.showTransport.setToolTipText(TuxGuitar.getProperty("show-transport"));
    }

    public void loadIcons() {
        this.showFretBoard.setImage(TuxGuitar.instance().getIconManager().getFretboard());
        this.showMixer.setImage(TuxGuitar.instance().getIconManager().getMixer());
        this.showTransport.setImage(TuxGuitar.instance().getIconManager().getTransport());
    }
}

