/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ToolItems;

public class TransportToolItems
extends ToolItems {
    public static final String NAME = "transport.items";
    private static final int STATUS_STOPPED = 1;
    private static final int STATUS_PAUSED = 2;
    private static final int STATUS_RUNNING = 3;
    private ToolItem first;
    private ToolItem last;
    private ToolItem previous;
    private ToolItem next;
    private ToolItem stop;
    private ToolItem play;
    private int status;

    public TransportToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.first = new ToolItem(toolBar, 8);
        this.first.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().gotoFirst();
            }
        });
        this.previous = new ToolItem(toolBar, 8);
        this.previous.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().gotoPrevious();
            }
        });
        this.stop = new ToolItem(toolBar, 8);
        this.stop.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().stop(selectionEvent);
            }
        });
        this.play = new ToolItem(toolBar, 8);
        this.play.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().play(selectionEvent);
            }
        });
        this.next = new ToolItem(toolBar, 8);
        this.next.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().gotoNext();
            }
        });
        this.last = new ToolItem(toolBar, 8);
        this.last.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().gotoLast();
            }
        });
        this.status = 1;
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        this.loadIcons(false);
    }

    public void loadProperties() {
        this.play.setToolTipText(TuxGuitar.getProperty("transport.start"));
        this.stop.setToolTipText(TuxGuitar.getProperty("transport.stop"));
        this.first.setToolTipText(TuxGuitar.getProperty("transport.first"));
        this.last.setToolTipText(TuxGuitar.getProperty("transport.last"));
        this.previous.setToolTipText(TuxGuitar.getProperty("transport.previous"));
        this.next.setToolTipText(TuxGuitar.getProperty("transport.next"));
    }

    public void loadIcons() {
        this.loadIcons(true);
    }

    public void loadIcons(boolean bl) {
        int n = this.status;
        this.status = TuxGuitar.instance().getPlayer().isRunning() ? 3 : (TuxGuitar.instance().getPlayer().isPaused() ? 2 : 1);
        if (bl || n != this.status) {
            if (this.status == 3) {
                this.first.setImage(TuxGuitar.instance().getIconManager().getTransportIconFirst2());
                this.last.setImage(TuxGuitar.instance().getIconManager().getTransportIconLast2());
                this.previous.setImage(TuxGuitar.instance().getIconManager().getTransportIconPrevious2());
                this.next.setImage(TuxGuitar.instance().getIconManager().getTransportIconNext2());
                this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportIconStop2());
                this.play.setImage(TuxGuitar.instance().getIconManager().getTransportIconPause());
                this.play.setToolTipText(TuxGuitar.getProperty("transport.pause"));
            } else if (this.status == 2) {
                this.first.setImage(TuxGuitar.instance().getIconManager().getTransportIconFirst2());
                this.last.setImage(TuxGuitar.instance().getIconManager().getTransportIconLast2());
                this.previous.setImage(TuxGuitar.instance().getIconManager().getTransportIconPrevious2());
                this.next.setImage(TuxGuitar.instance().getIconManager().getTransportIconNext2());
                this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportIconStop2());
                this.play.setImage(TuxGuitar.instance().getIconManager().getTransportIconPlay2());
                this.play.setToolTipText(TuxGuitar.getProperty("transport.start"));
            } else if (this.status == 1) {
                this.first.setImage(TuxGuitar.instance().getIconManager().getTransportIconFirst1());
                this.last.setImage(TuxGuitar.instance().getIconManager().getTransportIconLast1());
                this.previous.setImage(TuxGuitar.instance().getIconManager().getTransportIconPrevious1());
                this.next.setImage(TuxGuitar.instance().getIconManager().getTransportIconNext1());
                this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportIconStop1());
                this.play.setImage(TuxGuitar.instance().getIconManager().getTransportIconPlay1());
                this.play.setToolTipText(TuxGuitar.getProperty("transport.start"));
            }
        }
    }
}

