/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ToolItems;

public class CompositionToolItems
extends ToolItems {
    public static final String NAME = "composition.items";
    private ToolItem tempo;
    private ToolItem timeSignature;
    private ToolItem repeatOpen;
    private ToolItem repeatClose;
    private ToolItem repeatAlternative;

    public CompositionToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.tempo = new ToolItem(toolBar, 8);
        this.tempo.addSelectionListener(TuxGuitar.instance().getAction("action.composition.change-tempo"));
        this.timeSignature = new ToolItem(toolBar, 8);
        this.timeSignature.addSelectionListener(TuxGuitar.instance().getAction("action.composition.change-time-signature"));
        new ToolItem(toolBar, 2);
        this.repeatOpen = new ToolItem(toolBar, 8);
        this.repeatOpen.addSelectionListener(TuxGuitar.instance().getAction("action.insert.open-repeat"));
        this.repeatClose = new ToolItem(toolBar, 8);
        this.repeatClose.addSelectionListener(TuxGuitar.instance().getAction("action.insert.close-repeat"));
        this.repeatAlternative = new ToolItem(toolBar, 8);
        this.repeatAlternative.addSelectionListener(TuxGuitar.instance().getAction("action.insert.repeat-alternative"));
        this.loadIcons();
        this.loadProperties();
    }

    public void loadProperties() {
        this.tempo.setToolTipText(TuxGuitar.getProperty("composition.tempo"));
        this.timeSignature.setToolTipText(TuxGuitar.getProperty("composition.timesignature"));
        this.repeatOpen.setToolTipText(TuxGuitar.getProperty("repeat.open"));
        this.repeatClose.setToolTipText(TuxGuitar.getProperty("repeat.close"));
        this.repeatAlternative.setToolTipText(TuxGuitar.getProperty("repeat.alternative"));
    }

    public void loadIcons() {
        this.tempo.setImage(TuxGuitar.instance().getIconManager().getCompositionTempo());
        this.timeSignature.setImage(TuxGuitar.instance().getIconManager().getCompositionTimeSignature());
        this.repeatOpen.setImage(TuxGuitar.instance().getIconManager().getCompositionRepeatOpen());
        this.repeatClose.setImage(TuxGuitar.instance().getIconManager().getCompositionRepeatClose());
        this.repeatAlternative.setImage(TuxGuitar.instance().getIconManager().getCompositionRepeatAlternative());
    }

    public void update() {
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.tempo.setEnabled(!bl);
        this.timeSignature.setEnabled(!bl);
        this.repeatOpen.setEnabled(!bl);
        this.repeatClose.setEnabled(!bl);
        this.repeatAlternative.setEnabled(!bl);
    }
}

