/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemBase;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.gui.items.ToolItems;
import org.herac.tuxguitar.gui.items.menu.BeatMenuItem;
import org.herac.tuxguitar.gui.items.menu.CompositionMenuItem;
import org.herac.tuxguitar.gui.items.menu.EditMenuItem;
import org.herac.tuxguitar.gui.items.menu.FileMenuItem;
import org.herac.tuxguitar.gui.items.menu.HelpMenuItem;
import org.herac.tuxguitar.gui.items.menu.LayoutMenuItem;
import org.herac.tuxguitar.gui.items.menu.MarkerMenuItem;
import org.herac.tuxguitar.gui.items.menu.MeasureMenuItem;
import org.herac.tuxguitar.gui.items.menu.ToolMenuItem;
import org.herac.tuxguitar.gui.items.menu.TrackMenuItem;
import org.herac.tuxguitar.gui.items.menu.TransportMenuItem;
import org.herac.tuxguitar.gui.items.tool.CompositionToolItems;
import org.herac.tuxguitar.gui.items.tool.DurationToolItems;
import org.herac.tuxguitar.gui.items.tool.DynamicToolItems;
import org.herac.tuxguitar.gui.items.tool.EditToolItems;
import org.herac.tuxguitar.gui.items.tool.FileToolItems;
import org.herac.tuxguitar.gui.items.tool.LayoutToolItems;
import org.herac.tuxguitar.gui.items.tool.MarkerToolItems;
import org.herac.tuxguitar.gui.items.tool.NoteEffectToolItems;
import org.herac.tuxguitar.gui.items.tool.NoteToolItems;
import org.herac.tuxguitar.gui.items.tool.PropertiesToolItems;
import org.herac.tuxguitar.gui.items.tool.TrackToolItems;
import org.herac.tuxguitar.gui.items.tool.TransportToolItems;
import org.herac.tuxguitar.gui.items.tool.ViewToolItems;
import org.herac.tuxguitar.gui.items.xml.ToolBarsReader;
import org.herac.tuxguitar.gui.items.xml.ToolBarsWriter;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.util.TGFileUtils;

public class ItemManager
implements IconLoader,
LanguageLoader {
    private static final int COOL_ITEM_HEIGHT = 32;
    private Menu menu;
    private Menu popupMenu;
    private CoolBar coolBar;
    private List loadedToolItems = new ArrayList();
    private List loadedMenuItems = new ArrayList();
    private List loadedPopupMenuItems = new ArrayList();
    private ToolItems[] toolItems;
    private boolean layout_locked = false;
    private boolean shouldReloadToolBars;

    public ItemManager() {
        this.setDefaultToolBars();
        this.loadItems();
        TuxGuitar.instance().getIconManager().addLoader(this);
        TuxGuitar.instance().getLanguageManager().addLoader(this);
    }

    public void loadItems() {
        this.createMenu();
        this.createPopupMenu();
        this.createCoolbar();
    }

    public void createCoolbar() {
        this.layout_locked = true;
        if (this.coolBar == null || this.coolBar.isDisposed()) {
            this.coolBar = new CoolBar(TuxGuitar.instance().getShell(), 0x800000);
            FormData formData = new FormData();
            formData.left = new FormAttachment(0);
            formData.right = new FormAttachment(100);
            formData.top = new FormAttachment(0, 0);
            this.coolBar.setLayoutData(formData);
            this.coolBar.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    ItemManager.this.layoutCoolBar();
                }
            });
            TuxGuitar.instance().getkeyBindingManager().appendListenersTo(this.coolBar);
        }
        this.makeCoolItems();
        this.layout_locked = false;
    }

    private void clearCoolBar() {
        if (this.coolBar != null && !this.coolBar.isDisposed()) {
            this.loadedToolItems.clear();
            CoolItem[] coolItemArray = this.coolBar.getItems();
            for (int i = 0; i < coolItemArray.length; ++i) {
                coolItemArray[i].dispose();
            }
            Control[] controlArray = this.coolBar.getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                controlArray[i].dispose();
            }
        }
    }

    protected void layoutCoolBar() {
        if (!this.layout_locked) {
            this.layout_locked = true;
            TuxGuitar.instance().getShell().layout();
            this.layout_locked = false;
        }
    }

    public void makeCoolItems() {
        this.clearCoolBar();
        this.readToolBars();
        for (int i = 0; i < this.toolItems.length; ++i) {
            if (!this.toolItems[i].isEnabled()) continue;
            this.makeToolBar(this.toolItems[i]);
        }
    }

    private void makeToolBar(ToolItems toolItems) {
        ToolBar toolBar = new ToolBar(this.coolBar, 0x800040);
        toolItems.showItems(toolBar);
        this.makeCoolItem(toolBar);
        this.loadedToolItems.add(toolItems);
    }

    private void makeCoolItem(ToolBar toolBar) {
        CoolItem coolItem = new CoolItem(this.coolBar, 0);
        coolItem.setControl(toolBar);
        Point point = toolBar.computeSize(-1, -1);
        Point point2 = coolItem.computeSize(point.x, 32);
        coolItem.setMinimumSize(point2);
        coolItem.setSize(point2);
    }

    public void createMenu() {
        Shell shell = TuxGuitar.instance().getShell();
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = new Menu(shell, 2);
        }
        MenuItem[] menuItemArray = this.menu.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            menuItemArray[i].dispose();
        }
        this.loadedMenuItems.clear();
        this.loadedMenuItems.add(new FileMenuItem(shell, this.menu, 64));
        this.loadedMenuItems.add(new EditMenuItem(shell, this.menu, 64));
        this.loadedMenuItems.add(new LayoutMenuItem(shell, this.menu, 64));
        this.loadedMenuItems.add(new CompositionMenuItem(shell, this.menu, 64));
        this.loadedMenuItems.add(new TrackMenuItem(shell, this.menu, 64));
        this.loadedMenuItems.add(new MeasureMenuItem(shell, this.menu, 64));
        this.loadedMenuItems.add(new BeatMenuItem(shell, this.menu, 64));
        this.loadedMenuItems.add(new MarkerMenuItem(shell, this.menu, 64));
        this.loadedMenuItems.add(new TransportMenuItem(shell, this.menu, 64));
        this.loadedMenuItems.add(new ToolMenuItem(shell, this.menu, 64));
        this.loadedMenuItems.add(new HelpMenuItem(shell, this.menu, 64));
        this.showMenuItems(this.loadedMenuItems);
        shell.setMenuBar(this.menu);
    }

    public void createPopupMenu() {
        Shell shell = TuxGuitar.instance().getShell();
        if (this.popupMenu == null || this.popupMenu.isDisposed()) {
            this.popupMenu = new Menu(shell, 8);
        }
        MenuItem[] menuItemArray = this.popupMenu.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            menuItemArray[i].dispose();
        }
        this.loadedPopupMenuItems.clear();
        this.loadedPopupMenuItems.add(new EditMenuItem(shell, this.popupMenu, 64));
        this.loadedPopupMenuItems.add(new CompositionMenuItem(shell, this.popupMenu, 64));
        this.loadedPopupMenuItems.add(new TrackMenuItem(shell, this.popupMenu, 64));
        this.loadedPopupMenuItems.add(new MeasureMenuItem(shell, this.popupMenu, 64));
        this.loadedPopupMenuItems.add(new BeatMenuItem(shell, this.popupMenu, 64));
        this.loadedPopupMenuItems.add(new MarkerMenuItem(shell, this.popupMenu, 64));
        this.loadedPopupMenuItems.add(new TransportMenuItem(shell, this.popupMenu, 64));
        this.showMenuItems(this.loadedPopupMenuItems);
    }

    private void showMenuItems(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MenuItems menuItems = (MenuItems)iterator.next();
            menuItems.showItems();
        }
    }

    public void updateItems() {
        if (!this.isDisposed()) {
            this.updateItems(this.loadedToolItems);
            this.updateItems(this.loadedMenuItems);
            this.updateItems(this.loadedPopupMenuItems);
        }
    }

    public void updateItems(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ItemBase itemBase = (ItemBase)iterator.next();
            itemBase.update();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.loadProperties(this.loadedToolItems);
            this.loadProperties(this.loadedMenuItems);
            this.loadProperties(this.loadedPopupMenuItems);
        }
    }

    public void loadProperties(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ItemBase itemBase = (ItemBase)iterator.next();
            itemBase.loadProperties();
        }
    }

    public void loadIcons() {
        this.loadItems();
    }

    public CoolBar getCoolbar() {
        return this.coolBar;
    }

    public Menu getPopupMenu() {
        return this.popupMenu;
    }

    public void readToolBars() {
        File file = new File(this.getCoolItemsFileName());
        if (!file.exists()) {
            this.writeToolBars();
        }
        this.shouldReloadToolBars = false;
        ToolBarsReader.loadToolBars(this, file);
    }

    public void writeToolBars() {
        File file = new File(this.getCoolItemsFileName());
        ToolBarsWriter.saveToolBars(this.getToolBars(), file);
    }

    public void setToolBarStatus(String string, boolean bl, int n) {
        if (n >= 0 && n < this.toolItems.length) {
            this.setToolBarPosition(string, n);
            this.setToolBarEnabled(n, bl);
        }
    }

    public void setToolBarEnabled(int n, boolean bl) {
        this.shouldReloadToolBars = this.shouldReloadToolBars || this.toolItems[n].isEnabled() != bl;
        this.toolItems[n].setEnabled(bl);
    }

    public void setToolBarPosition(String string, int n) {
        ToolItems toolItems;
        if (n >= 0 && n < this.toolItems.length && !(toolItems = this.toolItems[n]).getName().trim().toLowerCase().equals(string.trim().toLowerCase())) {
            int n2 = -1;
            for (int i = 0; i < this.toolItems.length; ++i) {
                if (!this.toolItems[i].getName().trim().toLowerCase().equals(string.trim().toLowerCase())) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                return;
            }
            this.toolItems[n] = this.toolItems[n2];
            this.toolItems[n2] = toolItems;
            this.shouldReloadToolBars = true;
        }
    }

    public ToolItems[] getToolBars() {
        return this.toolItems;
    }

    public boolean shouldReloadToolBars() {
        return this.shouldReloadToolBars;
    }

    public void setDefaultToolBars() {
        this.toolItems = new ToolItems[]{this.initToolItem(new FileToolItems(), true), this.initToolItem(new EditToolItems(), true), this.initToolItem(new PropertiesToolItems(), true), this.initToolItem(new TrackToolItems(), true), this.initToolItem(new DurationToolItems(), true), this.initToolItem(new NoteToolItems(), true), this.initToolItem(new CompositionToolItems(), true), this.initToolItem(new TransportToolItems(), true), this.initToolItem(new MarkerToolItems(), true), this.initToolItem(new LayoutToolItems(), true), this.initToolItem(new ViewToolItems(), true), this.initToolItem(new NoteEffectToolItems(), true), this.initToolItem(new DynamicToolItems(), true)};
        this.shouldReloadToolBars = true;
    }

    private ToolItems initToolItem(ToolItems toolItems, boolean bl) {
        toolItems.setEnabled(bl);
        return toolItems;
    }

    private boolean isDisposed() {
        return this.coolBar.isDisposed() || this.menu.isDisposed() || this.popupMenu.isDisposed();
    }

    private String getCoolItemsFileName() {
        return TGFileUtils.PATH_USER_CONFIG + File.separator + "toolbars.xml";
    }
}

