/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.help.doc;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.herac.tuxguitar.gui.help.doc.DocException;
import org.herac.tuxguitar.gui.help.doc.DocItem;
import org.herac.tuxguitar.gui.help.doc.DocItemReader;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.TGFileUtils;

public class DocDialog {
    private static final String URL_NOT_FOUND = "<html><body><h2 align=\"center\">URL Not Found!</h2></body></html>";
    private Shell dialog;
    private SashForm form;
    private Browser browser;
    protected Tree tree;

    public void show(Shell shell) throws DocException {
        try {
            this.dialog = DialogUtils.newDialog(shell, 2160);
            this.dialog.setLayout(new FillLayout());
            this.form = new SashForm(this.dialog, 65792);
            this.tree = new Tree(this.form, 2052);
            this.browser = new Browser(this.form, 2048);
            this.form.setWeights(new int[]{1, 4});
            this.initTreeItems();
            this.initTreeListener();
            this.initBrowserListener();
            DialogUtils.openDialog(this.dialog, 1);
        }
        catch (Throwable throwable) {
            throw new DocException(throwable);
        }
    }

    protected void showUrl(String string) {
        String string2 = this.parseURL(string);
        if (string2 != null) {
            this.browser.setUrl(string2);
        } else {
            this.browser.setText(URL_NOT_FOUND);
        }
    }

    protected void initBrowserListener() {
        this.browser.addLocationListener(new LocationAdapter(){

            public void changed(LocationEvent locationEvent) {
                DocDialog.this.findSelectedItem();
            }
        });
    }

    protected void initTreeListener() {
        this.tree.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeItem treeItem = (TreeItem)selectionEvent.item;
                Object object = treeItem.getData();
                if (object instanceof DocItem && ((DocItem)object).getUrl() != null) {
                    DocDialog.this.showUrl(((DocItem)object).getUrl());
                }
            }
        });
        this.tree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                TreeItem treeItem = DocDialog.this.tree.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (treeItem != null) {
                    DocDialog.this.tree.setCursor(DocDialog.this.tree.getDisplay().getSystemCursor(21));
                } else {
                    DocDialog.this.tree.setCursor(DocDialog.this.tree.getDisplay().getSystemCursor(0));
                }
            }
        });
    }

    protected void initTreeItems() {
        File file = this.getContentFile();
        if (file != null && file.exists()) {
            ArrayList arrayList = new ArrayList();
            new DocItemReader().loadHelpItems(arrayList, file);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                DocItem docItem = (DocItem)iterator.next();
                this.initSubItems(docItem, this.rootItem(docItem));
            }
        }
    }

    protected void initSubItems(DocItem docItem, TreeItem treeItem) {
        Iterator iterator = docItem.getChildren().iterator();
        while (iterator.hasNext()) {
            DocItem docItem2 = (DocItem)iterator.next();
            this.initSubItems(docItem2, this.subItem(treeItem, docItem2));
        }
    }

    protected TreeItem rootItem(DocItem docItem) {
        TreeItem treeItem = new TreeItem(this.tree, 0);
        treeItem.setText(docItem.getName());
        treeItem.setData(docItem);
        return treeItem;
    }

    protected TreeItem subItem(TreeItem treeItem, DocItem docItem) {
        TreeItem treeItem2 = new TreeItem(treeItem, 0);
        treeItem2.setText(docItem.getName());
        treeItem2.setData(docItem);
        return treeItem2;
    }

    protected void findSelectedItem() {
        try {
            String string = this.browser.getUrl();
            if (string != null && string.length() > 0) {
                String string2;
                Object object;
                boolean bl = false;
                String string3 = new URL(string).getFile();
                TreeItem[] treeItemArray = this.tree.getSelection();
                if (treeItemArray != null && treeItemArray.length > 0 && treeItemArray[0].getData() instanceof DocItem && ((DocItem)(object = (DocItem)treeItemArray[0].getData())).getUrl() != null && (string2 = this.parseURL(((DocItem)object).getUrl())) != null && string3.equals(string2)) {
                    bl = true;
                }
                if (!bl && (object = this.findSelectedItem(this.tree.getItems(), string3)) != null) {
                    this.tree.setSelection((TreeItem)object);
                }
            }
        }
        catch (Throwable throwable) {
            new DocException(throwable).printStackTrace();
        }
    }

    protected TreeItem findSelectedItem(TreeItem[] treeItemArray, String string) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            Object object;
            if (!(treeItemArray[i].getData() instanceof DocItem)) continue;
            DocItem docItem = (DocItem)treeItemArray[i].getData();
            if (docItem.getUrl() != null && (object = this.parseURL(docItem.getUrl())) != null && string.equals(object)) {
                return treeItemArray[i];
            }
            object = this.findSelectedItem(treeItemArray[i].getItems(), string);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public String parseURL(String string) {
        File file = new File(TGFileUtils.PATH_HELP + string);
        return file.exists() ? file.getAbsolutePath() : null;
    }

    private File getContentFile() {
        return new File(TGFileUtils.PATH_HELP + "contents.xml");
    }
}

