/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGChordImpl;
import org.herac.tuxguitar.gui.editors.tab.TGLyricImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintDocumentData;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGTrack;

public class PrinterViewLayout
extends ViewLayout {
    private static final int DEFAULT_SCORE_LINE_SPACING = 7;
    private static final int DEFAULT_STRING_SPACING = 8;
    private static final int DEFAULT_HORIZONTAL_SPACING = 15;
    private static final int MIN_SCORE_TAB_SPACING = 15;
    private static final int DEFAULT_TRACK_SPACING = 5;
    private static final int DEFAULT_FIRST_TRACK_SPACING = 5;
    private static final int DEFAULT_MIN_BUFFER_SEPARATOR = 15;
    private static final int DEFAULT_MIN_TOP_SPACING = 20;
    private static final int CHORD_FRET_INDEX_SPACING = 7;
    private static final int CHORD_STRING_SPACING = 4;
    private static final int CHORD_FRET_SPACING = 5;
    private PrintDocument document;
    private PrintDocumentData documentData;
    private Image image;

    public PrinterViewLayout(Tablature tablature, PrintDocumentData printDocumentData, float f) {
        super(tablature, printDocumentData.getStyle() | 1, f);
        this.documentData = printDocumentData;
    }

    protected void init(float f) {
        this.setFirstMeasureSpacing(this.getScaledValue(f, 15));
        this.setMinBufferSeparator(this.getScaledValue(f, 15));
        this.setMinTopSpacing(this.getScaledValue(f, 20));
        this.setMinScoreTabSpacing(this.getScaledValue(f, 15));
        this.setScoreLineSpacing(this.getScaledValue(f, 7, 4));
        this.setScoreSpacing(this.getScoreLineSpacing() * 4 + this.getMinScoreTabSpacing());
        this.setFirstTrackSpacing(this.getScaledValue(f, 5));
        this.setTrackSpacing(this.getScaledValue(f, 5));
        this.setStringSpacing(this.getScaledValue(f, 8, 4));
        this.setChordFretIndexSpacing(this.getScaledValue(f, 7));
        this.setChordStringSpacing(this.getScaledValue(f, 4));
        this.setChordFretSpacing(this.getScaledValue(f, 5));
        this.setChordNoteSize(this.getScaledValue(f, 4));
        this.setRepeatEndingSpacing(this.getScaledValue(f, 20));
        this.setEffectSpacing(this.getScaledValue(f, 8));
        this.setScale(this.checkScale());
        this.setFontScale(f);
        this.getTablature().setViewLayout(this);
        this.getTablature().initDefaults();
    }

    public int getMode() {
        return 0;
    }

    public PrintDocument makeDocument(int n, int n2) {
        return this.makeDocument(new Point(n, n2));
    }

    public PrintDocument makeDocument(Point point) {
        this.document = new PrintDocument();
        this.document.setPageSize(point);
        this.image = new Image((Device)this.getTablature().getDisplay(), new Rectangle(0, 0, this.document.getPageSize().x, this.document.getPageSize().y));
        TGPainter tGPainter = new TGPainter(new GC(this.image));
        this.paintHeader(tGPainter);
        this.paintSong(tGPainter, null, 0, Math.round(80.0f * this.getFontScale()));
        tGPainter.dispose();
        this.image.dispose();
        return this.document;
    }

    private void makePage(TGPainter tGPainter) {
        String string = Integer.toString(this.document.count() + 1);
        tGPainter.setBackground(this.getTablature().getDisplay().getSystemColor(1));
        tGPainter.setForeground(this.getTablature().getDisplay().getSystemColor(2));
        tGPainter.drawString(string, this.getRight(tGPainter, string), this.getBottom(tGPainter, string));
        this.document.makePage(this.image.getImageData());
        tGPainter.initPath(2);
        tGPainter.addRectangle(new Rectangle(0, 0, this.document.getPageSize().x, this.document.getPageSize().y));
        tGPainter.closePath();
    }

    public void paintHeader(TGPainter tGPainter) {
        String string = this.getSongManager().getSong().getName();
        String string2 = this.getSongManager().getSong().getAuthor();
        String string3 = "(" + this.getSongManager().getTrack(this.documentData.getTrackNumber()).getName() + ")";
        if (string == null || string.length() == 0) {
            string = TuxGuitar.getProperty("print-header.default-song-name");
        }
        if (string2 == null || string2.length() == 0) {
            string2 = TuxGuitar.getProperty("print-header.default-song-author");
        }
        Font font = new Font((Device)this.getTablature().getDisplay(), "Sans", Math.round(16.0f * this.getFontScale()), 0x1000001);
        Font font2 = new Font((Device)this.getTablature().getDisplay(), "Sans", Math.round(8.0f * this.getFontScale()), 0x1000001);
        Font font3 = new Font((Device)this.getTablature().getDisplay(), "Sans", Math.round(8.0f * this.getFontScale()), 0x1000001);
        tGPainter.setFont(font);
        tGPainter.drawString(string, this.getCenter(tGPainter, string), 0);
        tGPainter.setFont(font2);
        tGPainter.drawString(string3, this.getCenter(tGPainter, string3), Math.round(30.0f * this.getFontScale()));
        tGPainter.setFont(font3);
        tGPainter.drawString(string2, this.getRight(tGPainter, string2), Math.round(50.0f * this.getFontScale()));
        font.dispose();
        font2.dispose();
        font3.dispose();
    }

    private int getCenter(TGPainter tGPainter, String string) {
        int n = tGPainter.getStringExtent((String)string).x;
        return (this.getMaxWidth() - n) / 2;
    }

    private int getRight(TGPainter tGPainter, String string) {
        int n = tGPainter.getStringExtent((String)string).x;
        return this.getMaxWidth() - n;
    }

    private int getBottom(TGPainter tGPainter, String string) {
        int n = tGPainter.getStringExtent((String)string).y;
        return this.getMaxHeight() - n;
    }

    public void paintSong(TGPainter tGPainter, Rectangle rectangle, int n, int n2) {
        this.setWidth(0);
        this.setHeight(0);
        int n3 = this.getStyle();
        int n4 = n2 + this.getFirstTrackSpacing();
        int n5 = this.getFirstTrackSpacing();
        int n6 = 0;
        TGTrackImpl tGTrackImpl = (TGTrackImpl)this.getSongManager().getTrack(this.documentData.getTrackNumber());
        ((TGLyricImpl)tGTrackImpl.getLyrics()).start(this.getSkippedBeats(tGTrackImpl));
        TrackSpacing trackSpacing = new TrackSpacing(this);
        TempLine tempLine = this.getTempLines(tGTrackImpl, this.documentData.getFromMeasure() - 1, trackSpacing);
        while (!tempLine.measures.isEmpty()) {
            trackSpacing.setSize(6, (n3 & 4) != 0 ? this.getScoreLineSpacing() * 5 : 0);
            if ((n3 & 4) != 0) {
                trackSpacing.setSize(5, Math.abs(tempLine.minY));
                if (tempLine.maxY + this.getMinScoreTabSpacing() > this.getScoreSpacing()) {
                    trackSpacing.setSize(7, tempLine.maxY - this.getScoreLineSpacing() * 4);
                }
            }
            if ((n3 & 8) != 0) {
                trackSpacing.setSize(15, (n3 & 4) != 0 ? this.getMinScoreTabSpacing() : this.getStringSpacing());
                trackSpacing.setSize(16, (n3 & 4) != 0 ? tGTrackImpl.getTabHeight() + this.getStringSpacing() + 1 : tGTrackImpl.getTabHeight() + this.getStringSpacing() / 2 * 5 + 1);
            }
            trackSpacing.setSize(17, 10);
            this.checkDefaultSpacing(trackSpacing);
            n6 = trackSpacing.getSize();
            if (n4 + n6 + this.getTrackSpacing() > this.getMaxHeight()) {
                this.makePage(tGPainter);
                n4 = this.getFirstTrackSpacing();
            }
            this.paintLine(tGTrackImpl, tempLine, tGPainter, n, n4, trackSpacing);
            n4 += n6 + this.getTrackSpacing();
            n5 += n6 + this.getTrackSpacing();
            trackSpacing = new TrackSpacing(this);
            tempLine = this.getTempLines(tGTrackImpl, tempLine.lastIndex + 1, trackSpacing);
        }
        this.makePage(tGPainter);
        this.setHeight(n5);
    }

    public void paintLine(TGTrackImpl tGTrackImpl, TempLine tempLine, TGPainter tGPainter, int n, int n2, TrackSpacing trackSpacing) {
        int n3;
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        int n7 = 0;
        if (tempLine.fullLine && (n3 = this.getMaxWidth() - tempLine.tempWith) != 0 && tempLine.measures.size() > 0) {
            n7 = n3 / tempLine.measures.size();
        }
        for (n3 = 0; n3 < tempLine.measures.size(); ++n3) {
            int n8 = (Integer)tempLine.measures.get(n3);
            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)tGTrackImpl.getMeasure(n8);
            tGMeasureImpl.setPosX(n4);
            tGMeasureImpl.setPosY(n5);
            tGMeasureImpl.setTs(trackSpacing);
            ((TGLyricImpl)tGTrackImpl.getLyrics()).setCurrentMeasure(tGMeasureImpl);
            tGMeasureImpl.setFirstOfLine(n3 == 0);
            this.paintMeasure(tGMeasureImpl, tGPainter, n7);
            ((TGLyricImpl)tGTrackImpl.getLyrics()).paintCurrentNoteBeats(tGPainter, this, tGMeasureImpl, n4, n5);
            int n9 = tGMeasureImpl.getWidth(this) + tGMeasureImpl.getSpacing();
            n4 += n9;
            n6 += n9;
        }
        this.setWidth(Math.max(this.getWidth(), n6));
    }

    public TempLine getTempLines(TGTrack tGTrack, int n, TrackSpacing trackSpacing) {
        TempLine tempLine = new TempLine();
        int n2 = tGTrack.countMeasures();
        for (int i = n; i < n2; ++i) {
            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)tGTrack.getMeasure(i);
            if (tGMeasureImpl.getNumber() < this.documentData.getFromMeasure() || tGMeasureImpl.getNumber() > this.documentData.getToMeasure()) continue;
            if (tempLine.tempWith + tGMeasureImpl.getWidth(this) >= this.getMaxWidth() && !tempLine.measures.isEmpty()) {
                tempLine.fullLine = true;
                return tempLine;
            }
            tempLine.tempWith += tGMeasureImpl.getWidth(this);
            tempLine.maxY = tGMeasureImpl.getMaxY() > tempLine.maxY ? tGMeasureImpl.getMaxY() : tempLine.maxY;
            tempLine.minY = tGMeasureImpl.getMinY() < tempLine.minY ? tGMeasureImpl.getMinY() : tempLine.minY;
            tempLine.addMeasure(i);
            tGMeasureImpl.registerEffects(this, trackSpacing);
        }
        return tempLine;
    }

    public int getSkippedBeats(TGTrack tGTrack) {
        int n = 0;
        for (int i = 0; i < this.documentData.getFromMeasure() - 1; ++i) {
            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)tGTrack.getMeasure(i);
            n += tGMeasureImpl.getNotEmptyBeats();
        }
        return n;
    }

    public boolean isCaretVisible() {
        return false;
    }

    public boolean isPlayModeEnabled() {
        return false;
    }

    public void setTabNoteStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setForeground(bl ? this.getResources().getPlayNoteColor() : this.getResources().getTabNoteColor());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setFont(this.getResources().getPrinterNoteFont());
    }

    public void setTimeSignatureStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getPrinterTimeSignatureFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(TuxGuitar.instance().getDisplay().getSystemColor(2));
    }

    public void setGraceStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getPrinterGraceFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
    }

    public void setLyricStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setFont(this.getResources().getPrinterLyricFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(bl ? this.getResources().getPlayNoteColor() : TuxGuitar.instance().getDisplay().getSystemColor(2));
    }

    public void setTextStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getPrinterTextFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(TuxGuitar.instance().getDisplay().getSystemColor(2));
    }

    public void setChordStyle(TGPainter tGPainter, TGChordImpl tGChordImpl) {
        tGPainter.setFont(this.getResources().getPrinterChordFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(TuxGuitar.instance().getDisplay().getSystemColor(2));
        tGChordImpl.setStyle(this.getStyle());
        tGChordImpl.setBackgroundColor(this.getResources().getBackgroundColor());
        tGChordImpl.setColor(this.getResources().getLineColor());
        tGChordImpl.setNoteColor(this.getResources().getTabNoteColor());
        tGChordImpl.setTonicColor(this.getResources().getTabNoteColor());
        tGChordImpl.setFretSpacing(this.getChordFretSpacing());
        tGChordImpl.setStringSpacing(this.getChordStringSpacing());
        tGChordImpl.setNoteSize(this.getChordNoteSize());
        tGChordImpl.setFirstFretSpacing(0);
        tGChordImpl.setFirstFretFont(null);
    }

    public int getMaxWidth() {
        return this.document.getPageSize().x - 10;
    }

    public int getMaxHeight() {
        return this.document.getPageSize().y - 10;
    }

    public boolean isFirstMeasure(TGMeasure tGMeasure) {
        return tGMeasure.getNumber() == this.documentData.getFromMeasure();
    }

    public boolean isLastMeasure(TGMeasure tGMeasure) {
        return tGMeasure.getNumber() == this.documentData.getToMeasure();
    }

    private int getScaledValue(float f, int n) {
        return this.getScaledValue(f, n, 1);
    }

    private int getScaledValue(float f, int n, int n2) {
        float f2 = (float)n * f;
        return Math.max(Math.round(f2), n2);
    }

    private class TempLine {
        protected int tempWith;
        protected int lastIndex;
        protected boolean fullLine;
        protected int maxY = 0;
        protected int minY = 50;
        protected List measures = new ArrayList();

        protected void addMeasure(int n) {
            this.measures.add(new Integer(n));
            this.lastIndex = n;
        }
    }
}

