/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGBeatGroup;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureBuffer;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureHeaderImpl;
import org.herac.tuxguitar.gui.editors.tab.TGNoteImpl;
import org.herac.tuxguitar.gui.editors.tab.TGResources;
import org.herac.tuxguitar.gui.editors.tab.TGTextImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.editors.tab.TablatureUtil;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.editors.tab.painters.TGClefPainter;
import org.herac.tuxguitar.gui.editors.tab.painters.TGKeySignaturePainter;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGTupleto;

public class TGMeasureImpl
extends TGMeasure {
    public static final int[] SCORE_KEY_OFFSETS = new int[]{30, 18, 22, 24};
    public static final int[] SCORE_KEY_SHARP_POSITIONS = new int[]{1, 4, 0, 3, 6, 2, 5};
    public static final int[] SCORE_KEY_FLAT_POSITIONS = new int[]{5, 2, 6, 3, 0, 4, 1};
    private static final int DEFAULT_CLEF_SPACING = 40;
    private static final int DEFAULT_QUARTER_SPACING = 30;
    private int posX;
    private int posY;
    private int quarterSpacing;
    private long divisionLength;
    private boolean paintClef = true;
    private boolean paintKeySignature = true;
    private TGMeasure prevMeasure;
    private boolean outOfBounds;
    private boolean firstOfLine;
    private boolean compactMode;
    private int spacing;
    private TrackSpacing ts;
    private int maxY;
    private int minY;
    private int notEmptyBeats;
    private int widthBeats = 0;
    private List beatGroups = new ArrayList();
    private TGMeasureBuffer buffer;
    private boolean cacheEnabled;
    private int lyricBeatIndex;
    private int width;
    private boolean text;
    private boolean chord;
    private boolean accentuated;
    private boolean harmonic;
    private boolean tapping;
    private boolean palmMute;
    private boolean vibrato;
    private boolean tupleto;
    private boolean fadeIn;

    public TGMeasureImpl(TGMeasureHeader tGMeasureHeader) {
        super(tGMeasureHeader);
    }

    public void create(ViewLayout viewLayout) {
        this.divisionLength = TGSongManager.getDivisionLength(this.getHeader());
        this.checkCompactMode(viewLayout);
        this.resetEffects();
        this.autoCompleteSilences(viewLayout.getSongManager());
        this.calculateMeasureChanges(viewLayout);
        this.calculateBeats(viewLayout);
        this.calculateWidth(viewLayout);
        this.setFirstOfLine(false);
    }

    public void update(ViewLayout viewLayout) {
        this.orderBeats(viewLayout.getSongManager());
        this.updateComponents(viewLayout);
        this.setOutOfBounds(true);
        this.setCacheEnabled(false);
    }

    private void checkCompactMode(ViewLayout viewLayout) {
        boolean bl;
        boolean bl2 = bl = (viewLayout.getStyle() & 1) != 0;
        if (bl && (viewLayout.getStyle() & 2) != 0) {
            bl = viewLayout.getSongManager().getSong().countTracks() == 1;
        }
        this.compactMode = bl;
    }

    public void calculateWidth(ViewLayout viewLayout) {
        if (this.compactMode) {
            this.width = this.widthBeats;
        } else {
            double d = 1.0 / (double)this.getTimeSignature().getDenominator().getValue() * 4.0 * (double)this.getTimeSignature().getNumerator();
            this.width = (int)((double)this.getQuarterSpacing() * d);
        }
        this.width += this.getFirstNoteSpacing(viewLayout);
        this.width += this.getRepeatClose() > 0 ? 20 : 0;
        this.width += this.getHeaderImpl().getLeftSpacing(viewLayout);
        this.width += this.getHeaderImpl().getRightSpacing(viewLayout);
        this.getHeaderImpl().notifyWidth(this.width);
    }

    private void calculateBeats(ViewLayout viewLayout) {
        int n;
        TGChord tGChord = null;
        TGDuration tGDuration = null;
        TGBeatImpl tGBeatImpl = null;
        TGBeatGroup tGBeatGroup = null;
        int n2 = viewLayout.getStyle();
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = (n2 & 0x30) != 0;
        this.widthBeats = 0;
        this.notEmptyBeats = 0;
        this.beatGroups.clear();
        for (n = 0; n < this.countBeats(); ++n) {
            TGBeatImpl tGBeatImpl2 = (TGBeatImpl)this.getBeat(n);
            tGBeatImpl2.reset();
            if (tGDuration == null || tGBeatImpl2.getDuration().getTime() <= tGDuration.getTime()) {
                tGDuration = tGBeatImpl2.getDuration();
            }
            bl = true;
            Iterator iterator = tGBeatImpl2.getNotes().iterator();
            while (iterator.hasNext()) {
                TGNoteImpl tGNoteImpl = (TGNoteImpl)iterator.next();
                tGBeatImpl2.check(tGNoteImpl);
                if (tGBeatGroup == null || bl && !this.canJoin(viewLayout.getSongManager(), tGBeatImpl2, tGBeatImpl)) {
                    tGBeatGroup = new TGBeatGroup();
                    this.beatGroups.add(tGBeatGroup);
                }
                tGBeatGroup.check(tGNoteImpl, this.getClef());
                tGNoteImpl.setBeatGroup(tGBeatGroup);
                bl = false;
            }
            if (bl2 && tGBeatImpl2.getChord() != null) {
                if (tGChord != null) {
                    int n4 = (int)(tGBeatImpl2.getStart() - tGChord.getBeat().getStart());
                    n3 = n3 > 0 ? Math.min(n3, Math.abs(n4)) : n4;
                }
                tGChord = tGBeatImpl2.getChord();
            }
            this.makeBeat(viewLayout, tGBeatImpl2, tGBeatImpl, tGBeatGroup, bl2);
            tGBeatImpl = tGBeatImpl2;
        }
        if (!this.compactMode) {
            int n5 = this.quarterSpacing = tGDuration != null ? viewLayout.getSpacingForQuarter(tGDuration) : Math.round(30.0f * viewLayout.getScale());
            if (bl2 && n3 > 0) {
                n = viewLayout.getChordFretIndexSpacing() + viewLayout.getChordStringSpacing() + this.getTrack().stringCount() * viewLayout.getChordStringSpacing();
                int n6 = (int)(1000L * (long)n / (long)n3);
                this.quarterSpacing = Math.max(n6, this.quarterSpacing);
            }
            this.getHeaderImpl().notifyQuarterSpacing(this.quarterSpacing);
        }
    }

    public boolean canJoin(TGSongManager tGSongManager, TGBeatImpl tGBeatImpl, TGBeatImpl tGBeatImpl2) {
        if (tGBeatImpl == null || tGBeatImpl2 == null || tGBeatImpl.isRestBeat() || tGBeatImpl2.isRestBeat()) {
            return false;
        }
        long l = this.getDivisionLength();
        long l2 = this.getStart();
        long l3 = tGSongManager.getMeasureManager().getRealStart(this, tGBeatImpl.getStart()) - l2;
        long l4 = tGSongManager.getMeasureManager().getRealStart(this, tGBeatImpl2.getStart()) - l2;
        if (tGBeatImpl.getDuration().getValue() < 8 || tGBeatImpl2.getDuration().getValue() < 8) {
            return l3 == l4;
        }
        long l5 = (l + l3) / l;
        long l6 = (l + l4) / l;
        return l5 == l6;
    }

    private void makeBeat(ViewLayout viewLayout, TGBeatImpl tGBeatImpl, TGBeatImpl tGBeatImpl2, TGBeatGroup tGBeatGroup, boolean bl) {
        tGBeatImpl.setWidth((int)viewLayout.getBeatWidth(tGBeatImpl));
        tGBeatImpl.setBeatGroup(tGBeatGroup);
        this.notEmptyBeats += tGBeatImpl.isRestBeat() ? 0 : 1;
        this.widthBeats += tGBeatImpl.getWidth();
        if (tGBeatImpl2 != null) {
            tGBeatImpl.setPreviousBeat(tGBeatImpl2);
            tGBeatImpl2.setNextBeat(tGBeatImpl);
            if (bl && tGBeatImpl.isChordBeat() && tGBeatImpl2.isChordBeat()) {
                int n = tGBeatImpl2.getWidth();
                int n2 = viewLayout.getChordFretIndexSpacing() + viewLayout.getChordStringSpacing() + this.getTrack().stringCount() * viewLayout.getChordStringSpacing();
                tGBeatImpl2.setWidth(Math.max(n2, n));
                this.widthBeats -= n;
                this.widthBeats += tGBeatImpl2.getWidth();
            }
        }
    }

    public void calculateMeasureChanges(ViewLayout viewLayout) {
        this.paintClef = false;
        this.paintKeySignature = false;
        if ((viewLayout.getStyle() & 4) != 0) {
            TGMeasure tGMeasure = this.prevMeasure = viewLayout.isFirstMeasure(this) ? null : (TGMeasureImpl)viewLayout.getSongManager().getTrackManager().getPrevMeasure(this);
            if (this.prevMeasure == null || this.getClef() != this.prevMeasure.getClef()) {
                this.paintClef = true;
                this.getHeaderImpl().notifyClefSpacing(Math.round(40.0f * viewLayout.getScale()));
            }
            if (this.prevMeasure == null || this.getKeySignature() != this.prevMeasure.getKeySignature()) {
                this.paintKeySignature = true;
                this.getHeaderImpl().notifyKeySignatureSpacing(this.calculateKeySignatureSpacing(viewLayout));
            }
        }
    }

    private void autoCompleteSilences(TGSongManager tGSongManager) {
        tGSongManager.getMeasureManager().autoCompleteSilences(this);
    }

    private void updateComponents(ViewLayout viewLayout) {
        Object object;
        int n;
        this.maxY = 0;
        this.minY = 0;
        int n2 = n = this.getHeaderImpl().getFirstNoteSpacing(viewLayout);
        for (int i = 0; i < this.countBeats(); ++i) {
            object = (TGBeatImpl)this.getBeat(i);
            ((TGBeatImpl)object).update(viewLayout);
            if (this.compactMode) {
                ((TGBeatImpl)object).setPosX(n2);
                n2 += ((TGBeatImpl)object).getWidth();
            } else {
                int n3 = this.getMaxQuarterSpacing(viewLayout);
                int n4 = n + TablatureUtil.getStartPosition(this, ((TGBeat)object).getStart(), n3);
                int n5 = n + TablatureUtil.getStartPosition(this, ((TGBeat)object).getStart() + ((TGBeat)object).getDuration().getTime(), n3);
                ((TGBeatImpl)object).setPosX(n4);
                ((TGBeatImpl)object).setWidth(n5 - n4);
            }
            Iterator iterator = ((TGBeat)object).getNotes().iterator();
            while (iterator.hasNext()) {
                TGNoteImpl tGNoteImpl = (TGNoteImpl)iterator.next();
                this.checkEffects(viewLayout, tGNoteImpl.getEffect());
                tGNoteImpl.update(viewLayout);
            }
            ((TGBeatImpl)object).update(viewLayout);
            if (!this.chord && ((TGBeat)object).isChordBeat()) {
                this.chord = true;
            }
            if (!this.text && ((TGBeat)object).isTextBeat()) {
                this.text = true;
            }
            if (this.tupleto || ((TGBeat)object).getDuration().getTupleto().isEqual(TGTupleto.NORMAL)) continue;
            this.tupleto = true;
        }
        Iterator iterator = this.beatGroups.iterator();
        while (iterator.hasNext()) {
            object = (TGBeatGroup)iterator.next();
            this.checkValue(viewLayout, ((TGBeatGroup)object).getMinNote(), ((TGBeatGroup)object).getDirection());
            this.checkValue(viewLayout, ((TGBeatGroup)object).getMaxNote(), ((TGBeatGroup)object).getDirection());
        }
    }

    private void checkValue(ViewLayout viewLayout, TGNoteImpl tGNoteImpl, int n) {
        int n2 = tGNoteImpl.getScorePosY();
        float f = TGBeatGroup.getUpOffset(viewLayout);
        float f2 = TGBeatGroup.getDownOffset(viewLayout);
        if (n == 1 && n2 > this.maxY) {
            this.maxY = n2;
        } else if (n == 2 && (float)n2 + f2 > (float)this.maxY) {
            this.maxY = (int)((float)n2 + f2 + 2.0f);
        }
        if (n == 1 && (float)n2 - f < (float)this.minY) {
            this.minY = (int)((float)n2 - f - 2.0f);
        } else if (n == 2 && n2 < this.minY) {
            this.minY = n2;
        }
    }

    private void checkEffects(ViewLayout viewLayout, TGNoteEffect tGNoteEffect) {
        if (tGNoteEffect.isAccentuatedNote() || tGNoteEffect.isHeavyAccentuatedNote()) {
            this.accentuated = true;
        }
        if (tGNoteEffect.isHarmonic() && (viewLayout.getStyle() & 4) == 0) {
            this.harmonic = true;
        }
        if (tGNoteEffect.isTapping() || tGNoteEffect.isSlapping() || tGNoteEffect.isPopping()) {
            this.tapping = true;
        }
        if (tGNoteEffect.isPalmMute()) {
            this.palmMute = true;
        }
        if (tGNoteEffect.isFadeIn()) {
            this.fadeIn = true;
        }
        if (tGNoteEffect.isVibrato() || tGNoteEffect.isTrill()) {
            this.vibrato = true;
        }
    }

    private void resetEffects() {
        this.text = false;
        this.chord = false;
        this.tupleto = false;
        this.accentuated = false;
        this.harmonic = false;
        this.tapping = false;
        this.palmMute = false;
        this.fadeIn = false;
        this.vibrato = false;
    }

    public void registerEffects(ViewLayout viewLayout, TrackSpacing trackSpacing) {
        float f = viewLayout.getScale();
        if (this.chord) {
            trackSpacing.setSize(4, viewLayout.getDefaultChordSpacing());
        }
        if (this.text) {
            trackSpacing.setSize(1, Math.round(15.0f * f));
        }
        if (this.getHeader().getRepeatAlternative() > 0) {
            trackSpacing.setSize(3, Math.round((float)viewLayout.getRepeatEndingSpacing() * f));
        }
        if (this.tupleto) {
            trackSpacing.setSize(8, Math.round(10.0f * f));
        }
        if (this.accentuated) {
            trackSpacing.setSize(9, Math.round((float)viewLayout.getEffectSpacing() * f));
        }
        if (this.harmonic) {
            trackSpacing.setSize(10, Math.round((float)viewLayout.getEffectSpacing() * f));
        }
        if (this.tapping) {
            trackSpacing.setSize(11, Math.round((float)viewLayout.getEffectSpacing() * f));
        }
        if (this.palmMute) {
            trackSpacing.setSize(12, Math.round((float)viewLayout.getEffectSpacing() * f));
        }
        if (this.fadeIn) {
            trackSpacing.setSize(14, Math.round((float)viewLayout.getEffectSpacing() * f));
        }
        if (this.vibrato) {
            trackSpacing.setSize(13, Math.round((float)viewLayout.getEffectSpacing() * f));
        }
    }

    private void orderBeats(TGSongManager tGSongManager) {
        tGSongManager.getMeasureManager().orderBeats(this);
    }

    public void paintMeasure(ViewLayout viewLayout, TGPainter tGPainter) {
        this.setOutOfBounds(false);
        if (this.shouldRepaint()) {
            this.getBuffer().makeBuffer(this.getWidth(viewLayout) + this.getSpacing(), this.getTs().getSize(), viewLayout.getResources().getBackgroundColor());
            TGPainter tGPainter2 = this.getBuffer().getPainter();
            viewLayout.paintLines(this.getTrackImpl(), this.getTs(), tGPainter2, 0, 0, this.getWidth(viewLayout) + this.getSpacing());
            this.paintTimeSignature(viewLayout, tGPainter2);
            this.paintClef(viewLayout, tGPainter2);
            this.paintKeySignature(viewLayout, tGPainter2);
            this.paintComponents(viewLayout, tGPainter2);
            this.setCacheEnabled(true);
        }
        tGPainter.setBackground(viewLayout.getResources().getBackgroundColor());
        this.getBuffer().paintImage(tGPainter, this.getPosX(), this.getPosY(), this.getTs().getPosition(2));
        this.paintTexts(viewLayout, tGPainter);
        this.paintTempo(viewLayout, tGPainter);
        this.paintTripletFeel(viewLayout, tGPainter);
        this.paintDivisions(viewLayout, tGPainter);
        this.paintRepeatEnding(viewLayout, tGPainter);
        this.paintPlayMode(viewLayout, tGPainter);
    }

    private boolean shouldRepaint() {
        return this.isDisposed() || !this.isCacheEnabled();
    }

    public void paintRepeatEnding(ViewLayout viewLayout, TGPainter tGPainter) {
        if (this.getHeader().getRepeatAlternative() > 0) {
            float f = viewLayout.getScale();
            float f2 = this.getPosX() + this.getHeaderImpl().getLeftSpacing(viewLayout) + this.getHeaderImpl().getFirstNoteSpacing(viewLayout);
            float f3 = this.getPosX() + this.getWidth(viewLayout) + this.getSpacing();
            float f4 = this.getPosY() + this.getTs().getPosition(3);
            float f5 = f4 + (float)viewLayout.getRepeatEndingSpacing() * 0.75f * f;
            String string = new String();
            for (int i = 0; i < 8; ++i) {
                if ((this.getHeader().getRepeatAlternative() & 1 << i) == 0) continue;
                string = string + (string.length() > 0 ? ", " + Integer.toString(i + 1) : Integer.toString(i + 1));
            }
            viewLayout.setRepeatEndingStyle(tGPainter);
            tGPainter.initPath();
            tGPainter.moveTo(f2, f5);
            tGPainter.lineTo(f2, f4);
            tGPainter.lineTo(f3, f4);
            tGPainter.closePath();
            tGPainter.drawString(string, Math.round(f2 + 5.0f * f), Math.round(f4 + 2.0f * f));
        }
    }

    public void paintComponents(ViewLayout viewLayout, TGPainter tGPainter) {
        Iterator iterator = this.getBeats().iterator();
        while (iterator.hasNext()) {
            TGBeatImpl tGBeatImpl = (TGBeatImpl)iterator.next();
            tGBeatImpl.paint(viewLayout, tGPainter, this.getHeaderImpl().getLeftSpacing(viewLayout), 0);
        }
    }

    private void paintDivisions(ViewLayout viewLayout, TGPainter tGPainter) {
        int n = this.getPosX();
        int n2 = this.getPosX() + this.getWidth(viewLayout);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = viewLayout.getStyle();
        boolean bl = false;
        if ((n6 & 4) != 0) {
            n3 = this.getPosY() + this.getTs().getPosition(6);
            n4 = n3 + viewLayout.getScoreLineSpacing() * 4;
            bl = true;
            if ((n6 & 8) != 0 && (viewLayout.isFirstMeasure(this) || this.isFirstOfLine())) {
                n5 = this.getPosY() + this.getTs().getPosition(16) - n4;
            }
            this.paintDivisions(viewLayout, tGPainter, n, n3, n2, n4, n5, bl);
        }
        if ((n6 & 8) != 0) {
            n3 = this.getPosY() + this.getTs().getPosition(16);
            n4 = n3 + (this.getTrack().getStrings().size() - 1) * viewLayout.getStringSpacing();
            bl = (n6 & 4) == 0;
            n5 = 0;
            this.paintDivisions(viewLayout, tGPainter, n, n3, n2, n4, n5, bl);
        }
    }

    private void paintDivisions(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (bl) {
            String string = Integer.toString(this.getNumber());
            viewLayout.setMeasureNumberStyle(tGPainter);
            tGPainter.drawString(string, this.getPosX() + 1, n2 - tGPainter.getStringExtent((String)string).y);
        }
        viewLayout.setDivisionsStyle(tGPainter, true);
        if (this.isRepeatOpen() || viewLayout.isFirstMeasure(this)) {
            tGPainter.initPath();
            tGPainter.moveTo(n + 1, n2);
            tGPainter.lineTo(n + 1, n4 + n5);
            tGPainter.setLineWidth(3);
            tGPainter.closePath();
            tGPainter.initPath();
            tGPainter.moveTo(n + 4, n2);
            tGPainter.lineTo(n + 4, n4 + n5);
            tGPainter.setLineWidth(1);
            tGPainter.closePath();
            if (this.isRepeatOpen()) {
                int n6 = 4;
                tGPainter.setLineWidth(1);
                tGPainter.initPath(2);
                tGPainter.moveTo(n + 7, n2 + (n4 - n2) / 2 - (7 + n6 / 2));
                tGPainter.addOval(n + 7, n2 + (n4 - n2) / 2 - (7 + n6 / 2), n6, n6);
                tGPainter.moveTo(n + 7, n2 + (n4 - n2) / 2 + (7 - n6 / 2));
                tGPainter.addOval(n + 7, n2 + (n4 - n2) / 2 + (7 - n6 / 2), n6, n6);
                tGPainter.closePath();
            }
        } else {
            tGPainter.initPath();
            tGPainter.moveTo(n, n2);
            tGPainter.lineTo(n, n4 + n5);
            tGPainter.setLineWidth(1);
            tGPainter.closePath();
        }
        if (this.getRepeatClose() > 0 || viewLayout.isLastMeasure(this)) {
            if (this.getRepeatClose() > 0) {
                int n7 = 4;
                tGPainter.initPath(2);
                tGPainter.moveTo(n3 - 10 + this.getSpacing(), n2 + (n4 - n2) / 2 - (7 + n7 / 2));
                tGPainter.addOval(n3 - 10 + this.getSpacing(), n2 + (n4 - n2) / 2 - (7 + n7 / 2), n7, n7);
                tGPainter.moveTo(n3 - 10 + this.getSpacing(), n2 + (n4 - n2) / 2 + (7 - n7 / 2));
                tGPainter.addOval(n3 - 10 + this.getSpacing(), n2 + (n4 - n2) / 2 + (7 - n7 / 2), n7, n7);
                tGPainter.setBackground(TuxGuitar.instance().getDisplay().getSystemColor(2));
                tGPainter.setLineWidth(1);
                tGPainter.closePath();
                if (bl) {
                    viewLayout.setDivisionsStyle(tGPainter, false);
                    String string = "x" + Integer.toString(this.getRepeatClose());
                    Point point = tGPainter.getStringExtent(string);
                    tGPainter.drawString(string, n3 - point.x + this.getSpacing(), n2 - point.y);
                }
            }
            tGPainter.initPath();
            tGPainter.moveTo(n3 - 4 + this.getSpacing(), n2);
            tGPainter.lineTo(n3 - 4 + this.getSpacing(), n4);
            tGPainter.setLineWidth(1);
            tGPainter.closePath();
            tGPainter.initPath();
            tGPainter.moveTo(n3 - 1 + this.getSpacing(), n2);
            tGPainter.lineTo(n3 - 1 + this.getSpacing(), n4);
            tGPainter.setLineWidth(3);
            tGPainter.closePath();
        } else {
            tGPainter.initPath();
            tGPainter.moveTo(n3 + this.getSpacing(), n2);
            tGPainter.lineTo(n3 + this.getSpacing(), n4);
            tGPainter.setLineWidth(1);
            tGPainter.closePath();
        }
        tGPainter.setLineWidth(1);
    }

    private void paintClef(ViewLayout viewLayout, TGPainter tGPainter) {
        if ((viewLayout.getStyle() & 4) != 0 && this.paintClef) {
            int n = Math.round(14.0f * viewLayout.getScale());
            int n2 = this.getTs().getPosition(6);
            viewLayout.setClefStyle(tGPainter);
            tGPainter.initPath(2);
            if (this.getClef() == 1) {
                TGClefPainter.paintTreble(tGPainter, n, n2, viewLayout.getScoreLineSpacing());
            } else if (this.getClef() == 2) {
                TGClefPainter.paintBass(tGPainter, n, n2, viewLayout.getScoreLineSpacing());
            } else if (this.getClef() == 3) {
                TGClefPainter.paintTenor(tGPainter, n, n2, viewLayout.getScoreLineSpacing());
            } else if (this.getClef() == 4) {
                TGClefPainter.paintAlto(tGPainter, n, n2, viewLayout.getScoreLineSpacing());
            }
            tGPainter.closePath();
        }
    }

    private void paintKeySignature(ViewLayout viewLayout, TGPainter tGPainter) {
        block14: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            float f;
            block15: {
                float f2;
                if ((viewLayout.getStyle() & 4) == 0 || !this.paintKeySignature) break block14;
                f = viewLayout.getScoreLineSpacing();
                n5 = this.getHeaderImpl().getClefSpacing() + 10;
                n4 = this.getTs().getPosition(6);
                int n6 = this.getKeySignature();
                n3 = this.prevMeasure != null ? this.prevMeasure.getKeySignature() : 0;
                n2 = 0;
                if (this.getClef() == 1) {
                    n2 = 0;
                } else if (this.getClef() == 2) {
                    n2 = 2;
                } else if (this.getClef() == 3) {
                    n2 = -1;
                } else if (this.getClef() == 4) {
                    n2 = 1;
                }
                viewLayout.setKeySignatureStyle(tGPainter);
                if (n6 >= 1 && n6 <= 7) {
                    for (n = 0; n < n6; ++n) {
                        f2 = f / 2.0f * (float)((SCORE_KEY_SHARP_POSITIONS[n] + n2 + 7) % 7) - f / 2.0f;
                        tGPainter.initPath(2);
                        TGKeySignaturePainter.paintSharp(tGPainter, n5, (float)n4 + f2, f);
                        tGPainter.closePath();
                        n5 = (int)((float)n5 + (f - f / 4.0f));
                    }
                } else if (n6 >= 8 && n6 <= 14) {
                    for (n = 7; n < n6; ++n) {
                        f2 = f / 2.0f * (float)((SCORE_KEY_FLAT_POSITIONS[n - 7] + n2 + 7) % 7) - f / 2.0f;
                        tGPainter.initPath(2);
                        TGKeySignaturePainter.paintFlat(tGPainter, n5, (float)n4 + f2, f);
                        tGPainter.closePath();
                        n5 = (int)((float)n5 + (f - f / 4.0f));
                    }
                }
                if (n3 < 1 || n3 > 7) break block15;
                for (int i = n = n6 >= 1 && n6 <= 7 ? n6 : 0; i < n3; ++i) {
                    float f3 = f / 2.0f * (float)((SCORE_KEY_SHARP_POSITIONS[i] + n2 + 7) % 7) - f / 2.0f;
                    tGPainter.initPath(2);
                    TGKeySignaturePainter.paintNatural(tGPainter, n5, (float)n4 + f3, f);
                    tGPainter.closePath();
                    n5 = (int)((float)n5 + (f - f / 4.0f));
                }
                break block14;
            }
            if (n3 < 8 || n3 > 14) break block14;
            for (int i = n = n6 >= 8 && n6 <= 14 ? n6 : 7; i < n3; ++i) {
                float f4 = f / 2.0f * (float)((SCORE_KEY_FLAT_POSITIONS[i - 7] + n2 + 7) % 7) - f / 2.0f;
                tGPainter.initPath(2);
                TGKeySignaturePainter.paintNatural(tGPainter, n5, (float)n4 + f4, f);
                tGPainter.closePath();
                n5 = (int)((float)n5 + (f - f / 4.0f));
            }
        }
    }

    private void paintTimeSignature(ViewLayout viewLayout, TGPainter tGPainter) {
        if (this.getHeaderImpl().shouldPaintTimeSignature()) {
            viewLayout.setTimeSignatureStyle(tGPainter);
            int n = viewLayout.getStyle();
            int n2 = Math.round(5.0f * viewLayout.getScale());
            int n3 = this.getHeaderImpl().getClefSpacing() + this.getHeaderImpl().getKeySignatureSpacing() + this.getHeaderImpl().getLeftSpacing(viewLayout) + n2;
            String string = Integer.toString(this.getTimeSignature().getNumerator());
            String string2 = Integer.toString(this.getTimeSignature().getDenominator().getValue());
            if ((n & 4) != 0) {
                int n4 = this.getTs().getPosition(6);
                int n5 = n4 - 3;
                int n6 = n4 + viewLayout.getScoreLineSpacing() * 4 - tGPainter.getStringExtent((String)string2).y + 3;
                tGPainter.drawString(string, n3, n5, true);
                tGPainter.drawString(string2, n3, n6, true);
            } else if ((n & 8) != 0) {
                int n7 = this.getTs().getPosition(16);
                int n8 = 8 - this.getTrack().stringCount();
                int n9 = n7 - n8;
                int n10 = n7 + this.getTrackImpl().getTabHeight() - tGPainter.getStringExtent((String)string2).y + n8;
                tGPainter.drawString(string, n3, n9, true);
                tGPainter.drawString(string2, n3, n10, true);
            }
        }
    }

    private void paintTempo(ViewLayout viewLayout, TGPainter tGPainter) {
        if (this.getHeaderImpl().shouldPaintTempo()) {
            viewLayout.setTempoStyle(tGPainter);
            String string = " = " + this.getTempo().getValue();
            Rectangle rectangle = viewLayout.getResources().getTempoImage().getBounds();
            int n = tGPainter.getStringExtent((String)string).y;
            int n2 = this.getPosX() + this.getHeaderImpl().getLeftSpacing(viewLayout);
            int n3 = this.getPosY();
            int n4 = Math.max(viewLayout.getScoreLineSpacing(), viewLayout.getStringSpacing());
            int n5 = viewLayout.getStyle();
            if ((n5 & 4) != 0) {
                n3 += this.getTs().getPosition(6) - n4;
            } else if ((n5 & 8) != 0) {
                n3 += this.getTs().getPosition(16) - n4;
            }
            tGPainter.drawImage(viewLayout.getResources().getTempoImage(), n2, n3 - rectangle.height);
            tGPainter.drawString(string, n2 + rectangle.width, Math.round((float)(n3 - n) - 1.0f * viewLayout.getScale()));
        }
    }

    private void paintTripletFeel(ViewLayout viewLayout, TGPainter tGPainter) {
        if (this.getHeaderImpl().shouldPaintTripletFeel()) {
            TGResources tGResources = viewLayout.getResources();
            if (this.getTripletFeel() == 1 && this.prevMeasure != null) {
                int n = this.prevMeasure.getTripletFeel();
                if (n == 2) {
                    this.paintTripletFeel(viewLayout, tGPainter, tGResources.getTripletFeel8(), tGResources.getTripletFeelNone8());
                } else if (n == 3) {
                    this.paintTripletFeel(viewLayout, tGPainter, tGResources.getTripletFeel16(), tGResources.getTripletFeelNone16());
                }
            } else if (this.getTripletFeel() == 2) {
                this.paintTripletFeel(viewLayout, tGPainter, tGResources.getTripletFeelNone8(), tGResources.getTripletFeel8());
            } else if (this.getTripletFeel() == 3) {
                this.paintTripletFeel(viewLayout, tGPainter, tGResources.getTripletFeelNone16(), tGResources.getTripletFeel16());
            }
        }
    }

    private void paintTripletFeel(ViewLayout viewLayout, TGPainter tGPainter, Image image, Image image2) {
        viewLayout.setTripletFeelStyle(tGPainter);
        String string = " = ";
        Point point = tGPainter.getStringExtent(string);
        Rectangle rectangle = image.getBounds();
        Rectangle rectangle2 = image2.getBounds();
        int n = this.getPosX() + this.getHeaderImpl().getLeftSpacing(viewLayout) + this.getHeaderImpl().getTempoSpacing(viewLayout);
        int n2 = this.getPosY();
        int n3 = Math.max(viewLayout.getScoreLineSpacing(), viewLayout.getStringSpacing());
        int n4 = viewLayout.getStyle();
        if ((n4 & 4) != 0) {
            n2 += this.getTs().getPosition(6) - n3;
        } else if ((n4 & 8) != 0) {
            n2 += this.getTs().getPosition(16) - n3;
        }
        tGPainter.drawImage(image, n, n2 - rectangle.height);
        tGPainter.drawString(string, n + rectangle.width, Math.round((float)(n2 - point.y) - 1.0f * viewLayout.getScale()));
        tGPainter.drawImage(image2, n + rectangle.width + point.x, n2 - rectangle2.height);
    }

    private void paintTexts(ViewLayout viewLayout, TGPainter tGPainter) {
        Iterator iterator = this.getBeats().iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat = (TGBeat)iterator.next();
            if (!tGBeat.isTextBeat()) continue;
            TGTextImpl tGTextImpl = (TGTextImpl)tGBeat.getText();
            tGTextImpl.paint(viewLayout, tGPainter, this.getPosX() + this.getHeaderImpl().getLeftSpacing(viewLayout), this.getPosY());
        }
    }

    private void paintPlayMode(ViewLayout viewLayout, TGPainter tGPainter) {
        if (viewLayout.isPlayModeEnabled() && this.isPlaying(viewLayout)) {
            int n = this.getWidth(viewLayout) + this.getSpacing();
            int n2 = this.getPosY();
            int n3 = this.getPosY();
            int n4 = viewLayout.getStyle();
            if ((n4 & 0xC) == 12) {
                n2 += this.getTs().getPosition(6) - viewLayout.getScoreLineSpacing();
                n3 += this.getTs().getPosition(16) + this.getTrackImpl().getTabHeight() + viewLayout.getStringSpacing();
            } else if ((n4 & 4) != 0) {
                n2 += this.getTs().getPosition(6) - viewLayout.getScoreLineSpacing();
                n3 += this.getTs().getPosition(6) + viewLayout.getScoreLineSpacing() * 5;
            } else if ((n4 & 8) != 0) {
                n2 += this.getTs().getPosition(16) - viewLayout.getStringSpacing();
                n3 += this.getTs().getPosition(16) + this.getTrackImpl().getTabHeight() + viewLayout.getStringSpacing();
            }
            viewLayout.setMeasurePlayingStyle(tGPainter);
            tGPainter.setLineStyle(2);
            tGPainter.setLineWidth(1);
            tGPainter.initPath();
            tGPainter.addRectangle(this.getPosX() + 5, n2, n - 10, n3 - n2);
            tGPainter.closePath();
            tGPainter.setLineStyle(1);
        }
    }

    public boolean isPlaying(ViewLayout viewLayout) {
        return this.getTrackImpl().hasCaret(viewLayout) && TuxGuitar.instance().getEditorCache().isPlaying(this);
    }

    public int getBeatSpacing(TGBeat tGBeat) {
        return (int)((tGBeat.getStart() - this.getStart()) * (long)this.getSpacing() / this.getLength());
    }

    public boolean hasTrack(int n) {
        return this.getTrack().getNumber() == n;
    }

    public int getWidth(ViewLayout viewLayout) {
        return (viewLayout.getStyle() & 2) != 0 ? this.getHeaderImpl().getMaxWidth() : this.width;
    }

    private int calculateKeySignatureSpacing(ViewLayout viewLayout) {
        int n = 0;
        if (this.paintKeySignature) {
            n = this.getKeySignature() <= 7 ? (n += Math.round(6.0f * viewLayout.getScale() * (float)this.getKeySignature())) : (n += Math.round(6.0f * viewLayout.getScale() * (float)(this.getKeySignature() - 7)));
            if (this.prevMeasure != null) {
                n = this.prevMeasure.getKeySignature() <= 7 ? (n += Math.round(6.0f * viewLayout.getScale() * (float)this.prevMeasure.getKeySignature())) : (n += Math.round(6.0f * viewLayout.getScale() * (float)(this.prevMeasure.getKeySignature() - 7)));
            }
        }
        return n;
    }

    public int getFirstNoteSpacing(ViewLayout viewLayout) {
        return this.getHeaderImpl().getFirstNoteSpacing(viewLayout);
    }

    public long getDivisionLength() {
        return this.divisionLength;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean bl) {
        this.cacheEnabled = bl;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int n) {
        this.posY = n;
    }

    private int getQuarterSpacing() {
        return this.quarterSpacing;
    }

    private int getMaxQuarterSpacing(ViewLayout viewLayout) {
        return (viewLayout.getStyle() & 2) != 0 ? this.getHeaderImpl().getMaxQuarterSpacing() : this.quarterSpacing;
    }

    public TGMeasureHeaderImpl getHeaderImpl() {
        return (TGMeasureHeaderImpl)super.getHeader();
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        if (n != this.spacing) {
            this.setCacheEnabled(false);
        }
        this.spacing = n;
    }

    public boolean isOutOfBounds() {
        return this.outOfBounds;
    }

    public void setOutOfBounds(boolean bl) {
        this.outOfBounds = bl;
    }

    public boolean isFirstOfLine() {
        return this.firstOfLine;
    }

    public void setFirstOfLine(boolean bl) {
        this.firstOfLine = bl;
    }

    public TGTrackImpl getTrackImpl() {
        return (TGTrackImpl)super.getTrack();
    }

    public TrackSpacing getTs() {
        return this.ts;
    }

    public void setTs(TrackSpacing trackSpacing) {
        if (this.getTs() == null) {
            this.setCacheEnabled(false);
        } else if (this.getTs().getPosition(6) != trackSpacing.getPosition(6)) {
            this.setCacheEnabled(false);
        } else if (this.getTs().getPosition(16) != trackSpacing.getPosition(16)) {
            this.setCacheEnabled(false);
        }
        this.ts = trackSpacing;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getNotEmptyBeats() {
        return this.notEmptyBeats;
    }

    public int getLyricBeatIndex() {
        return this.lyricBeatIndex;
    }

    public void setLyricBeatIndex(int n) {
        this.lyricBeatIndex = n;
    }

    public void dispose() {
        this.getBuffer().dispose();
        Iterator iterator = this.getBeats().iterator();
        while (iterator.hasNext()) {
            TGBeatImpl tGBeatImpl = (TGBeatImpl)iterator.next();
            tGBeatImpl.dispose();
        }
    }

    public boolean isDisposed() {
        return this.getBuffer().isDisposed();
    }

    public TGMeasureBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = new TGMeasureBuffer(TuxGuitar.instance().getDisplay());
        }
        return this.buffer;
    }
}

