/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGString;

public class TGChordImpl
extends TGChord {
    public static final int MAX_FRETS = 6;
    private int style;
    private int posX;
    private int posY;
    private int width;
    private int height;
    private int tonic;
    private int diagramWidth;
    private int diagramHeight;
    private int nameWidth;
    private int nameHeight;
    private Image diagram;
    private Color backgroundColor;
    private Color noteColor;
    private Color tonicColor;
    private Color color;
    private Font font;
    private int firstFretSpacing;
    private int stringSpacing;
    private int fretSpacing;
    private int noteSize;
    private boolean editing;

    public TGChordImpl(int n) {
        super(n);
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public void setTonic(int n) {
        this.tonic = n;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public void setPosY(int n) {
        this.posY = n;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getNoteColor() {
        return this.noteColor;
    }

    public void setNoteColor(Color color) {
        this.noteColor = color;
    }

    public Color getTonicColor() {
        return this.tonicColor;
    }

    public void setTonicColor(Color color) {
        this.tonicColor = color;
    }

    public int getFirstFretSpacing() {
        return this.firstFretSpacing;
    }

    public void setFirstFretSpacing(int n) {
        this.firstFretSpacing = n;
    }

    public int getFretSpacing() {
        return this.fretSpacing;
    }

    public void setFretSpacing(int n) {
        this.fretSpacing = n;
    }

    public int getNoteSize() {
        return this.noteSize;
    }

    public void setNoteSize(int n) {
        this.noteSize = n;
    }

    public int getStringSpacing() {
        return this.stringSpacing;
    }

    public void setStringSpacing(int n) {
        this.stringSpacing = n;
    }

    public Font getFirstFretFont() {
        return this.font;
    }

    public void setFirstFretFont(Font font) {
        this.font = font;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean bl) {
        this.editing = bl;
    }

    public void paint(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        viewLayout.setChordStyle(tGPainter, this);
        this.posY = n2 + this.getPaintPosition(4);
        this.setEditing(false);
        this.update(tGPainter.getGC().getDevice());
        this.paint(tGPainter, this.getBeatImpl().getSpacing() + n, n2);
    }

    public void paint(TGPainter tGPainter, int n, int n2) {
        int n3 = n + this.getPosX() + 4;
        int n4 = n2 + this.getPosY();
        if ((this.style & 0x20) != 0) {
            tGPainter.drawImage(this.diagram, n3 - (this.diagramWidth - this.getFirstFretSpacing()) / 2 - this.getFirstFretSpacing(), n4);
        }
        if ((this.style & 0x10) != 0 && this.getName() != null && this.getName().length() > 0) {
            tGPainter.drawString(this.getName(), n3 - this.nameWidth / 2, n4 + (this.height - this.nameHeight));
        }
    }

    public void update(Device device) {
        this.width = 0;
        this.height = 0;
        if (this.getFirstFret() <= 0) {
            this.calculateFirstFret();
        }
        if ((this.style & 0x10) != 0) {
            this.updateName(device);
            this.width = Math.max(this.width, this.nameWidth);
            this.height += this.nameHeight;
        }
        if ((this.style & 0x20) != 0) {
            this.updateDiagram(device);
            this.width = Math.max(this.width, this.diagramWidth);
            this.height += this.diagramHeight;
        }
    }

    protected void updateName(Device device) {
        String string = this.getName();
        if (string == null || string.length() == 0) {
            this.nameWidth = 0;
            this.nameHeight = 0;
            return;
        }
        TGPainter tGPainter = new TGPainter(new GC((Drawable)device));
        Point point = tGPainter.getStringExtent(string);
        this.nameWidth = point.x;
        this.nameHeight = point.y;
        tGPainter.dispose();
    }

    protected void updateDiagram(Device device) {
        if (this.diagram == null || this.diagram.isDisposed()) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            Font font = this.getFirstFretFont();
            this.diagramWidth = this.getStringSpacing() + this.getStringSpacing() * this.countStrings() + (font != null ? this.getFirstFretSpacing() : 0);
            this.diagramHeight = this.getFretSpacing() + this.getFretSpacing() * 6;
            this.diagram = new Image(device, this.diagramWidth, this.diagramHeight);
            TGPainter tGPainter = new TGPainter(new GC(this.diagram));
            tGPainter.setBackground(this.getBackgroundColor());
            tGPainter.initPath(2);
            tGPainter.addRectangle(0.0f, 0.0f, this.diagramWidth, this.diagramHeight);
            tGPainter.closePath();
            tGPainter.setForeground(this.getColor());
            int n6 = this.getStringSpacing();
            int n7 = this.getFretSpacing();
            if (font != null) {
                String string = Integer.toString(this.getFirstFret());
                tGPainter.setFont(font);
                tGPainter.drawString(string, this.getFirstFretSpacing() - tGPainter.getStringExtent((String)string).x, n7);
                n6 += this.getFirstFretSpacing();
            }
            tGPainter.initPath();
            for (n5 = 0; n5 < this.getStrings().length; ++n5) {
                n4 = n6 + n5 * this.getStringSpacing();
                n3 = n6 + n5 * this.getStringSpacing();
                n2 = n7;
                n = n7 + this.getFretSpacing() * 5;
                tGPainter.moveTo(n4, n2);
                tGPainter.lineTo(n3, n);
            }
            tGPainter.closePath();
            tGPainter.initPath();
            for (n5 = 0; n5 < 6; ++n5) {
                n4 = n6;
                n3 = n6 + this.getStringSpacing() * (this.countStrings() - 1);
                n2 = n7 + n5 * this.getFretSpacing();
                n = n7 + n5 * this.getFretSpacing();
                tGPainter.moveTo(n4, n2);
                tGPainter.lineTo(n3, n);
            }
            tGPainter.closePath();
            tGPainter.setLineWidth(1);
            for (n5 = 0; n5 < this.getStrings().length; ++n5) {
                n4 = this.getFretValue(n5);
                n3 = n6 + (this.getStringSpacing() * (this.countStrings() - 1) - this.getStringSpacing() * n5);
                if (n4 < 0) {
                    tGPainter.initPath();
                    tGPainter.moveTo(n3 - this.getNoteSize() / 2, 0.0f);
                    tGPainter.lineTo(n3 + this.getNoteSize() / 2, this.getNoteSize());
                    tGPainter.moveTo(n3 + this.getNoteSize() / 2, 0.0f);
                    tGPainter.lineTo(n3 - this.getNoteSize() / 2, this.getNoteSize());
                    tGPainter.closePath();
                    continue;
                }
                if (n4 == 0) {
                    tGPainter.initPath();
                    tGPainter.addOval(n3 - this.getNoteSize() / 2, 0.0f, this.getNoteSize(), this.getNoteSize());
                    tGPainter.closePath();
                    continue;
                }
                tGPainter.setBackground(this.tonic >= 0 && (this.getStringValue(n5 + 1) + n4) % 12 == this.tonic ? this.getTonicColor() : this.getNoteColor());
                tGPainter.initPath(2);
                n2 = n7 + (this.getFretSpacing() * (n4 -= this.getFirstFret() - 1) - this.getFretSpacing() / 2);
                tGPainter.addOval(n3 - this.getNoteSize() / 2, n2 - this.getNoteSize() / 2, this.getNoteSize() + 1, this.getNoteSize() + 1);
                tGPainter.closePath();
            }
            tGPainter.dispose();
        }
    }

    public void calculateFirstFret() {
        int n;
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        for (n = 0; n < this.getStrings().length; ++n) {
            int n4 = this.getFretValue(n);
            boolean bl2 = bl = bl || n4 == 0;
            if (n4 <= 0) continue;
            n2 = n2 < 0 ? n4 : Math.min(n2, n4);
            n3 = Math.max(n3, n4);
        }
        n = bl && n3 < 6 ? 1 : n2;
        this.setFirstFret(Math.max(n, 1));
    }

    protected int getStringValue(int n) {
        TGString tGString = this.getBeat().getMeasure().getTrack().getString(n);
        return tGString.getValue();
    }

    public boolean isDisposed() {
        return this.diagram == null || this.diagram.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.diagram.dispose();
        }
    }

    public int getPosX() {
        return this.isEditing() ? this.posX : this.getBeatImpl().getPosX();
    }

    public int getPaintPosition(int n) {
        return this.getBeatImpl().getMeasureImpl().getTs().getPosition(n);
    }

    public TGBeatImpl getBeatImpl() {
        return (TGBeatImpl)this.getBeat();
    }
}

