/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.Iterator;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGBeatGroup;
import org.herac.tuxguitar.gui.editors.tab.TGChordImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGNoteImpl;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.editors.tab.painters.TGNotePainter;
import org.herac.tuxguitar.gui.editors.tab.painters.TGSilencePainter;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGTupleto;

public class TGBeatImpl
extends TGBeat {
    public static final int JOINED_TYPE_NONE_LEFT = 1;
    public static final int JOINED_TYPE_NONE_RIGHT = 2;
    public static final int JOINED_TYPE_LEFT = 3;
    public static final int JOINED_TYPE_RIGHT = 4;
    private int posX;
    private int width;
    private TGNoteImpl maxNote;
    private TGNoteImpl minNote;
    private boolean[] usedStrings;
    private int joinedType;
    private boolean joinedGreaterThanQuarter;
    private TGBeatImpl join1;
    private TGBeatImpl join2;
    private TGBeatImpl previous;
    private TGBeatImpl next;
    private TGBeatGroup group;

    public TGBeatImpl(TGFactory tGFactory) {
        super(tGFactory);
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public TGNoteImpl getMinNote() {
        return this.minNote;
    }

    public TGNoteImpl getMaxNote() {
        return this.maxNote;
    }

    public TGMeasureImpl getMeasureImpl() {
        return (TGMeasureImpl)this.getMeasure();
    }

    public boolean[] getUsedStrings() {
        if (this.usedStrings == null) {
            this.usedStrings = new boolean[this.getMeasure().getTrack().stringCount()];
        }
        return this.usedStrings;
    }

    public TGBeatImpl getJoin1() {
        return this.join1;
    }

    public void setJoin1(TGBeatImpl tGBeatImpl) {
        this.join1 = tGBeatImpl;
    }

    public TGBeatImpl getJoin2() {
        return this.join2;
    }

    public void setJoin2(TGBeatImpl tGBeatImpl) {
        this.join2 = tGBeatImpl;
    }

    public boolean isJoinedGreaterThanQuarter() {
        return this.joinedGreaterThanQuarter;
    }

    public void setJoinedGreaterThanQuarter(boolean bl) {
        this.joinedGreaterThanQuarter = bl;
    }

    public int getJoinedType() {
        return this.joinedType;
    }

    public void setJoinedType(int n) {
        this.joinedType = n;
    }

    public void setPreviousBeat(TGBeatImpl tGBeatImpl) {
        this.previous = tGBeatImpl;
    }

    public void setNextBeat(TGBeatImpl tGBeatImpl) {
        this.next = tGBeatImpl;
    }

    public TGBeatGroup getBeatGroup() {
        return this.group;
    }

    public void setBeatGroup(TGBeatGroup tGBeatGroup) {
        this.group = tGBeatGroup;
    }

    public int getSpacing() {
        return this.getMeasureImpl().getBeatSpacing(this);
    }

    public boolean isPlaying(ViewLayout viewLayout) {
        return this.getMeasureImpl().isPlaying(viewLayout) && TuxGuitar.instance().getEditorCache().isPlaying(this.getMeasure(), this);
    }

    public void reset() {
        this.maxNote = null;
        this.minNote = null;
        this.usedStrings = new boolean[this.getMeasure().getTrack().stringCount()];
    }

    public void check(TGNoteImpl tGNoteImpl) {
        int n = tGNoteImpl.getRealValue();
        if (this.maxNote == null || n > this.maxNote.getRealValue()) {
            this.maxNote = tGNoteImpl;
        }
        if (this.minNote == null || n < this.minNote.getRealValue()) {
            this.minNote = tGNoteImpl;
        }
        this.getUsedStrings();
        this.usedStrings[tGNoteImpl.getString() - 1] = true;
    }

    public void play() {
        if (!TuxGuitar.instance().getPlayer().isRunning()) {
            new Thread(new Runnable(){

                public void run() {
                    TuxGuitar.instance().getPlayer().playBeat(TGBeatImpl.this.getMeasure().getTrack(), TGBeatImpl.this.getNotes());
                }
            }).start();
        }
    }

    public void update(ViewLayout viewLayout) {
        if (!this.isRestBeat()) {
            this.joinedType = 2;
            this.joinedGreaterThanQuarter = false;
            this.setJoin1(this);
            this.setJoin2(this);
            boolean bl = false;
            boolean bl2 = false;
            if (this.previous != null && !this.previous.isRestBeat() && this.getMeasureImpl().canJoin(viewLayout.getSongManager(), this, this.previous)) {
                bl2 = true;
                if (this.previous.getDuration().getValue() >= this.getDuration().getValue()) {
                    this.setJoin1(this.previous);
                    this.setJoin2(this);
                    this.joinedType = 3;
                    bl = true;
                }
                if (this.previous.getDuration().getValue() > 4) {
                    this.joinedGreaterThanQuarter = true;
                }
            }
            if (this.next != null && !this.next.isRestBeat() && this.getMeasureImpl().canJoin(viewLayout.getSongManager(), this, this.next)) {
                if (this.next.getDuration().getValue() >= this.getDuration().getValue()) {
                    this.setJoin2(this.next);
                    if (this.previous == null || this.previous.isRestBeat() || this.previous.getDuration().getValue() < this.getDuration().getValue()) {
                        this.setJoin1(this);
                    }
                    bl = true;
                    this.joinedType = 4;
                }
                if (this.next.getDuration().getValue() > 4) {
                    this.joinedGreaterThanQuarter = true;
                }
            }
            if (!bl && bl2) {
                this.joinedType = 1;
            }
        }
    }

    public void paint(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        if (!viewLayout.isPlayModeEnabled() && (viewLayout.getStyle() & 4) != 0) {
            this.paintExtraLines(tGPainter, viewLayout, n, n2);
        }
        if (this.isRestBeat()) {
            this.paintSilence(viewLayout, tGPainter, n, n2);
        } else {
            Object object;
            Iterator iterator = this.getNotes().iterator();
            while (iterator.hasNext()) {
                object = (TGNoteImpl)iterator.next();
                ((TGNoteImpl)object).paint(viewLayout, tGPainter, n, n2);
            }
            if (!viewLayout.isPlayModeEnabled()) {
                this.paintBeat(viewLayout, tGPainter, n, n2);
                if (this.isChordBeat()) {
                    object = (TGChordImpl)this.getChord();
                    ((TGChordImpl)object).paint(viewLayout, tGPainter, n, n2);
                }
            }
        }
    }

    public void paintSilence(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        int n3 = viewLayout.getStyle();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        if ((n3 & 4) != 0) {
            n4 = n + this.getPosX() + this.getSpacing();
            n5 = n2 + this.getPaintPosition(6);
            n6 = viewLayout.getScoreLineSpacing();
            n7 = 5;
            f2 = (float)n6 / 9.0f;
        } else {
            n4 = n + this.getPosX() + this.getSpacing() - 1;
            n5 = n2 + this.getPaintPosition(16);
            n6 = viewLayout.getStringSpacing();
            n7 = this.getMeasure().getTrack().stringCount();
            f2 = (float)n6 / 10.0f;
        }
        this.setStyle(viewLayout, tGPainter, viewLayout.isPlayModeEnabled() && this.isPlaying(viewLayout));
        tGPainter.initPath(2);
        int n8 = this.getDuration().getValue();
        if (n8 == 1) {
            f = n5 + (n7 <= 5 ? n6 : n6 * 2);
            TGSilencePainter.paintWhole(tGPainter, n4, f, f2);
        }
        if (n8 == 2) {
            f = (float)(n5 + (n7 <= 5 ? n6 * 2 : n6 * 3)) - f2 * 3.0f;
            TGSilencePainter.paintHalf(tGPainter, n4, f, f2);
        }
        if (n8 == 4) {
            f = (float)(n5 + n6 * (n7 - 1) / 2) - f2 * 8.0f;
            TGSilencePainter.paintQuarter(tGPainter, n4, f, f2);
        } else if (n8 == 8) {
            f = (float)(n5 + n6 * (n7 - 1) / 2) - f2 * 6.0f;
            TGSilencePainter.paintEighth(tGPainter, n4, f, f2);
        } else if (n8 == 16) {
            f = (float)(n5 + n6 * (n7 - 1) / 2) - f2 * 8.0f;
            TGSilencePainter.paintSixteenth(tGPainter, n4, f, f2);
        } else if (n8 == 32) {
            f = (float)(n5 + n6 * (n7 - 1) / 2) - f2 * 12.0f;
            TGSilencePainter.paintThirtySecond(tGPainter, n4, f, f2);
        } else if (n8 == 64) {
            f = (float)(n5 + n6 * (n7 - 1) / 2) - f2 * 14.0f;
            TGSilencePainter.paintSixtyFourth(tGPainter, n4, f, f2);
        }
        tGPainter.closePath();
        if (this.getDuration().isDotted() || this.getDuration().isDoubleDotted()) {
            viewLayout.setDotStyle(tGPainter);
            tGPainter.initPath();
            tGPainter.moveTo(n4 + 10, f + 1.0f);
            tGPainter.addOval(n4 + 10, f + 1.0f, 1.0f, 1.0f);
            if (this.getDuration().isDoubleDotted()) {
                tGPainter.moveTo(n4 + 13, f + 1.0f);
                tGPainter.addOval(n4 + 13, f + 1.0f, 1.0f, 1.0f);
            }
            tGPainter.closePath();
        }
        if (!this.getDuration().getTupleto().isEqual(TGTupleto.NORMAL)) {
            viewLayout.setTupletoStyle(tGPainter);
            if ((n3 & 4) != 0) {
                tGPainter.drawString(Integer.toString(this.getDuration().getTupleto().getEnters()), n4, n2 + this.getPaintPosition(8));
            } else {
                tGPainter.drawString(Integer.toString(this.getDuration().getTupleto().getEnters()), n4, n2 + this.getPaintPosition(8));
            }
        }
    }

    public void setStyle(ViewLayout viewLayout, TGPainter tGPainter, boolean bl) {
        if ((viewLayout.getStyle() & 4) != 0) {
            viewLayout.setScoreSilenceStyle(tGPainter, bl);
        } else {
            viewLayout.setTabSilenceStyle(tGPainter, bl);
        }
    }

    public void paintExtraLines(TGPainter tGPainter, ViewLayout viewLayout, int n, int n2) {
        if (!this.isRestBeat()) {
            int n3 = n2 + this.getMeasureImpl().getTs().getPosition(6);
            this.paintExtraLines(tGPainter, viewLayout, this.getMinNote(), n, n3);
            this.paintExtraLines(tGPainter, viewLayout, this.getMaxNote(), n, n3);
        }
    }

    private void paintExtraLines(TGPainter tGPainter, ViewLayout viewLayout, TGNoteImpl tGNoteImpl, int n, int n2) {
        block3: {
            int n3;
            float f;
            float f2;
            int n4;
            block2: {
                float f3 = viewLayout.getScale();
                n4 = n2 + tGNoteImpl.getScorePosY();
                int n5 = n + this.getPosX() + this.getSpacing();
                f2 = (float)n5 - 4.0f * f3;
                f = (float)n5 + 12.0f * f3;
                n3 = viewLayout.getScoreLineSpacing();
                viewLayout.setLineStyle(tGPainter);
                if (n4 >= n2) break block2;
                for (int i = n2; i > n4; i -= n3) {
                    tGPainter.initPath();
                    tGPainter.moveTo(f2, i);
                    tGPainter.lineTo(f, i);
                    tGPainter.closePath();
                }
                break block3;
            }
            if (n4 <= n2 + n3 * 4) break block3;
            for (int i = n2 + n3 * 5; i < n4 + n3; i += n3) {
                tGPainter.initPath();
                tGPainter.moveTo(f2, i);
                tGPainter.lineTo(f, i);
                tGPainter.closePath();
            }
        }
    }

    public void paintBeat(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        if (!this.isRestBeat()) {
            int n3 = viewLayout.getStyle();
            int n4 = this.getSpacing();
            if ((n3 & 4) != 0) {
                this.paintScoreBeat(viewLayout, tGPainter, n, n2 + this.getPaintPosition(6), n4);
            }
            if ((n3 & 8) != 0 && (n3 & 4) == 0) {
                this.paintTablatureBeat(viewLayout, tGPainter, n, n2 + this.getPaintPosition(16), n4);
            }
        }
    }

    public void paintTablatureBeat(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3) {
        if (!this.isRestBeat()) {
            int n4;
            int n5 = 2;
            int n6 = viewLayout.getStringSpacing();
            int n7 = n + this.getPosX() + n3 + n5;
            int n8 = n2 + this.getMeasureImpl().getTrackImpl().getTabHeight() + n6 / 2;
            int n9 = n2 + this.getMeasureImpl().getTrackImpl().getTabHeight() + n6 / 2 * 5;
            if (this.getDuration().getValue() >= 4) {
                int n10;
                int n11;
                int n12;
                int n13;
                viewLayout.setTabNoteFooterStyle(tGPainter);
                tGPainter.initPath();
                n4 = 0;
                boolean[] blArray = this.getUsedStrings();
                for (n13 = 0; n13 < blArray.length; ++n13) {
                    if (!blArray[n13] && n4 != 0) {
                        n12 = n2 + n6 * (n13 + 1) - n6;
                        n11 = n12 + n6 / 2;
                        n10 = n12 - n6 / 2;
                        n11 = n11 - n10 < n6 ? n11 + 1 : n11;
                        tGPainter.moveTo(n7, n10);
                        tGPainter.lineTo(n7, n11);
                    }
                    n4 = n4 != 0 || blArray[n13] ? 1 : 0;
                }
                tGPainter.moveTo(n7, n8);
                tGPainter.lineTo(n7, n9);
                tGPainter.closePath();
                if (this.getDuration().getValue() >= 8) {
                    n13 = 0;
                    n12 = 0;
                    n10 = viewLayout.getStringSpacing() / 2;
                    n11 = this.getJoinedType();
                    if (n11 == 2) {
                        n13 = this.getPosX() + n5 + n3;
                        n12 = this.getPosX() + n5 + n3 + 6;
                    } else if (n11 == 1) {
                        n13 = this.getPosX() + n5 + n3 - 5;
                        n12 = this.getPosX() + n5 + n3;
                    } else {
                        n13 = this.getJoin1().getPosX() + n5 + this.getJoin1().getSpacing();
                        n12 = this.getJoin2().getPosX() + n5 + this.getJoin2().getSpacing();
                    }
                    int n14 = this.getDuration().getIndex() - 2;
                    if (n14 > 0) {
                        tGPainter.setLineWidth(2);
                        tGPainter.initPath();
                        for (int i = n14; i > 0; --i) {
                            tGPainter.moveTo(n + n13, n9 + (n10 - i * n10));
                            tGPainter.lineTo(n + n12, n9 + (n10 - i * n10));
                        }
                        tGPainter.closePath();
                        tGPainter.setLineWidth(1);
                    }
                }
            } else if (this.getDuration().getValue() == 2) {
                viewLayout.setTabNoteFooterStyle(tGPainter);
                tGPainter.initPath();
                tGPainter.moveTo(n7, n8 + (n9 - n8) / 2);
                tGPainter.lineTo(n7, n9);
                tGPainter.closePath();
            }
            if (this.getDuration().isDotted() || this.getDuration().isDoubleDotted()) {
                n4 = this.getJoinedType();
                float f = (float)n6 / 10.0f;
                float f2 = this.getDuration().getValue() > 1 ? (n4 == 2 || n4 == 4 ? (float)n7 + 4.0f * f : (float)n7 - 5.0f * f) : (float)n7;
                float f3 = (float)n9 - (this.getDuration().getValue() >= 8 ? (float)(n6 / 2 * (this.getDuration().getIndex() - 2)) : 1.0f * f);
                this.paintDot(viewLayout, tGPainter, f2, f3, f);
            }
            if (!this.getDuration().getTupleto().isEqual(TGTupleto.NORMAL)) {
                viewLayout.setTupletoStyle(tGPainter);
                tGPainter.drawString(Integer.toString(this.getDuration().getTupleto().getEnters()), n7 - 3, n2 - this.getPaintPosition(16) + this.getPaintPosition(8));
            }
        }
    }

    public void paintScoreBeat(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3) {
        int n4 = n + this.getPosX() + n3;
        if (!this.getDuration().getTupleto().isEqual(TGTupleto.NORMAL)) {
            viewLayout.setTupletoStyle(tGPainter);
            tGPainter.drawString(Integer.toString(this.getDuration().getTupleto().getEnters()), n4, n2 - this.getPaintPosition(6) + this.getPaintPosition(8));
        }
        if (this.getDuration().getValue() >= 2) {
            int n5;
            viewLayout.setScoreNoteFooterStyle(tGPainter);
            float f = viewLayout.getScoreLineSpacing();
            int n6 = this.group.getDirection();
            int n7 = this.getMeasure().getKeySignature();
            int n8 = this.getMeasure().getClef();
            int n9 = n6 == 1 ? viewLayout.getResources().getScoreNoteWidth() : 0;
            int n10 = n6 == 1 ? viewLayout.getScoreLineSpacing() / 3 + 1 : viewLayout.getScoreLineSpacing() / 3 * 2;
            int n11 = n2 + (n6 == 2 ? this.maxNote.getScorePosY() : this.minNote.getScorePosY());
            int n12 = n2 + this.group.getY2(viewLayout, this.getPosX() + n3, n7, n8);
            tGPainter.initPath();
            tGPainter.moveTo(n4 + n9, n11 + n10);
            tGPainter.lineTo(n4 + n9, n12);
            tGPainter.closePath();
            if (this.getDuration().getValue() >= 8 && (n5 = this.getDuration().getIndex() - 3) >= 0) {
                int n13 = n6 == 2 ? 1 : -1;
                int n14 = this.getJoinedType();
                boolean bl = this.isJoinedGreaterThanQuarter();
                if (!(n14 != 1 && n14 != 2 || bl)) {
                    float f2 = n + n9 + this.getPosX() + n3;
                    float f3 = (float)(n2 + this.group.getY2(viewLayout, this.getPosX() + n3, n7, n8)) - f * 2.0f * (float)n13;
                    for (int i = 0; i <= n5; ++i) {
                        tGPainter.initPath(2);
                        TGNotePainter.paintFooter(tGPainter, f2, f3 - (float)i * (f / 2.0f) * (float)n13, n13, f);
                        tGPainter.closePath();
                    }
                } else {
                    int n15 = 0;
                    int n16 = 0;
                    if (n14 == 2) {
                        n15 = this.getPosX() + n3;
                        n16 = this.getPosX() + n3 + 6;
                    } else if (n14 == 1) {
                        n15 = this.getPosX() + n3 - 5;
                        n16 = this.getPosX() + n3;
                    } else {
                        n15 = this.getJoin1().getPosX() + this.getJoin1().getSpacing();
                        n16 = this.getJoin2().getPosX() + this.getJoin2().getSpacing();
                    }
                    int n17 = n2 + this.group.getY2(viewLayout, n15, n7, n8);
                    int n18 = n2 + this.group.getY2(viewLayout, n16, n7, n8);
                    tGPainter.setLineWidth(3);
                    tGPainter.initPath();
                    for (int i = 0; i <= n5; ++i) {
                        tGPainter.moveTo(n + n9 + n15, n17 - i * 5 * n13);
                        tGPainter.lineTo(n + n9 + n16, n18 - i * 5 * n13);
                    }
                    tGPainter.closePath();
                    tGPainter.setLineWidth(1);
                }
            }
        }
    }

    public void paintDot(ViewLayout viewLayout, TGPainter tGPainter, float f, float f2, float f3) {
        float f4 = 3.0f * f3;
        float f5 = f;
        float f6 = f2;
        viewLayout.setDotStyle(tGPainter);
        tGPainter.initPath(2);
        tGPainter.moveTo(f5 - f4 / 2.0f, f6 - f4 / 2.0f);
        tGPainter.addOval(f5 - f4 / 2.0f, f6 - f4 / 2.0f, f4, f4);
        if (this.getDuration().isDoubleDotted()) {
            tGPainter.moveTo(f5 + (f4 + 2.0f) - f4 / 2.0f, f6 - f4 / 2.0f);
            tGPainter.addOval(f5 + (f4 + 2.0f) - f4 / 2.0f, f6 - f4 / 2.0f, f4, f4);
        }
        tGPainter.closePath();
    }

    public int getPaintPosition(int n) {
        return this.getMeasureImpl().getTs().getPosition(n);
    }

    public void removeChord() {
        if (this.isChordBeat()) {
            TGChordImpl tGChordImpl = (TGChordImpl)this.getChord();
            tGChordImpl.dispose();
        }
        super.removeChord();
    }

    public void dispose() {
        if (this.isChordBeat()) {
            TGChordImpl tGChordImpl = (TGChordImpl)this.getChord();
            tGChordImpl.dispose();
        }
    }
}

