/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.matrix;

import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.matrix.MatrixConfig;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGNoteImpl;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.system.lock.TGSongLock;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.TGMusicKeyUtils;
import org.herac.tuxguitar.player.base.MidiPercussion;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGLock;

public class MatrixEditor
implements IconLoader,
LanguageLoader {
    private static final int BORDER_HEIGHT = 20;
    private static final int SCROLL_INCREMENT = 50;
    private static final String[] NOTE_NAMES = TGMusicKeyUtils.getSharpKeyNames("matrix");
    private static final MidiPercussion[] PERCUSSIONS = TuxGuitar.instance().getPlayer().getPercussions();
    protected static final int[] DIVISIONS = new int[]{1, 2, 3, 4, 6, 8, 16};
    private TGLock paintLock = new TGLock();
    private Shell dialog;
    private Composite composite;
    private Composite toolbar;
    private Composite editor;
    private Rectangle clientArea;
    private MatrixConfig config;
    private Image buffer;
    private BufferDisposer bufferDisposer;
    private Label durationLabel;
    private Label gridsLabel;
    private Button settings;
    private float width;
    private float height;
    private float bufferWidth;
    private float bufferHeight;
    private float timeWidth;
    private float lineHeight;
    private int leftSpacing;
    private int minNote;
    private int maxNote;
    private int selection;
    private int grids = this.loadGrids();
    private int playedTrack;
    private int playedMeasure;
    private TGBeat playedBeat;
    private Image selectionBackBuffer;
    private int selectionX;
    private int selectionY;
    private int duration;

    public MatrixEditor() {
        TuxGuitar.instance().getIconManager().addLoader(this);
        TuxGuitar.instance().getLanguageManager().addLoader(this);
    }

    public void show() {
        this.config = new MatrixConfig();
        this.config.load();
        this.dialog = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 2160);
        this.dialog.setText(TuxGuitar.getProperty("matrix.editor"));
        this.dialog.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        this.dialog.setLayout(new GridLayout());
        this.dialog.addDisposeListener(new DisposeListenerImpl());
        this.bufferDisposer = new BufferDisposer();
        this.composite = new Composite(this.dialog, 0);
        this.composite.setLayout(new GridLayout());
        this.composite.setLayoutData(new GridData(4, 4, true, true));
        this.initToolBar();
        this.initEditor();
        this.loadIcons();
        TuxGuitar.instance().getkeyBindingManager().appendListenersTo(this.toolbar);
        TuxGuitar.instance().getkeyBindingManager().appendListenersTo(this.editor);
        TuxGuitar.instance().updateCache(true);
        DialogUtils.openDialog(this.dialog, 9);
        TuxGuitar.instance().updateCache(true);
    }

    private void initToolBar() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.toolbar = new Composite(this.composite, 0);
        ++gridLayout.numColumns;
        Button button = new Button(this.toolbar, 16388);
        button.addSelectionListener(TuxGuitar.instance().getAction("action.caret.go-left"));
        ++gridLayout.numColumns;
        Button button2 = new Button(this.toolbar, 131076);
        button2.addSelectionListener(TuxGuitar.instance().getAction("action.caret.go-right"));
        ++gridLayout.numColumns;
        this.makeToolSeparator(this.toolbar);
        ++gridLayout.numColumns;
        Button button3 = new Button(this.toolbar, 132);
        button3.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.decrement-duration"));
        ++gridLayout.numColumns;
        this.durationLabel = new Label(this.toolbar, 2048);
        ++gridLayout.numColumns;
        Button button4 = new Button(this.toolbar, 1028);
        button4.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.increment-duration"));
        ++gridLayout.numColumns;
        this.makeToolSeparator(this.toolbar);
        ++gridLayout.numColumns;
        this.gridsLabel = new Label(this.toolbar, 0);
        this.gridsLabel.setText(TuxGuitar.getProperty("matrix.grids"));
        ++gridLayout.numColumns;
        final Combo combo = new Combo(this.toolbar, 12);
        combo.setLayoutData(new GridData(4, 0x1000000, false, true));
        for (int i = 0; i < DIVISIONS.length; ++i) {
            combo.add(Integer.toString(DIVISIONS[i]));
            if (this.grids != DIVISIONS[i]) continue;
            combo.select(i);
        }
        if (this.grids == 0) {
            combo.select(0);
        }
        combo.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = combo.getSelectionIndex();
                if (n >= 0 && n < DIVISIONS.length) {
                    MatrixEditor.this.setGrids(DIVISIONS[n]);
                }
            }
        });
        ++gridLayout.numColumns;
        this.settings = new Button(this.toolbar, 8);
        this.settings.setImage(TuxGuitar.instance().getIconManager().getSettings());
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.settings.setLayoutData(new GridData(131072, 4, true, true));
        this.settings.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MatrixEditor.this.configure();
            }
        });
        this.toolbar.setLayout(gridLayout);
        this.toolbar.setLayoutData(new GridData(4, 128, true, false));
    }

    private void makeToolSeparator(Composite composite) {
        Label label = new Label(composite, 2);
        label.setLayoutData(new GridData(20, 20));
    }

    private void loadDurationImage(boolean bl) {
        int n = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getDuration().getValue();
        if (bl || this.duration != n) {
            this.duration = n;
            this.durationLabel.setImage(TuxGuitar.instance().getIconManager().getDuration(this.duration));
        }
    }

    public void initEditor() {
        this.selection = -1;
        this.editor = new Composite(this.composite, 0x20000B00);
        this.editor.setLayoutData(new GridData(4, 4, true, true));
        this.editor.setLayout(new FillLayout());
        this.editor.setFocus();
        this.editor.getHorizontalBar().setIncrement(50);
        this.editor.getHorizontalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MatrixEditor.this.redraw();
            }
        });
        this.editor.getVerticalBar().setIncrement(50);
        this.editor.getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MatrixEditor.this.redraw();
            }
        });
        this.editor.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                MatrixEditor.this.paintEditor(tGPainter);
                tGPainter.dispose();
            }
        });
        this.editor.addMouseListener(new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (!TuxGuitar.instance().getPlayer().isRunning()) {
                    MatrixEditor.this.getEditor().setFocus();
                    MatrixEditor.this.hit(mouseEvent.x, mouseEvent.y);
                }
            }
        });
        this.editor.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                MatrixEditor.this.updateSelection(mouseEvent.y);
            }
        });
        this.editor.addMouseTrackListener(new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent mouseEvent) {
                MatrixEditor.this.redraw();
            }

            public void mouseExit(MouseEvent mouseEvent) {
                MatrixEditor.this.updateSelection(-1.0f);
            }
        });
    }

    protected void updateScroll() {
        int n = this.editor.getBorderWidth();
        ScrollBar scrollBar = this.editor.getVerticalBar();
        ScrollBar scrollBar2 = this.editor.getHorizontalBar();
        scrollBar.setMaximum(Math.round(this.height + (float)(n * 2)));
        scrollBar.setThumb(Math.round(Math.min(this.height + (float)(n * 2), (float)this.clientArea.height)));
        scrollBar2.setMaximum(Math.round(this.width + (float)(n * 2)));
        scrollBar2.setThumb(Math.round(Math.min(this.width + (float)(n * 2), (float)this.clientArea.width)));
    }

    protected int getValueAt(float f) {
        if (f - 20.0f < 0.0f || f + 20.0f > (float)this.clientArea.height) {
            return -1;
        }
        int n = this.editor.getVerticalBar().getSelection();
        int n2 = this.maxNote - (int)((f + (float)n - 20.0f) / this.lineHeight);
        return n2;
    }

    protected long getStartAt(float f) {
        TGMeasure tGMeasure = this.getMeasure();
        float f2 = f + (float)this.editor.getHorizontalBar().getSelection();
        long l = (long)((float)tGMeasure.getStart() + (f2 - (float)this.leftSpacing) * (float)tGMeasure.getLength() / (this.timeWidth * (float)tGMeasure.getTimeSignature().getNumerator()));
        return l;
    }

    protected void paintEditor(TGPainter tGPainter) {
        if (!TGSongLock.isLocked() && !this.paintLock.isLocked()) {
            this.paintLock.lock();
            if (!TuxGuitar.instance().getPlayer().isRunning()) {
                this.resetPlayed();
            }
            this.disposeSelectionBuffer();
            this.clientArea = this.editor.getClientArea();
            Image image = this.getBuffer();
            this.width = this.bufferWidth;
            this.height = this.bufferHeight + 40.0f;
            this.updateScroll();
            int n = this.editor.getHorizontalBar().getSelection();
            int n2 = this.editor.getVerticalBar().getSelection();
            tGPainter.drawImage(image, -n, 20 - n2);
            this.paintMeasure(tGPainter, -n, 20 - n2);
            this.paintBorders(tGPainter, -n, 0.0f);
            this.paintPosition(tGPainter, -n, 0.0f);
            this.paintSelection(tGPainter, -n, 20 - n2);
            this.paintLock.unlock();
        }
    }

    protected Image getBuffer() {
        this.bufferDisposer.update(this.clientArea.width, this.clientArea.height);
        if (this.buffer == null || this.buffer.isDisposed()) {
            int n;
            int n2;
            int n3;
            String[] stringArray = null;
            TGMeasure tGMeasure = this.getMeasure();
            boolean bl = tGMeasure.getTrack().isPercussionTrack();
            this.maxNote = 0;
            this.minNote = 127;
            if (bl) {
                stringArray = new String[PERCUSSIONS.length];
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    this.minNote = Math.min(this.minNote, PERCUSSIONS[n3].getValue());
                    this.maxNote = Math.max(this.maxNote, PERCUSSIONS[n3].getValue());
                    stringArray[n3] = PERCUSSIONS[stringArray.length - n3 - 1].getName();
                }
            } else {
                for (n3 = 1; n3 <= tGMeasure.getTrack().stringCount(); ++n3) {
                    TGString tGString = tGMeasure.getTrack().getString(n3);
                    this.minNote = Math.min(this.minNote, tGString.getValue());
                    this.maxNote = Math.max(this.maxNote, tGString.getValue() + 20);
                }
                stringArray = new String[this.maxNote - this.minNote + 1];
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    stringArray[n3] = NOTE_NAMES[(this.maxNote - n3) % 12] + (this.maxNote - n3) / 12;
                }
            }
            n3 = 110;
            int n4 = 0;
            TGPainter tGPainter = new TGPainter(new GC((Drawable)this.dialog.getDisplay()));
            tGPainter.setFont(this.config.getFont());
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                Point point = tGPainter.getStringExtent(stringArray[n2]);
                if (point.x > n3) {
                    n3 = point.x;
                }
                if (point.y <= n4) continue;
                n4 = point.y;
            }
            tGPainter.dispose();
            n2 = tGMeasure.getTimeSignature().getNumerator();
            int n5 = this.maxNote - this.minNote;
            this.leftSpacing = n3 + 10;
            this.lineHeight = Math.max((float)n4, ((float)this.clientArea.height - 40.0f) / ((float)n5 + 1.0f));
            this.timeWidth = Math.max(10 * (64 / tGMeasure.getTimeSignature().getDenominator().getValue()), (this.clientArea.width - this.leftSpacing) / n2);
            this.bufferWidth = (float)this.leftSpacing + this.timeWidth * (float)n2;
            this.bufferHeight = this.lineHeight * (float)(n5 + 1);
            this.buffer = new Image((Device)this.editor.getDisplay(), Math.round(this.bufferWidth), Math.round(this.bufferHeight));
            tGPainter = new TGPainter(new GC(this.buffer));
            tGPainter.setFont(this.config.getFont());
            tGPainter.setForeground(this.config.getColorForeground());
            for (n = 0; n <= n5; ++n) {
                tGPainter.setBackground(this.config.getColorLine(n % 2));
                tGPainter.initPath(2);
                tGPainter.addRectangle(0.0f, (float)n * this.lineHeight, this.bufferWidth, this.lineHeight);
                tGPainter.closePath();
                tGPainter.drawString(stringArray[n], 5, Math.round((float)n * this.lineHeight) + Math.round((this.lineHeight - (float)n4) / 2.0f));
            }
            for (n = 0; n < n2; ++n) {
                float f = (float)this.leftSpacing + (float)n * this.timeWidth;
                float f2 = this.timeWidth / (float)this.grids;
                for (int i = 0; i < this.grids; ++i) {
                    tGPainter.setLineStyle(i == 0 ? 1 : 3);
                    tGPainter.initPath();
                    tGPainter.moveTo(Math.round(f + (float)i * f2), 0.0f);
                    tGPainter.lineTo(Math.round(f + (float)i * f2), this.bufferHeight);
                    tGPainter.closePath();
                }
            }
            tGPainter.dispose();
        }
        return this.buffer;
    }

    protected void paintMeasure(TGPainter tGPainter, float f, float f2) {
        TGMeasure tGMeasure = this.getMeasure();
        if (tGMeasure != null) {
            Iterator iterator = tGMeasure.getBeats().iterator();
            while (iterator.hasNext()) {
                TGBeat tGBeat = (TGBeat)iterator.next();
                this.paintBeat(tGPainter, tGMeasure, tGBeat, f, f2);
            }
        }
    }

    protected void paintBeat(TGPainter tGPainter, TGMeasure tGMeasure, TGBeat tGBeat, float f, float f2) {
        int n = 20;
        int n2 = this.clientArea.height - 20;
        for (int i = 0; i < tGBeat.countNotes(); ++i) {
            TGNoteImpl tGNoteImpl = (TGNoteImpl)tGBeat.getNote(i);
            float f3 = f + (float)this.leftSpacing + (float)(tGNoteImpl.getBeat().getStart() - tGMeasure.getStart()) * (this.timeWidth * (float)tGMeasure.getTimeSignature().getNumerator()) / (float)tGMeasure.getLength() + 1.0f;
            float f4 = f2 + (float)(this.maxNote - this.minNote - (tGNoteImpl.getRealValue() - this.minNote)) * this.lineHeight + 1.0f;
            float f5 = f3 + (float)tGNoteImpl.getBeat().getDuration().getTime() * this.timeWidth / (float)tGMeasure.getTimeSignature().getDenominator().getTime() - 2.0f;
            float f6 = f4 + this.lineHeight - 2.0f;
            if (f4 >= (float)n2 || f6 <= (float)n) continue;
            f4 = f4 < (float)n ? (float)n : f4;
            float f7 = f6 = f6 > (float)n2 ? (float)n2 : f6;
            if (!(f5 - f3 > 0.0f) || !(f6 - f4 > 0.0f)) continue;
            tGPainter.setBackground(tGNoteImpl.getBeatImpl().isPlaying(TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout()) ? this.config.getColorPlay() : this.config.getColorNote());
            tGPainter.initPath(2);
            tGPainter.addRectangle(f3, f4, f5 - f3, f6 - f4);
            tGPainter.closePath();
        }
    }

    protected void paintBorders(TGPainter tGPainter, float f, float f2) {
        tGPainter.setBackground(this.config.getColorBorder());
        tGPainter.initPath(2);
        tGPainter.addRectangle(f, f2, this.bufferWidth, 20.0f);
        tGPainter.addRectangle(f, f2 + (float)(this.clientArea.height - 20), this.bufferWidth, 20.0f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.addRectangle(f, f2, this.width, this.clientArea.height);
        tGPainter.closePath();
    }

    protected void paintPosition(TGPainter tGPainter, float f, float f2) {
        if (!TuxGuitar.instance().getPlayer().isRunning()) {
            TGMeasure tGMeasure = this.getMeasure();
            TGBeatImpl tGBeatImpl = this.getCaret().getSelectedBeat();
            if (tGBeatImpl != null) {
                float f3 = (float)(tGBeatImpl.getStart() - tGMeasure.getStart()) * (this.timeWidth * (float)tGMeasure.getTimeSignature().getNumerator()) / (float)tGMeasure.getLength();
                float f4 = (float)tGBeatImpl.getDuration().getTime() * this.timeWidth / (float)tGMeasure.getTimeSignature().getDenominator().getTime();
                tGPainter.setBackground(this.config.getColorPosition());
                tGPainter.initPath(2);
                tGPainter.addRectangle(f + ((float)this.leftSpacing + f3), f2, f4, 20.0f);
                tGPainter.closePath();
                tGPainter.initPath(2);
                tGPainter.addRectangle(f + ((float)this.leftSpacing + f3), f2 + (float)(this.clientArea.height - 20), f4, 20.0f);
                tGPainter.closePath();
            }
        }
    }

    protected void paintSelection(TGPainter tGPainter, float f, float f2) {
        if (!TuxGuitar.instance().getPlayer().isRunning()) {
            this.selectionFinish();
            if (this.selection >= 0) {
                int n = Math.round(f);
                int n2 = Math.round(f2 + (float)(this.maxNote - this.selection) * this.lineHeight);
                int n3 = Math.round(this.bufferWidth);
                int n4 = Math.round(this.lineHeight);
                this.selectionBackBuffer = new Image((Device)this.editor.getDisplay(), n3, n4);
                tGPainter.copyArea(this.selectionBackBuffer, n, n2);
                tGPainter.setAlpha(100);
                tGPainter.setBackground(this.config.getColorLine(2));
                tGPainter.initPath(2);
                tGPainter.addRectangle(n, n2, n3, n4);
                tGPainter.closePath();
                this.selectionX = n;
                this.selectionY = n2;
            }
        }
    }

    protected void updateSelection(float f) {
        int n;
        if (!TuxGuitar.instance().getPlayer().isRunning() && this.selection != (n = this.getValueAt(f))) {
            this.selection = n;
            int n2 = this.editor.getHorizontalBar().getSelection();
            int n3 = this.editor.getVerticalBar().getSelection();
            TGPainter tGPainter = new TGPainter(new GC(this.editor));
            this.paintSelection(tGPainter, -n2, 20 - n3);
            tGPainter.dispose();
        }
    }

    public void selectionFinish() {
        if (this.selectionBackBuffer != null && !this.selectionBackBuffer.isDisposed()) {
            TGPainter tGPainter = new TGPainter(new GC(this.editor));
            tGPainter.drawImage(this.selectionBackBuffer, this.selectionX, this.selectionY);
            tGPainter.dispose();
        }
        this.disposeSelectionBuffer();
    }

    protected void disposeSelectionBuffer() {
        if (this.selectionBackBuffer != null && !this.selectionBackBuffer.isDisposed()) {
            this.selectionBackBuffer.dispose();
            this.selectionBackBuffer = null;
        }
    }

    protected void hit(float f, float f2) {
        Object object;
        TGMeasure tGMeasure = this.getMeasure();
        int n = this.getValueAt(f2);
        long l = this.getStartAt(f);
        if (l >= tGMeasure.getStart() && l < tGMeasure.getStart() + tGMeasure.getLength()) {
            object = this.getCaret();
            ((Caret)object).update(((Caret)object).getTrack().getNumber(), l, ((Caret)object).getStringNumber());
            TuxGuitar.instance().updateCache(true);
        }
        if (n >= this.minNote || n <= this.maxNote) {
            if (l >= tGMeasure.getStart()) {
                object = TuxGuitar.instance().getSongManager().getMeasureManager().getBeatIn(tGMeasure, l);
                if (object != null && !this.removeNote((TGBeat)object, n)) {
                    this.addNote((TGBeat)object, l, n);
                }
            } else {
                this.play(n);
            }
        }
    }

    private boolean removeNote(TGBeat tGBeat, int n) {
        Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
        TGMeasure tGMeasure = this.getMeasure();
        Iterator iterator = tGBeat.getNotes().iterator();
        while (iterator.hasNext()) {
            TGNoteImpl tGNoteImpl = (TGNoteImpl)iterator.next();
            if (tGNoteImpl.getRealValue() != n) continue;
            caret.update(tGMeasure.getTrack().getNumber(), tGBeat.getStart(), tGNoteImpl.getString());
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
            tGSongManager.getMeasureManager().removeNote(tGNoteImpl);
            TuxGuitar.instance().getUndoableManager().addEdit(undoableMeasureGeneric.endUndo());
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            this.afterAction();
            return true;
        }
        return false;
    }

    private boolean addNote(TGBeat tGBeat, long l, int n) {
        if (tGBeat != null) {
            TGMeasure tGMeasure = this.getMeasure();
            Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
            List list = tGMeasure.getTrack().getStrings();
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                TGString tGString = (TGString)list.get(i);
                if (n < tGString.getValue()) continue;
                boolean bl = true;
                Iterator iterator = tGBeat.getNotes().iterator();
                while (iterator.hasNext()) {
                    object = (TGNoteImpl)iterator.next();
                    if (((TGNote)object).getString() != tGString.getNumber()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                object = TuxGuitar.instance().getSongManager();
                UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
                TGNote tGNote = ((TGSongManager)object).getFactory().newNote();
                tGNote.setValue(n - tGString.getValue());
                tGNote.setVelocity(caret.getVelocity());
                tGNote.setString(tGString.getNumber());
                TGDuration tGDuration = ((TGSongManager)object).getFactory().newDuration();
                caret.getDuration().copy(tGDuration);
                ((TGSongManager)object).getMeasureManager().addNote(tGBeat, tGNote, tGDuration, l);
                caret.moveTo(caret.getTrack(), caret.getMeasure(), tGNote.getBeat(), tGNote.getString());
                TuxGuitar.instance().getUndoableManager().addEdit(undoableMeasureGeneric.endUndo());
                TuxGuitar.instance().getFileHistory().setUnsavedFile();
                caret.getSelectedBeat().play();
                this.afterAction();
                return true;
            }
        }
        return false;
    }

    protected void afterAction() {
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(this.getMeasure().getNumber());
        TuxGuitar.instance().updateCache(true);
        this.editor.redraw();
    }

    protected void play(final int n) {
        new Thread(new Runnable(){

            public void run() {
                TGTrack tGTrack = MatrixEditor.this.getMeasure().getTrack();
                int n3 = 127;
                int n2 = 64;
                short s = tGTrack.getChannel().getChorus();
                short s2 = tGTrack.getChannel().getReverb();
                short s3 = tGTrack.getChannel().getPhaser();
                short s4 = tGTrack.getChannel().getTremolo();
                short s5 = tGTrack.getChannel().getChannel();
                short s6 = tGTrack.getChannel().getInstrument();
                int[][] nArrayArray = new int[][]{{tGTrack.getOffset() + n, 95}};
                TuxGuitar.instance().getPlayer().playBeat(s5, s6, n3, n2, s, s2, s3, s4, nArrayArray);
            }
        }).start();
    }

    protected int loadGrids() {
        int n = TuxGuitar.instance().getConfig().getIntConfigValue("matrix.grids");
        for (int i = 0; i < DIVISIONS.length; ++i) {
            if (n != DIVISIONS[i]) continue;
            return n;
        }
        return DIVISIONS[1];
    }

    protected void setGrids(int n) {
        this.grids = n;
        this.disposeBuffer();
        this.redraw();
    }

    public int getGrids() {
        return this.grids;
    }

    protected TGMeasure getMeasure() {
        TGMeasureImpl tGMeasureImpl;
        if (TuxGuitar.instance().getPlayer().isRunning() && (tGMeasureImpl = TuxGuitar.instance().getEditorCache().getPlayMeasure()) != null) {
            return tGMeasureImpl;
        }
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getMeasure();
    }

    protected Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    protected void resetPlayed() {
        this.playedBeat = null;
        this.playedMeasure = -1;
        this.playedTrack = -1;
    }

    public void redraw() {
        if (!this.isDisposed() && !TGSongLock.isLocked()) {
            this.editor.redraw();
            this.loadDurationImage(false);
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed() && !TGSongLock.isLocked() && TuxGuitar.instance().getPlayer().isRunning() && !this.paintLock.isLocked()) {
            TGMeasureImpl tGMeasureImpl = TuxGuitar.instance().getEditorCache().getPlayMeasure();
            TGBeatImpl tGBeatImpl = TuxGuitar.instance().getEditorCache().getPlayBeat();
            if (tGMeasureImpl != null && tGBeatImpl != null) {
                boolean bl;
                int n = tGMeasureImpl.getNumber();
                int n2 = tGMeasureImpl.getTrack().getNumber();
                boolean bl2 = bl = n != this.playedMeasure || n2 != this.playedTrack;
                if (bl) {
                    this.resetPlayed();
                    this.editor.redraw();
                } else {
                    TGPainter tGPainter = new TGPainter(new GC(this.editor));
                    int n3 = this.editor.getHorizontalBar().getSelection();
                    int n4 = this.editor.getVerticalBar().getSelection();
                    if (this.playedBeat != null) {
                        this.paintBeat(tGPainter, tGMeasureImpl, this.playedBeat, -n3, 20 - n4);
                    }
                    this.paintBeat(tGPainter, tGMeasureImpl, tGBeatImpl, -n3, 20 - n4);
                    tGPainter.dispose();
                }
                this.playedMeasure = n;
                this.playedTrack = n2;
                this.playedBeat = tGBeatImpl;
            }
        }
    }

    protected void configure() {
        this.config.configure(this.dialog);
        this.disposeBuffer();
        this.redraw();
    }

    private void layout() {
        this.toolbar.layout();
        this.editor.layout();
        this.composite.layout(true, true);
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
            this.settings.setImage(TuxGuitar.instance().getIconManager().getSettings());
            this.loadDurationImage(true);
            this.layout();
            this.redraw();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("matrix.editor"));
            this.gridsLabel.setText(TuxGuitar.getProperty("matrix.grids"));
            this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
            this.disposeBuffer();
            this.layout();
            this.redraw();
        }
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    protected void disposeBuffer() {
        if (this.buffer != null && !this.buffer.isDisposed()) {
            this.buffer.dispose();
            this.buffer = null;
        }
    }

    protected void dispose(Resource[] resourceArray) {
        if (resourceArray != null) {
            for (int i = 0; i < resourceArray.length; ++i) {
                this.dispose(resourceArray[i]);
            }
        }
    }

    protected void dispose(Resource resource) {
        if (resource != null) {
            resource.dispose();
        }
    }

    protected void disposeAll() {
        this.disposeBuffer();
        this.disposeSelectionBuffer();
        this.config.dispose();
    }

    protected Composite getEditor() {
        return this.editor;
    }

    protected class DisposeListenerImpl
    implements DisposeListener {
        protected DisposeListenerImpl() {
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            MatrixEditor.this.disposeAll();
        }
    }

    protected class BufferDisposer {
        private int numerator;
        private int denominator;
        private int track;
        private boolean percussion;
        private int width;
        private int height;

        protected BufferDisposer() {
        }

        public void update(int n, int n2) {
            TGMeasure tGMeasure = MatrixEditor.this.getMeasure();
            int n3 = tGMeasure.getTrack().getNumber();
            int n4 = tGMeasure.getTimeSignature().getNumerator();
            int n5 = tGMeasure.getTimeSignature().getDenominator().getValue();
            boolean bl = tGMeasure.getTrack().isPercussionTrack();
            if (n != this.width || n2 != this.height || this.track != n3 || this.numerator != n4 || this.denominator != n5 || this.percussion != bl) {
                MatrixEditor.this.disposeBuffer();
            }
            this.track = n3;
            this.numerator = n4;
            this.denominator = n5;
            this.percussion = bl;
            this.width = n;
            this.height = n2;
        }
    }
}

