/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.fretboard;

import java.util.Properties;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class FretBoardConfig {
    public static final int DISPLAY_TEXT_NOTE = 1;
    public static final int DISPLAY_TEXT_SCALE = 2;
    private int style;
    private Font font;
    private Color colorBackground;
    private Color colorString;
    private Color colorFretPoint;
    private Color colorNote;
    private Color colorScale;
    private static final int MINIMUN_CONTROL_WIDTH = 180;
    private static final int MINIMUN_BUTTON_WIDTH = 80;
    private static final int MINIMUN_BUTTON_HEIGHT = 25;

    public int getStyle() {
        return this.style;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getColorBackground() {
        return this.colorBackground;
    }

    public Color getColorString() {
        return this.colorString;
    }

    public Color getColorFretPoint() {
        return this.colorFretPoint;
    }

    public Color getColorNote() {
        return this.colorNote;
    }

    public Color getColorScale() {
        return this.colorScale;
    }

    public void load() {
        Display display = TuxGuitar.instance().getDisplay();
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        this.style = tGConfigManager.getIntConfigValue("fretboard.style");
        this.font = new Font((Device)display, tGConfigManager.getFontDataConfigValue("fretboard.font"));
        this.colorBackground = new Color(display, tGConfigManager.getRGBConfigValue("fretboard.color.background"));
        this.colorString = new Color(display, tGConfigManager.getRGBConfigValue("fretboard.color.string"));
        this.colorFretPoint = new Color(display, tGConfigManager.getRGBConfigValue("fretboard.color.fret-point"));
        this.colorNote = new Color(display, tGConfigManager.getRGBConfigValue("fretboard.color.note"));
        this.colorScale = new Color(display, tGConfigManager.getRGBConfigValue("fretboard.color.scale"));
    }

    public void defaults() {
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        Properties properties = tGConfigManager.getDefaults();
        tGConfigManager.setProperty("fretboard.style", properties.getProperty("fretboard.style"));
        tGConfigManager.setProperty("fretboard.font", properties.getProperty("fretboard.font"));
        tGConfigManager.setProperty("fretboard.color.background", properties.getProperty("fretboard.color.background"));
        tGConfigManager.setProperty("fretboard.color.string", properties.getProperty("fretboard.color.string"));
        tGConfigManager.setProperty("fretboard.color.fret-point", properties.getProperty("fretboard.color.fret-point"));
        tGConfigManager.setProperty("fretboard.color.note", properties.getProperty("fretboard.color.note"));
        tGConfigManager.setProperty("fretboard.color.scale", properties.getProperty("fretboard.color.scale"));
    }

    public void save(int n, FontData fontData, RGB rGB, RGB rGB2, RGB rGB3, RGB rGB4, RGB rGB5) {
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        tGConfigManager.setProperty("fretboard.style", n);
        tGConfigManager.setProperty("fretboard.font", fontData);
        tGConfigManager.setProperty("fretboard.color.background", rGB);
        tGConfigManager.setProperty("fretboard.color.string", rGB2);
        tGConfigManager.setProperty("fretboard.color.fret-point", rGB3);
        tGConfigManager.setProperty("fretboard.color.note", rGB4);
        tGConfigManager.setProperty("fretboard.color.scale", rGB5);
    }

    public void dispose() {
        this.font.dispose();
        this.colorBackground.dispose();
        this.colorString.dispose();
        this.colorFretPoint.dispose();
        this.colorNote.dispose();
        this.colorScale.dispose();
    }

    public void configure(Shell shell) {
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setText(TuxGuitar.getProperty("fretboard.settings"));
        Group group = new Group(shell2, 16);
        group.setLayout(new GridLayout(2, false));
        group.setLayoutData(new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("fretboard.settings"));
        final FontData fontData = this.getFontChooser(group, TuxGuitar.getProperty("fretboard.font"), this.font.getFontData()[0]);
        final RGB rGB = this.getColorChooser(group, TuxGuitar.getProperty("fretboard.background-color"), this.colorBackground.getRGB());
        final RGB rGB2 = this.getColorChooser(group, TuxGuitar.getProperty("fretboard.string-color"), this.colorString.getRGB());
        final RGB rGB3 = this.getColorChooser(group, TuxGuitar.getProperty("fretboard.fretpoint-color"), this.colorFretPoint.getRGB());
        final RGB rGB4 = this.getColorChooser(group, TuxGuitar.getProperty("fretboard.note-color"), this.colorNote.getRGB());
        final RGB rGB5 = this.getColorChooser(group, TuxGuitar.getProperty("fretboard.scale-note-color"), this.colorScale.getRGB());
        group = new Group(shell2, 16);
        group.setLayout(new GridLayout());
        group.setLayoutData(new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("fretboard.settings.options"));
        final Button button = new Button(group, 32);
        button.setLayoutData(new GridData(4, 4, true, true));
        button.setText(TuxGuitar.getProperty("fretboard.display-note-text"));
        button.setSelection((this.style & 1) != 0);
        final Button button2 = new Button(group, 32);
        button2.setLayoutData(new GridData(4, 4, true, true));
        button2.setText(TuxGuitar.getProperty("fretboard.display-scale-text"));
        button2.setSelection((this.style & 2) != 0);
        Composite composite = new Composite(shell2, 0);
        composite.setLayout(new GridLayout(3, false));
        composite.setLayoutData(new GridData(0x1000008, 4, true, true));
        Button button3 = new Button(composite, 8);
        button3.setText(TuxGuitar.getProperty("defaults"));
        button3.setLayoutData(this.getButtonData());
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
                FretBoardConfig.this.defaults();
                FretBoardConfig.this.applyChanges();
            }
        });
        Button button4 = new Button(composite, 8);
        button4.setText(TuxGuitar.getProperty("ok"));
        button4.setLayoutData(this.getButtonData());
        button4.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = 0;
                n |= button.getSelection() ? 1 : 0;
                int n2 = button2.getSelection() ? 2 : 0;
                shell2.dispose();
                FretBoardConfig.this.save(n |= n2, fontData, rGB, rGB2, rGB3, rGB4, rGB5);
                FretBoardConfig.this.applyChanges();
            }
        });
        Button button5 = new Button(composite, 8);
        button5.setText(TuxGuitar.getProperty("cancel"));
        button5.setLayoutData(this.getButtonData());
        button5.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        DialogUtils.openDialog(shell2, 11);
    }

    protected GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void applyChanges() {
        this.dispose();
        this.load();
    }

    private RGB getColorChooser(final Composite composite, String string, RGB rGB) {
        final RGB rGB2 = new RGB(rGB.red, rGB.green, rGB.blue);
        Label label = new Label(composite, 0);
        label.setLayoutData(new GridData(131072, 0x1000000, true, true));
        label.setText(string);
        final Button button = new Button(composite, 8);
        button.setLayoutData(this.getAlignmentData(180, 4));
        button.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Color color = new Color(composite.getDisplay(), rGB2);
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                tGPainter.setBackground(color);
                tGPainter.initPath(2);
                tGPainter.addRectangle(5.0f, 5.0f, button.getSize().x - 10, button.getSize().y - 10);
                tGPainter.closePath();
                tGPainter.dispose();
                color.dispose();
            }
        });
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(composite.getShell());
                colorDialog.setRGB(rGB2);
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    rGB2.red = rGB.red;
                    rGB2.green = rGB.green;
                    rGB2.blue = rGB.blue;
                    button.redraw();
                }
            }
        });
        return rGB2;
    }

    private FontData getFontChooser(final Composite composite, String string, FontData fontData) {
        final FontData fontData2 = new FontData(fontData.getName(), fontData.getHeight(), fontData.getStyle());
        Label label = new Label(composite, 0);
        label.setLayoutData(new GridData(131072, 0x1000000, true, true));
        label.setText(string);
        Button button = new Button(composite, 8);
        button.setLayoutData(this.getAlignmentData(180, 4));
        button.setText(TuxGuitar.getProperty("choose"));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Font font = new Font((Device)composite.getDisplay(), fontData2);
                FontDialog fontDialog = new FontDialog(composite.getShell());
                fontDialog.setFontList(font.getFontData());
                FontData fontData = fontDialog.open();
                if (fontData != null) {
                    fontData2.setName(fontData.getName());
                    fontData2.setHeight(fontData.getHeight());
                    fontData2.setStyle(fontData.getStyle());
                }
                font.dispose();
            }
        });
        return fontData2;
    }

    private GridData getAlignmentData(int n, int n2) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n;
        gridData.horizontalAlignment = n2;
        gridData.verticalAlignment = -1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        return gridData;
    }
}

