/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.chord.ChordDialog;
import org.herac.tuxguitar.gui.editors.tab.TGChordImpl;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGString;

public class ChordList
extends Composite {
    private static final int MIN_HEIGHT = 160;
    private static final int SCROLL_INCREMENT = 25;
    private static final int CHORD_FIRST_FRET_SPACING = 12;
    private static final int CHORD_STRING_SPACING = 8;
    private static final int CHORD_FRET_SPACING = 10;
    private static final int CHORD_NOTE_SIZE = 6;
    private ChordDialog dialog;
    private TGBeat beat;
    private List graphicChords;
    private int height;
    private TGChordImpl selectedChord;
    private Composite composite;
    private Font font;

    public ChordList(ChordDialog chordDialog, Composite composite, TGBeat tGBeat) {
        super(composite, 0);
        this.setLayout(chordDialog.gridLayout(1, false, 0, 0));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.graphicChords = new ArrayList();
        this.dialog = chordDialog;
        this.beat = tGBeat;
        this.init();
    }

    private void init() {
        this.composite = new Composite(this, 0x20000A00);
        this.composite.setBackground(this.getDisplay().getSystemColor(1));
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                ChordList.this.paintChords(tGPainter);
                tGPainter.dispose();
            }
        });
        this.composite.addMouseListener(new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                ChordList.this.getComposite().setFocus();
                ChordList.this.getDialog().getEditor().setChord(ChordList.this.getChord(mouseEvent.x, mouseEvent.y, true));
                ChordList.this.redraw();
            }
        });
        final Point point = new Point(0, 0);
        final ScrollBar scrollBar = this.composite.getVerticalBar();
        scrollBar.setIncrement(25);
        scrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int n = scrollBar.getSelection();
                int n2 = -n - point.y;
                Rectangle rectangle = ChordList.this.getComposite().getBounds();
                ChordList.this.getShell().scroll(0, n2, 0, 0, rectangle.width, rectangle.height, false);
                point.y = -n;
                ChordList.this.redraw();
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 160;
        this.composite.setLayoutData(gridData);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ChordList.this.disposeChords();
                ChordList.this.disposeFont();
            }
        });
    }

    public void redraw() {
        super.redraw();
        this.composite.redraw();
    }

    protected void paintChords(TGPainter tGPainter) {
        int n = 0;
        int n2 = 5;
        int n3 = 10;
        int n4 = this.composite.getVerticalBar().getSelection();
        Iterator iterator = this.graphicChords.iterator();
        while (iterator.hasNext()) {
            TGChordImpl tGChordImpl = (TGChordImpl)iterator.next();
            Color color = this.getChordColor(tGChordImpl);
            tGChordImpl.setBackgroundColor(this.composite.getBackground());
            tGChordImpl.setColor(color);
            tGChordImpl.setNoteColor(color);
            tGChordImpl.setTonicColor(this.getDisplay().getSystemColor(4));
            tGChordImpl.setFirstFretSpacing(12);
            tGChordImpl.setStringSpacing(8);
            tGChordImpl.setFretSpacing(10);
            tGChordImpl.setNoteSize(6);
            tGChordImpl.setFirstFretFont(this.getFont(tGPainter.getGC()));
            tGChordImpl.setStyle(32);
            tGChordImpl.update(this.getDisplay());
            if (n2 + tGChordImpl.getWidth() >= this.getBounds().x + this.getBounds().width - 20) {
                n2 = 10;
                n3 += tGChordImpl.getHeight() + 10;
            }
            tGChordImpl.setEditing(true);
            tGChordImpl.setPosX(n2);
            tGChordImpl.setPosY(n3 - n4);
            tGChordImpl.paint(tGPainter, tGChordImpl.getWidth() / 2, 0);
            n2 += tGChordImpl.getWidth() + 10;
            n = Math.max(n, tGChordImpl.getHeight());
        }
        this.height = n3 + n + 10;
        this.updateScroll();
    }

    private Color getChordColor(TGChordImpl tGChordImpl) {
        if (this.selectedChord != null && this.selectedChord.equals(tGChordImpl)) {
            return this.getDisplay().getSystemColor(9);
        }
        return this.getDisplay().getSystemColor(2);
    }

    public void updateScroll() {
        Rectangle rectangle = this.composite.getBounds();
        Rectangle rectangle2 = this.composite.getClientArea();
        ScrollBar scrollBar = this.composite.getVerticalBar();
        scrollBar.setMaximum(this.height);
        scrollBar.setThumb(Math.min(rectangle.height, rectangle2.height));
    }

    protected int getTrackString(int n) {
        TGString tGString = this.beat.getMeasure().getTrack().getString(n);
        return tGString.getValue();
    }

    protected Font getFont(GC gC) {
        if (this.font == null || this.font.isDisposed()) {
            FontData[] fontDataArray;
            Font font = gC.getFont();
            if (font == null || font.isDisposed()) {
                font = this.getDisplay().getSystemFont();
            }
            if ((fontDataArray = font.getFontData()).length > 0) {
                this.font = new Font((Device)this.getDisplay(), fontDataArray[0].getName(), Math.min(7, fontDataArray[0].getHeight()), 1);
            }
        }
        return this.font;
    }

    protected TGChordImpl getChord(int n, int n2, boolean bl) {
        Iterator iterator = this.graphicChords.iterator();
        while (iterator.hasNext()) {
            TGChordImpl tGChordImpl = (TGChordImpl)iterator.next();
            int n3 = tGChordImpl.getPosX();
            int n4 = n3 + tGChordImpl.getWidth();
            int n5 = tGChordImpl.getPosY();
            int n6 = n5 + tGChordImpl.getHeight();
            if (n <= n3 || n >= n4 || n2 <= n5 || n2 >= n6) continue;
            if (bl) {
                if (this.selectedChord != null) {
                    this.selectedChord.dispose();
                }
                this.selectedChord = tGChordImpl;
                tGChordImpl.dispose();
            }
            return tGChordImpl;
        }
        return null;
    }

    public void setChords(List list) {
        this.disposeChords();
        this.selectedChord = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGChordImpl tGChordImpl = (TGChordImpl)iterator.next();
            tGChordImpl.setTonic(this.dialog.getSelector().getTonicList().getSelectionIndex());
            tGChordImpl.setBeat(this.beat);
            this.graphicChords.add(tGChordImpl);
        }
        this.redraw();
    }

    public void disposeFont() {
        if (this.font != null) {
            this.font.dispose();
        }
    }

    public void disposeChords() {
        Iterator iterator = this.graphicChords.iterator();
        while (iterator.hasNext()) {
            ((TGChordImpl)iterator.next()).dispose();
        }
        this.graphicChords.clear();
    }

    protected Composite getComposite() {
        return this.composite;
    }

    protected ChordDialog getDialog() {
        return this.dialog;
    }
}

