/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.piano.Piano;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.system.lock.TGSongLock;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class PianoEditor
implements IconLoader,
LanguageLoader {
    private Piano piano;

    public PianoEditor() {
        TuxGuitar.instance().getIconManager().addLoader(this);
        TuxGuitar.instance().getLanguageManager().addLoader(this);
    }

    public void show() {
        Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 2144);
        shell.setLayout(new GridLayout());
        shell.setText(TuxGuitar.getProperty("piano.editor"));
        this.piano = new Piano(shell, 0);
        TuxGuitar.instance().updateCache(true);
        DialogUtils.openDialog(shell, 11);
        TuxGuitar.instance().updateCache(true);
    }

    private Piano getPiano() {
        return this.piano;
    }

    public void setScaleChanges() {
        if (!this.isDisposed()) {
            this.getPiano().setChanges(true);
        }
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.getPiano().getShell().dispose();
            this.getPiano().dispose();
        }
    }

    public void redraw() {
        if (!this.isDisposed() && !TGSongLock.isLocked()) {
            this.getPiano().redraw();
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed() && !TGSongLock.isLocked()) {
            this.getPiano().redrawPlayingMode();
        }
    }

    public boolean isDisposed() {
        return this.getPiano() == null || this.getPiano().isDisposed();
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.getPiano().loadProperties();
            this.getPiano().getShell().setText(TuxGuitar.getProperty("piano.editor"));
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.getPiano().loadIcons();
        }
    }
}

