/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.TGFactoryImpl;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintDocumentData;
import org.herac.tuxguitar.gui.printer.PrintPage;
import org.herac.tuxguitar.song.managers.TGSongManager;

public class PrintAction
extends Action {
    public static final String NAME = "action.file.print";

    public PrintAction() {
        super(NAME, 15);
    }

    protected int execute(TypedEvent typedEvent) {
        PrintDialog printDialog;
        PrinterData printerData;
        PrintDocumentData printDocumentData = PrintDocumentData.openDialog(TuxGuitar.instance().getShell());
        if (printDocumentData != null && (printerData = (printDialog = new PrintDialog(TuxGuitar.instance().getShell(), 0)).open()) != null) {
            this.print(printerData, printDocumentData);
        }
        return 0;
    }

    public void print(PrinterData printerData, final PrintDocumentData printDocumentData) {
        final Printer printer = new Printer(printerData);
        new Thread(new Runnable(){

            public void run() {
                final TGSongManager tGSongManager = new TGSongManager();
                tGSongManager.setFactory(new TGFactoryImpl());
                tGSongManager.setSong(PrintAction.this.getSongManager().getSong().clone(tGSongManager.getFactory()));
                new SyncThread(new Runnable(){

                    public void run() {
                        Tablature tablature = new Tablature(PrintAction.this.getEditor().getTablature());
                        tablature.setSongManager(tGSongManager);
                        PrinterViewLayout printerViewLayout = new PrinterViewLayout(tablature, printDocumentData, PrintAction.this.getPrinterScale(printer));
                        PrintAction.this.print(printer, printerViewLayout);
                    }
                }).start();
            }
        }).start();
    }

    protected void print(final Printer printer, final PrinterViewLayout printerViewLayout) {
        new Thread(new Runnable(){

            public void run() {
                final Rectangle rectangle = PrintAction.this.getPrinterArea(printer, 0.5);
                printerViewLayout.getTablature().updateTablature();
                printerViewLayout.getTablature().getCaret().update(PrintAction.this.getEditor().getTablature().getCaret().getTrack().getNumber());
                new SyncThread(new Runnable(){

                    public void run() {
                        PrintDocument printDocument = printerViewLayout.makeDocument(rectangle.width - rectangle.x, rectangle.height - rectangle.y);
                        printerViewLayout.getTablature().dispose();
                        PrintAction.this.print(printer, printDocument, rectangle);
                    }
                }).start();
            }
        }).start();
    }

    protected void print(final Printer printer, final PrintDocument printDocument, final Rectangle rectangle) {
        new Thread(new Runnable(){

            public void run() {
                if (printer.startJob("TuxGuitar")) {
                    for (int i = 0; i < printDocument.count(); ++i) {
                        PrintPage printPage = (PrintPage)printDocument.getPages().get(i);
                        if (!printer.startPage()) continue;
                        GC gC = new GC((Drawable)printer);
                        Image image = new Image((Device)printer, printPage.getData());
                        gC.drawImage(image, rectangle.x, rectangle.y);
                        image.dispose();
                        gC.dispose();
                        printer.endPage();
                    }
                }
                printer.endJob();
                printer.dispose();
            }
        }).start();
    }

    protected Rectangle getPrinterArea(Printer printer, double d) {
        Rectangle rectangle = printer.getClientArea();
        Rectangle rectangle2 = printer.computeTrim(0, 0, 0, 0);
        Point point = printer.getDPI();
        int n = (int)(d * (double)point.x) - rectangle2.x;
        int n2 = (int)(d * (double)point.y) - rectangle2.y;
        int n3 = rectangle.width + rectangle2.width - (int)(d * (double)point.x) - rectangle2.x;
        int n4 = rectangle.height + rectangle2.height - (int)(d * (double)point.y) - rectangle2.y;
        return new Rectangle(n, n2, n3, n4);
    }

    protected float getPrinterScale(Printer printer) {
        Point point = printer.getDPI();
        if (point != null) {
            return (float)point.x / 100.0f;
        }
        return 1.0f;
    }
}

