/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.file.FileActionUtils;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.lock.TGActionLock;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.io.base.TGSongImporter;

public class ImportSongAction
extends Action {
    public static final String NAME = "action.file.import";

    public ImportSongAction() {
        super(NAME, 5);
    }

    protected int execute(final TypedEvent typedEvent) {
        TuxGuitar.instance().getPlayer().reset();
        if (TuxGuitar.instance().getFileHistory().isUnsavedFile()) {
            ConfirmDialog confirmDialog = new ConfirmDialog(TuxGuitar.getProperty("file.save-changes-question"));
            int n = confirmDialog.confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO | ConfirmDialog.BUTTON_CANCEL);
            if (n == ConfirmDialog.STATUS_CANCEL) {
                return 2;
            }
            if (n == ConfirmDialog.STATUS_YES) {
                final String string = FileActionUtils.getFileName();
                if (string == null) {
                    return 2;
                }
                TuxGuitar.instance().loadCursor(1);
                new Thread(new Runnable(){

                    public void run() {
                        if (!TuxGuitar.isDisposed()) {
                            FileActionUtils.save(string);
                            new SyncThread(new Runnable(){

                                public void run() {
                                    if (!TuxGuitar.isDisposed()) {
                                        TuxGuitar.instance().loadCursor(0);
                                        ImportSongAction.this.importFile((this).typedEvent.widget.getData());
                                    }
                                }
                            }).start();
                        }
                    }
                }).start();
                return 0;
            }
        }
        this.importFile(typedEvent.widget.getData());
        return 0;
    }

    protected void importFile(Object object) {
        final TGSongImporter tGSongImporter = (TGSongImporter)object;
        final String string = FileChooser.instance().open(TuxGuitar.instance().getShell(), tGSongImporter.getFileFormat());
        if (string == null || !tGSongImporter.configure()) {
            TGActionLock.unlock();
            return;
        }
        TuxGuitar.instance().loadCursor(1);
        new Thread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    FileActionUtils.importSong(tGSongImporter, string);
                    TuxGuitar.instance().loadCursor(0);
                    TGActionLock.unlock();
                }
            }
        }).start();
    }
}

