/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.duration;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGDuration;

public class IncrementDurationAction
extends Action {
    public static final String NAME = "action.note.duration.increment-duration";

    public IncrementDurationAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        TGDuration tGDuration = this.getEditor().getTablature().getCaret().getDuration();
        if (tGDuration.getValue() < 64) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            this.changeDuration(tGDuration.getValue() * 2);
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            this.updateTablature();
            this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        }
        return 0;
    }

    private void changeDuration(int n) {
        Caret caret = this.getEditor().getTablature().getCaret();
        caret.getDuration().setValue(n);
        caret.getDuration().setDotted(false);
        caret.getDuration().setDoubleDotted(false);
        caret.changeDuration(caret.getDuration().clone(this.getSongManager().getFactory()));
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }
}

