/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeTimeSignature;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGTimeSignature;

public class ChangeTimeSignatureAction
extends Action {
    public static final String NAME = "action.composition.change-time-signature";

    public ChangeTimeSignatureAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return 0;
    }

    public void showDialog(Shell shell) {
        TGMeasureImpl tGMeasureImpl = this.getEditor().getTablature().getCaret().getMeasure();
        if (tGMeasureImpl != null) {
            final Shell shell2 = DialogUtils.newDialog(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setText(TuxGuitar.getProperty("composition.timesignature"));
            Group group = new Group(shell2, 16);
            group.setLayout(new GridLayout(2, false));
            group.setLayoutData(new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("composition.timesignature"));
            TGTimeSignature tGTimeSignature = tGMeasureImpl.getTimeSignature();
            Label label = new Label(group, 0);
            label.setText(TuxGuitar.getProperty("composition.timesignature.Numerator"));
            final Combo combo = new Combo(group, 12);
            for (int i = 1; i <= 32; ++i) {
                combo.add(Integer.toString(i));
            }
            combo.setText(Integer.toString(tGTimeSignature.getNumerator()));
            combo.setLayoutData(this.getComboData());
            Label label2 = new Label(group, 0);
            label2.setText(TuxGuitar.getProperty("composition.timesignature.denominator"));
            final Combo combo2 = new Combo(group, 12);
            for (int i = 1; i <= 32; i *= 2) {
                combo2.add(Integer.toString(i));
            }
            combo2.setText(Integer.toString(tGTimeSignature.getDenominator().getValue()));
            combo2.setLayoutData(this.getComboData());
            Group group2 = new Group(shell2, 16);
            group2.setLayout(new GridLayout());
            group2.setText(TuxGuitar.getProperty("options"));
            group2.setLayoutData(new GridData(4, 4, true, true));
            final Button button = new Button(group2, 32);
            button.setText(TuxGuitar.getProperty("composition.timesignature.to-the-end"));
            button.setSelection(true);
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout(2, false));
            composite.setLayoutData(new GridData(0x1000008, 4, true, true));
            Button button2 = new Button(composite, 8);
            button2.setText(TuxGuitar.getProperty("ok"));
            button2.setLayoutData(this.getButtonData());
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = button.getSelection();
                    int n = Integer.parseInt(combo.getText());
                    int n2 = Integer.parseInt(combo2.getText());
                    TGTimeSignature tGTimeSignature = ChangeTimeSignatureAction.this.getSongManager().getFactory().newTimeSignature();
                    tGTimeSignature.setNumerator(n);
                    tGTimeSignature.getDenominator().setValue(n2);
                    ChangeTimeSignatureAction.this.setTimeSignature(tGTimeSignature, bl);
                    shell2.dispose();
                }
            });
            Button button3 = new Button(composite, 8);
            button3.setLayoutData(this.getButtonData());
            button3.setText(TuxGuitar.getProperty("cancel"));
            button3.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            DialogUtils.openDialog(shell2, 11);
        }
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private GridData getComboData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 150;
        return gridData;
    }

    protected void setTimeSignature(TGTimeSignature tGTimeSignature, boolean bl) {
        UndoableChangeTimeSignature undoableChangeTimeSignature = UndoableChangeTimeSignature.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        TGMeasureImpl tGMeasureImpl = caret.getMeasure();
        this.getSongManager().changeTimeSignature(tGMeasureImpl.getStart(), tGTimeSignature, bl);
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.updateTablature();
        this.addUndoableEdit(undoableChangeTimeSignature.endUndo(tGTimeSignature, bl));
    }

    public TGSongManager getSongManager() {
        return super.getSongManager();
    }
}

