/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.alsa;

import org.herac.tuxguitar.player.base.MidiOut;
import org.herac.tuxguitar.player.impl.midiport.alsa.MidiPortImpl;
import org.herac.tuxguitar.player.impl.midiport.alsa.MidiSystem;

public class MidiOutImpl
implements MidiOut {
    private boolean connected;
    private MidiPortImpl midiPort;
    private MidiSystem midiSystem;

    public MidiOutImpl(MidiPortImpl midiPortImpl, MidiSystem midiSystem) {
        this.midiPort = midiPortImpl;
        this.midiSystem = midiSystem;
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void connect() {
        if (!this.isConnected()) {
            this.midiSystem.openPort(this.midiPort.getClient(), this.midiPort.getPort());
            this.connected = true;
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.midiSystem.closePort();
            this.connected = false;
        }
    }

    public void sendAllNotesOff() {
        for (int i = 0; i < 16; ++i) {
            this.sendControlChange(i, 123, 0);
        }
    }

    public void sendControlChange(int n, int n2, int n3) {
        if (this.isConnected()) {
            this.midiSystem.controlChange(n, n2, n3);
        }
    }

    public void sendNoteOff(int n, int n2, int n3) {
        if (this.isConnected()) {
            this.midiSystem.noteOff(n, n2, n3);
        }
    }

    public void sendNoteOn(int n, int n2, int n3) {
        if (this.isConnected()) {
            this.midiSystem.noteOn(n, n2, n3);
        }
    }

    public void sendPitchBend(int n, int n2) {
        if (this.isConnected()) {
            this.midiSystem.pitchBend(n, n2);
        }
    }

    public void sendProgramChange(int n, int n2) {
        if (this.isConnected()) {
            this.midiSystem.programChange(n, n2);
        }
    }

    public void sendSystemReset() {
    }
}

