/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.alsa;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.herac.tuxguitar.util.TGClassLoader;

public class JNILibraryLoader {
    private static final String JNI_EXTENSION = ".jnilib";
    private static final String JNI_TMP_PATH = System.getProperty("java.io.tmpdir") + File.separator;

    public static void loadLibrary(String string) {
        if (!JNILibraryLoader.loadFromClassPath(string + JNI_EXTENSION)) {
            System.loadLibrary(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadFromClassPath(String string) {
        File file = new File(JNI_TMP_PATH + string);
        try {
            InputStream inputStream;
            if (!file.exists() && (inputStream = TGClassLoader.instance().getClassLoader().getResourceAsStream(string)) != null) {
                int n;
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
            if (file.exists()) {
                System.load(file.getAbsolutePath());
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable throwable) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (file.exists()) {
                file.delete();
            }
        }
        return false;
    }
}

