/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.OptionArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Handouts
extends AbstractTool {
    static {
        Handouts.addVersion("$Id: Handouts.java,v 1.7 2005/11/29 21:05:02 blowagie Exp $");
    }

    public Handouts() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to convert", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the Handout has to be written", true, new PdfFilter()));
        OptionArgument optionArgument = new OptionArgument(this, "pages", "The number of pages you want on one handout page");
        optionArgument.addOption("2 pages on 1", "2");
        optionArgument.addOption("3 pages on 1", "3");
        optionArgument.addOption("4 pages on 1", "4");
        optionArgument.addOption("5 pages on 1", "5");
        optionArgument.addOption("6 pages on 1", "6");
        optionArgument.addOption("7 pages on 1", "7");
        optionArgument.addOption("8 pages on 1", "8");
        this.arguments.add(optionArgument);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Handouts", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Handouts OPENED ===");
    }

    public void execute() {
        try {
            int n;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            try {
                n = Integer.parseInt((String)this.getValue("pages"));
            }
            catch (Exception exception) {
                n = 4;
            }
            float f = 30.0f;
            float f2 = 280.0f;
            float f3 = 320.0f;
            float f4 = 565.0f;
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            float f5 = (778.0f - 20.0f * (float)(n - 1)) / (float)n;
            fArray[0] = 812.0f;
            fArray2[0] = 812.0f - f5;
            int n2 = 1;
            while (n2 < n) {
                fArray[n2] = fArray2[n2 - 1] - 20.0f;
                fArray2[n2] = fArray[n2] - f5;
                ++n2;
            }
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            int n3 = pdfReader.getNumberOfPages();
            System.out.println("There are " + n3 + " pages in the original file.");
            Document document = new Document(PageSize.A4);
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file2));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            int n4 = 0;
            int n5 = 0;
            while (n4 < n3) {
                float f6;
                Rectangle rectangle;
                float f7;
                float f8 = (f7 = (f2 - f) / (rectangle = pdfReader.getPageSizeWithRotation(++n4)).width()) < (f6 = (fArray[n5] - fArray2[n5]) / rectangle.height()) ? f7 : f6;
                float f9 = f7 == f8 ? 0.0f : (f2 - f - rectangle.width() * f8) / 2.0f;
                float f10 = f6 == f8 ? 0.0f : (fArray[n5] - fArray2[n5] - rectangle.height() * f8) / 2.0f;
                PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n4);
                int n6 = pdfReader.getPageRotation(n4);
                if (n6 == 90 || n6 == 270) {
                    pdfContentByte.addTemplate(pdfImportedPage, 0.0f, -f8, f8, 0.0f, f + f9, fArray2[n5] + f10 + rectangle.height() * f8);
                } else {
                    pdfContentByte.addTemplate(pdfImportedPage, f8, 0.0f, 0.0f, f8, f + f9, fArray2[n5] + f10);
                }
                pdfContentByte.setRGBColorStroke(192, 192, 192);
                pdfContentByte.rectangle(f3 - 5.0f, fArray2[n5] - 5.0f, f4 - f3 + 10.0f, fArray[n5] - fArray2[n5] + 10.0f);
                float f11 = fArray[n5] - 19.0f;
                while (f11 > fArray2[n5]) {
                    pdfContentByte.moveTo(f3, f11);
                    pdfContentByte.lineTo(f4, f11);
                    f11 -= 16.0f;
                }
                pdfContentByte.rectangle(f + f9, fArray2[n5] + f10, rectangle.width() * f8, rectangle.height() * f8);
                pdfContentByte.stroke();
                System.out.println("Processed page " + n4);
                if (++n5 != n) continue;
                n5 = 0;
                document.newPage();
            }
            document.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Handouts handouts = new Handouts();
        if (stringArray.length < 2) {
            System.err.println(handouts.getUsage());
        }
        handouts.setArguments(stringArray);
        handouts.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

