/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.arguments;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfReader;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.table.AbstractTableModel;

public class PageTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3954578372030475127L;
    int numberOfPages;
    PdfReader reader;
    DecimalFormat myFormatter = new DecimalFormat("00000");

    public PageTableModel(String string) {
        try {
            this.reader = new PdfReader(string);
            this.numberOfPages = this.reader.getNumberOfPages();
        }
        catch (IOException iOException) {
            throw new RuntimeException("File " + string + " can't be read!");
        }
    }

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        return this.numberOfPages;
    }

    public Object getValueAt(int n, int n2) {
        Rectangle rectangle = this.reader.getPageSizeWithRotation(n + 1);
        switch (n2) {
            case 0: {
                return this.myFormatter.format(n + 1);
            }
            case 1: {
                return new Float(rectangle.width());
            }
            case 2: {
                return new Float(rectangle.height());
            }
            case 3: {
                return new Float(rectangle.getRotation());
            }
        }
        return null;
    }

    public String getColumnName(int n) {
        String string = new Integer(n + 1).toString();
        switch (n) {
            case 0: {
                string = "<html>Pagenr<p>" + string + "</html>";
                break;
            }
            case 1: {
                string = "<html>Width<p>" + string + "</html>";
                break;
            }
            case 2: {
                string = "<html>Height<p>" + string + "</html>";
                break;
            }
            case 3: {
                string = "<html>Rotation<p>" + string + "</html>";
                break;
            }
            default: {
                string = "<html>-<p>" + string + "</html>";
            }
        }
        return string;
    }
}

