/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfPhrase
extends RtfElement {
    public static final byte[] PARAGRAPH_DEFAULTS = "\\pard".getBytes();
    public static final byte[] IN_TABLE = "\\intbl".getBytes();
    public static final byte[] LINE_SPACING = "\\sl".getBytes();
    protected ArrayList chunks = new ArrayList();
    private int lineLeading = 0;

    protected RtfPhrase(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    public RtfPhrase(RtfDocument rtfDocument, Phrase phrase) {
        super(rtfDocument);
        if (phrase == null) {
            return;
        }
        this.lineLeading = phrase.leadingDefined() ? (int)((double)phrase.leading() * 20.0) : 0;
        RtfFont rtfFont = new RtfFont(null, phrase.font());
        int n = 0;
        while (n < phrase.size()) {
            Element element = (Element)phrase.get(n);
            if (element instanceof Chunk) {
                ((Chunk)element).setFont(rtfFont.difference(((Chunk)element).font()));
            }
            try {
                this.chunks.add(rtfDocument.getMapper().mapElement(element));
            }
            catch (DocumentException documentException) {}
            ++n;
        }
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(PARAGRAPH_DEFAULTS);
            if (this.inTable) {
                byteArrayOutputStream.write(IN_TABLE);
            }
            if (this.lineLeading > 0) {
                byteArrayOutputStream.write(LINE_SPACING);
                byteArrayOutputStream.write(this.intToByteArray(this.lineLeading));
            }
            int n = 0;
            while (n < this.chunks.size()) {
                byteArrayOutputStream.write(((RtfBasicElement)this.chunks.get(n)).write());
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setInTable(boolean bl) {
        super.setInTable(bl);
        int n = 0;
        while (n < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(n)).setInTable(bl);
            ++n;
        }
    }

    public void setInHeader(boolean bl) {
        super.setInHeader(bl);
        int n = 0;
        while (n < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(n)).setInHeader(bl);
            ++n;
        }
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        super.setRtfDocument(rtfDocument);
        int n = 0;
        while (n < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(n)).setRtfDocument(this.document);
            ++n;
        }
    }
}

