/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.ListItem;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.text.RtfChunk;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfListItem
extends RtfParagraph {
    private RtfList parentList = null;
    private boolean containsInnerList = false;

    public RtfListItem(RtfDocument rtfDocument, ListItem listItem) {
        super(rtfDocument, listItem);
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n = 0;
            while (n < this.chunks.size()) {
                RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(n);
                if (rtfBasicElement instanceof RtfChunk) {
                    ((RtfChunk)rtfBasicElement).setSoftLineBreaks(true);
                } else if (rtfBasicElement instanceof RtfList) {
                    byteArrayOutputStream.write(RtfParagraph.PARAGRAPH);
                    this.containsInnerList = true;
                }
                byteArrayOutputStream.write(rtfBasicElement.write());
                if (rtfBasicElement instanceof RtfList) {
                    byteArrayOutputStream.write(this.parentList.writeListBeginning());
                    byteArrayOutputStream.write("\\tab".getBytes());
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeDefinition() {
        int n = 0;
        while (n < this.chunks.size()) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(n);
            if (rtfBasicElement instanceof RtfList) {
                return ((RtfList)rtfBasicElement).writeDefinition();
            }
            ++n;
        }
        return new byte[0];
    }

    public void inheritListSettings(int n, int n2) {
        int n3 = 0;
        while (n3 < this.chunks.size()) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(n3);
            if (rtfBasicElement instanceof RtfList) {
                ((RtfList)rtfBasicElement).setListNumber(n);
                ((RtfList)rtfBasicElement).setListLevel(n2);
                ((RtfList)rtfBasicElement).setParent(this.parentList);
            }
            ++n3;
        }
    }

    protected void correctIndentation() {
        int n = 0;
        while (n < this.chunks.size()) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(n);
            if (rtfBasicElement instanceof RtfList) {
                ((RtfList)rtfBasicElement).correctIndentation();
            }
            ++n;
        }
    }

    public void setParent(RtfList rtfList) {
        this.parentList = rtfList;
    }

    public boolean isContainsInnerList() {
        return this.containsInnerList;
    }
}

