/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.CFFFont;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class CFFFontSubset
extends CFFFont {
    static final String[] SubrsFunctions = new String[]{"RESERVED_0", "hstem", "RESERVED_2", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "RESERVED_9", "callsubr", "return", "escape", "RESERVED_13", "endchar", "RESERVED_15", "RESERVED_16", "RESERVED_17", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "shortint", "callgsubr", "vhcurveto", "hvcurveto"};
    static final String[] SubrsEscapeFuncs = new String[]{"RESERVED_0", "RESERVED_1", "RESERVED_2", "and", "or", "not", "RESERVED_6", "RESERVED_7", "RESERVED_8", "abs", "add", "sub", "div", "RESERVED_13", "neg", "eq", "RESERVED_16", "RESERVED_17", "drop", "RESERVED_19", "put", "get", "ifelse", "random", "mul", "RESERVED_25", "sqrt", "dup", "exch", "index", "roll", "RESERVED_31", "RESERVED_32", "RESERVED_33", "hflex", "flex", "hflex1", "flex1", "RESERVED_REST"};
    HashMap GlyphsUsed;
    ArrayList glyphsInList;
    HashMap FDArrayUsed = new HashMap();
    HashMap[] hSubrsUsed;
    ArrayList[] lSubrsUsed;
    HashMap hGSubrsUsed = new HashMap();
    ArrayList lGSubrsUsed = new ArrayList();
    HashMap hSubrsUsedNonCID = new HashMap();
    ArrayList lSubrsUsedNonCID = new ArrayList();
    byte[][] NewLSubrsIndex;
    byte[] NewSubrsIndexNonCID;
    byte[] NewGSubrsIndex;
    byte[] NewCharStringsIndex;
    int GBias = 0;
    LinkedList OutputList;
    int NumOfHints = 0;

    public CFFFontSubset(RandomAccessFileOrArray randomAccessFileOrArray, HashMap hashMap) {
        super(randomAccessFileOrArray);
        this.GlyphsUsed = hashMap;
        this.glyphsInList = new ArrayList(hashMap.keySet());
        int n = 0;
        while (n < this.fonts.length) {
            this.seek(this.fonts[n].charstringsOffset);
            this.fonts[n].nglyphs = this.getCard16();
            this.seek(this.stringIndexOffset);
            this.fonts[n].nstrings = this.getCard16() + standardStrings.length;
            this.fonts[n].charstringsOffsets = this.getIndex(this.fonts[n].charstringsOffset);
            if (this.fonts[n].fdselectOffset >= 0) {
                this.readFDSelect(n);
                this.BuildFDArrayUsed(n);
            }
            if (this.fonts[n].isCID) {
                this.ReadFDArray(n);
            }
            this.fonts[n].CharsetLength = this.CountCharset(this.fonts[n].charsetOffset, this.fonts[n].nglyphs);
            ++n;
        }
    }

    int CountCharset(int n, int n2) {
        int n3 = 0;
        this.seek(n);
        char c = this.getCard8();
        switch (c) {
            case '\u0000': {
                n3 = 1 + 2 * n2;
                break;
            }
            case '\u0001': {
                n3 = 1 + 3 * this.CountRange(n2, 1);
                break;
            }
            case '\u0002': {
                n3 = 1 + 4 * this.CountRange(n2, 2);
                break;
            }
        }
        return n3;
    }

    int CountRange(int n, int n2) {
        int n3 = 0;
        int n4 = 1;
        while (n4 < n) {
            ++n3;
            this.getCard16();
            char c = n2 == 1 ? this.getCard8() : this.getCard16();
            n4 += c + '\u0001';
        }
        return n3;
    }

    protected void readFDSelect(int n) {
        int n2 = this.fonts[n].nglyphs;
        int[] nArray = new int[n2];
        this.seek(this.fonts[n].fdselectOffset);
        this.fonts[n].FDSelectFormat = this.getCard8();
        switch (this.fonts[n].FDSelectFormat) {
            case 0: {
                int n3 = 0;
                while (n3 < n2) {
                    nArray[n3] = this.getCard8();
                    ++n3;
                }
                this.fonts[n].FDSelectLength = this.fonts[n].nglyphs + 1;
                break;
            }
            case 3: {
                int n4 = this.getCard16();
                int n5 = 0;
                char c = this.getCard16();
                int n6 = 0;
                while (n6 < n4) {
                    char c2 = this.getCard8();
                    char c3 = this.getCard16();
                    int n7 = c3 - c;
                    int n8 = 0;
                    while (n8 < n7) {
                        nArray[n5] = c2;
                        ++n5;
                        ++n8;
                    }
                    c = c3;
                    ++n6;
                }
                this.fonts[n].FDSelectLength = 3 + n4 * 3 + 2;
                break;
            }
        }
        this.fonts[n].FDSelect = nArray;
    }

    protected void BuildFDArrayUsed(int n) {
        int[] nArray = this.fonts[n].FDSelect;
        int n2 = 0;
        while (n2 < this.glyphsInList.size()) {
            int n3 = (Integer)this.glyphsInList.get(n2);
            int n4 = nArray[n3];
            this.FDArrayUsed.put(new Integer(n4), null);
            ++n2;
        }
    }

    protected void ReadFDArray(int n) {
        this.seek(this.fonts[n].fdarrayOffset);
        this.fonts[n].FDArrayCount = this.getCard16();
        this.fonts[n].FDArrayOffsize = this.getCard8();
        if (this.fonts[n].FDArrayOffsize < 4) {
            ++this.fonts[n].FDArrayOffsize;
        }
        this.fonts[n].FDArrayOffsets = this.getIndex(this.fonts[n].fdarrayOffset);
    }

    public byte[] Process(String string) throws IOException {
        byte[] byArray;
        int n;
        block9: {
            try {
                this.buf.reOpen();
                n = 0;
                while (n < this.fonts.length) {
                    if (string.equals(this.fonts[n].name)) break;
                    ++n;
                }
                if (n != this.fonts.length) break block9;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    this.buf.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                this.buf.close();
            }
            catch (Exception exception) {}
            return null;
        }
        if (this.gsubrIndexOffset >= 0) {
            this.GBias = this.CalcBias(this.gsubrIndexOffset, n);
        }
        this.BuildNewCharString(n);
        this.BuildNewLGSubrs(n);
        byte[] byArray2 = byArray = this.BuildNewFile(n);
        Object var4_4 = null;
        try {
            this.buf.close();
        }
        catch (Exception exception) {}
        return byArray2;
    }

    protected int CalcBias(int n, int n2) {
        this.seek(n);
        char c = this.getCard16();
        if (this.fonts[n2].CharstringType == 1) {
            return 0;
        }
        if (c < '\u04d8') {
            return 107;
        }
        if (c < '\u846c') {
            return 1131;
        }
        return 32768;
    }

    protected void BuildNewCharString(int n) throws IOException {
        this.NewCharStringsIndex = this.BuildNewIndex(this.fonts[n].charstringsOffsets, this.GlyphsUsed);
    }

    protected void BuildNewLGSubrs(int n) throws IOException {
        if (this.fonts[n].isCID) {
            this.hSubrsUsed = new HashMap[this.fonts[n].fdprivateOffsets.length];
            this.lSubrsUsed = new ArrayList[this.fonts[n].fdprivateOffsets.length];
            this.NewLSubrsIndex = new byte[this.fonts[n].fdprivateOffsets.length][];
            this.fonts[n].PrivateSubrsOffset = new int[this.fonts[n].fdprivateOffsets.length];
            this.fonts[n].PrivateSubrsOffsetsArray = new int[this.fonts[n].fdprivateOffsets.length][];
            ArrayList arrayList = new ArrayList(this.FDArrayUsed.keySet());
            int n2 = 0;
            while (n2 < arrayList.size()) {
                int n3 = (Integer)arrayList.get(n2);
                this.hSubrsUsed[n3] = new HashMap();
                this.lSubrsUsed[n3] = new ArrayList();
                this.BuildFDSubrsOffsets(n, n3);
                if (this.fonts[n].PrivateSubrsOffset[n3] >= 0) {
                    this.BuildSubrUsed(n, n3, this.fonts[n].PrivateSubrsOffset[n3], this.fonts[n].PrivateSubrsOffsetsArray[n3], this.hSubrsUsed[n3], this.lSubrsUsed[n3]);
                    this.NewLSubrsIndex[n3] = this.BuildNewIndex(this.fonts[n].PrivateSubrsOffsetsArray[n3], this.hSubrsUsed[n3]);
                }
                ++n2;
            }
        } else if (this.fonts[n].privateSubrs >= 0) {
            this.fonts[n].SubrsOffsets = this.getIndex(this.fonts[n].privateSubrs);
            this.BuildSubrUsed(n, -1, this.fonts[n].privateSubrs, this.fonts[n].SubrsOffsets, this.hSubrsUsedNonCID, this.lSubrsUsedNonCID);
        }
        this.BuildGSubrsUsed(n);
        if (this.fonts[n].privateSubrs >= 0) {
            this.NewSubrsIndexNonCID = this.BuildNewIndex(this.fonts[n].SubrsOffsets, this.hSubrsUsedNonCID);
        }
        this.NewGSubrsIndex = this.BuildNewIndex(this.gsubrOffsets, this.hGSubrsUsed);
    }

    protected void BuildFDSubrsOffsets(int n, int n2) {
        this.fonts[n].PrivateSubrsOffset[n2] = -1;
        this.seek(this.fonts[n].fdprivateOffsets[n2]);
        while (this.getPosition() < this.fonts[n].fdprivateOffsets[n2] + this.fonts[n].fdprivateLengths[n2]) {
            this.getDictItem();
            if (this.key != "Subrs") continue;
            this.fonts[n].PrivateSubrsOffset[n2] = (Integer)this.args[0] + this.fonts[n].fdprivateOffsets[n2];
        }
        if (this.fonts[n].PrivateSubrsOffset[n2] >= 0) {
            this.fonts[n].PrivateSubrsOffsetsArray[n2] = this.getIndex(this.fonts[n].PrivateSubrsOffset[n2]);
        }
    }

    protected void BuildSubrUsed(int n, int n2, int n3, int[] nArray, HashMap hashMap, ArrayList arrayList) {
        int n4;
        int n5;
        int n6;
        int n7 = this.CalcBias(n3, n);
        int n8 = 0;
        while (n8 < this.glyphsInList.size()) {
            n6 = (Integer)this.glyphsInList.get(n8);
            n5 = this.fonts[n].charstringsOffsets[n6];
            n4 = this.fonts[n].charstringsOffsets[n6 + 1];
            if (n2 >= 0) {
                this.EmptyStack();
                this.NumOfHints = 0;
                int n9 = this.fonts[n].FDSelect[n6];
                if (n9 == n2) {
                    this.ReadASubr(n5, n4, this.GBias, n7, hashMap, arrayList, nArray);
                }
            } else {
                this.ReadASubr(n5, n4, this.GBias, n7, hashMap, arrayList, nArray);
            }
            ++n8;
        }
        n8 = 0;
        while (n8 < arrayList.size()) {
            n6 = (Integer)arrayList.get(n8);
            if (n6 < nArray.length - 1 && n6 >= 0) {
                n5 = nArray[n6];
                n4 = nArray[n6 + 1];
                this.ReadASubr(n5, n4, this.GBias, n7, hashMap, arrayList, nArray);
            }
            ++n8;
        }
    }

    protected void BuildGSubrsUsed(int n) {
        int n2 = 0;
        int n3 = 0;
        if (this.fonts[n].privateSubrs >= 0) {
            n2 = this.CalcBias(this.fonts[n].privateSubrs, n);
            n3 = this.lSubrsUsedNonCID.size();
        }
        int n4 = 0;
        while (n4 < this.lGSubrsUsed.size()) {
            int n5 = (Integer)this.lGSubrsUsed.get(n4);
            if (n5 < this.gsubrOffsets.length - 1 && n5 >= 0) {
                int n6 = this.gsubrOffsets[n5];
                int n7 = this.gsubrOffsets[n5 + 1];
                if (this.fonts[n].isCID) {
                    this.ReadASubr(n6, n7, this.GBias, 0, this.hGSubrsUsed, this.lGSubrsUsed, null);
                } else {
                    this.ReadASubr(n6, n7, this.GBias, n2, this.hSubrsUsedNonCID, this.lSubrsUsedNonCID, this.fonts[n].SubrsOffsets);
                    if (n3 < this.lSubrsUsedNonCID.size()) {
                        int n8 = n3;
                        while (n8 < this.lSubrsUsedNonCID.size()) {
                            int n9 = (Integer)this.lSubrsUsedNonCID.get(n8);
                            if (n9 < this.fonts[n].SubrsOffsets.length - 1 && n9 >= 0) {
                                int n10 = this.fonts[n].SubrsOffsets[n9];
                                int n11 = this.fonts[n].SubrsOffsets[n9 + 1];
                                this.ReadASubr(n10, n11, this.GBias, n2, this.hSubrsUsedNonCID, this.lSubrsUsedNonCID, this.fonts[n].SubrsOffsets);
                            }
                            ++n8;
                        }
                        n3 = this.lSubrsUsedNonCID.size();
                    }
                }
            }
            ++n4;
        }
    }

    protected void ReadASubr(int n, int n2, int n3, int n4, HashMap hashMap, ArrayList arrayList, int[] nArray) {
        this.EmptyStack();
        this.NumOfHints = 0;
        this.seek(n);
        while (this.getPosition() < n2) {
            int n5;
            this.ReadCommand();
            int n6 = this.getPosition();
            Object object = null;
            if (this.arg_count > 0) {
                object = this.args[this.arg_count - 1];
            }
            int n7 = this.arg_count;
            this.HandelStack();
            if (this.key == "callsubr") {
                if (n7 <= 0) continue;
                n5 = (Integer)object + n4;
                if (!hashMap.containsKey(new Integer(n5))) {
                    hashMap.put(new Integer(n5), null);
                    arrayList.add(new Integer(n5));
                }
                this.CalcHints(nArray[n5], nArray[n5 + 1], n4, n3, nArray);
                this.seek(n6);
                continue;
            }
            if (this.key == "callgsubr") {
                if (n7 <= 0) continue;
                n5 = (Integer)object + n3;
                if (!this.hGSubrsUsed.containsKey(new Integer(n5))) {
                    this.hGSubrsUsed.put(new Integer(n5), null);
                    this.lGSubrsUsed.add(new Integer(n5));
                }
                this.CalcHints(this.gsubrOffsets[n5], this.gsubrOffsets[n5 + 1], n4, n3, nArray);
                this.seek(n6);
                continue;
            }
            if (this.key == "hstem" || this.key == "vstem" || this.key == "hstemhm" || this.key == "vstemhm") {
                this.NumOfHints += n7 / 2;
                continue;
            }
            if (this.key != "hintmask" && this.key != "cntrmask") continue;
            n5 = this.NumOfHints / 8;
            if (this.NumOfHints % 8 != 0 || n5 == 0) {
                ++n5;
            }
            int n8 = 0;
            while (n8 < n5) {
                this.getCard8();
                ++n8;
            }
        }
    }

    protected void HandelStack() {
        int n = this.StackOpp();
        if (n < 2) {
            if (n == 1) {
                this.PushStack();
            } else {
                n *= -1;
                int n2 = 0;
                while (n2 < n) {
                    this.PopStack();
                    ++n2;
                }
            }
        } else {
            this.EmptyStack();
        }
    }

    protected int StackOpp() {
        if (this.key == "ifelse") {
            return -3;
        }
        if (this.key == "roll" || this.key == "put") {
            return -2;
        }
        if (this.key == "callsubr" || this.key == "callgsubr" || this.key == "add" || this.key == "sub" || this.key == "div" || this.key == "mul" || this.key == "drop" || this.key == "and" || this.key == "or" || this.key == "eq") {
            return -1;
        }
        if (this.key == "abs" || this.key == "neg" || this.key == "sqrt" || this.key == "exch" || this.key == "index" || this.key == "get" || this.key == "not" || this.key == "return") {
            return 0;
        }
        if (this.key == "random" || this.key == "dup") {
            return 1;
        }
        return 2;
    }

    protected void EmptyStack() {
        int n = 0;
        while (n < this.arg_count) {
            this.args[n] = null;
            ++n;
        }
        this.arg_count = 0;
    }

    protected void PopStack() {
        if (this.arg_count > 0) {
            this.args[this.arg_count - 1] = null;
            --this.arg_count;
        }
    }

    protected void PushStack() {
        ++this.arg_count;
    }

    protected void ReadCommand() {
        this.key = null;
        boolean bl = false;
        while (!bl) {
            char c;
            int n;
            char c2 = this.getCard8();
            if (c2 == '\u001c') {
                n = this.getCard8();
                c = this.getCard8();
                this.args[this.arg_count] = new Integer(n << 8 | c);
                ++this.arg_count;
                continue;
            }
            if (c2 >= ' ' && c2 <= '\u00f6') {
                this.args[this.arg_count] = new Integer(c2 - 139);
                ++this.arg_count;
                continue;
            }
            if (c2 >= '\u00f7' && c2 <= '\u00fa') {
                n = this.getCard8();
                this.args[this.arg_count] = new Integer((c2 - 247) * 256 + n + 108);
                ++this.arg_count;
                continue;
            }
            if (c2 >= '\u00fb' && c2 <= '\u00fe') {
                n = this.getCard8();
                this.args[this.arg_count] = new Integer(-(c2 - 251) * 256 - n - 108);
                ++this.arg_count;
                continue;
            }
            if (c2 == '\u00ff') {
                n = this.getCard8();
                c = this.getCard8();
                char c3 = this.getCard8();
                char c4 = this.getCard8();
                this.args[this.arg_count] = new Integer(n << 24 | c << 16 | c3 << 8 | c4);
                ++this.arg_count;
                continue;
            }
            if (c2 > '\u001f' || c2 == '\u001c') continue;
            bl = true;
            if (c2 == '\f') {
                n = this.getCard8();
                if (n > SubrsEscapeFuncs.length - 1) {
                    n = SubrsEscapeFuncs.length - 1;
                }
                this.key = SubrsEscapeFuncs[n];
                continue;
            }
            this.key = SubrsFunctions[c2];
        }
    }

    protected int CalcHints(int n, int n2, int n3, int n4, int[] nArray) {
        this.seek(n);
        while (this.getPosition() < n2) {
            int n5;
            this.ReadCommand();
            int n6 = this.getPosition();
            Object object = null;
            if (this.arg_count > 0) {
                object = this.args[this.arg_count - 1];
            }
            int n7 = this.arg_count;
            this.HandelStack();
            if (this.key == "callsubr") {
                if (n7 <= 0) continue;
                n5 = (Integer)object + n3;
                this.CalcHints(nArray[n5], nArray[n5 + 1], n3, n4, nArray);
                this.seek(n6);
                continue;
            }
            if (this.key == "callgsubr") {
                if (n7 <= 0) continue;
                n5 = (Integer)object + n4;
                this.CalcHints(this.gsubrOffsets[n5], this.gsubrOffsets[n5 + 1], n3, n4, nArray);
                this.seek(n6);
                continue;
            }
            if (this.key == "hstem" || this.key == "vstem" || this.key == "hstemhm" || this.key == "vstemhm") {
                this.NumOfHints += n7 / 2;
                continue;
            }
            if (this.key != "hintmask" && this.key != "cntrmask") continue;
            n5 = this.NumOfHints / 8;
            if (this.NumOfHints % 8 != 0 || n5 == 0) {
                ++n5;
            }
            int n8 = 0;
            while (n8 < n5) {
                this.getCard8();
                ++n8;
            }
        }
        return this.NumOfHints;
    }

    protected byte[] BuildNewIndex(int[] nArray, HashMap hashMap) throws IOException {
        int n = 0;
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n2] = n;
            if (hashMap.containsKey(new Integer(n2))) {
                n += nArray[n2 + 1] - nArray[n2];
            }
            ++n2;
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n3 < nArray.length - 1) {
            int n4 = nArray2[n3];
            int n5 = nArray2[n3 + 1];
            if (n4 != n5) {
                this.buf.seek(nArray[n3]);
                this.buf.readFully(byArray, n4, n5 - n4);
            }
            ++n3;
        }
        return this.AssembleIndex(nArray2, byArray);
    }

    protected byte[] AssembleIndex(int[] nArray, byte[] byArray) {
        char c = (char)(nArray.length - 1);
        int n = nArray[nArray.length - 1];
        int n2 = n <= 255 ? 1 : (n <= 65535 ? 2 : (n <= 0xFFFFFF ? 3 : 4));
        byte[] byArray2 = new byte[3 + n2 * (c + '\u0001') + byArray.length];
        int n3 = 0;
        byArray2[n3++] = (byte)(c >>> 8 & 0xFF);
        byArray2[n3++] = (byte)(c >>> 0 & 0xFF);
        byArray2[n3++] = n2;
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = nArray[n4] - nArray[0] + 1;
            switch (n2) {
                case 4: {
                    byArray2[n3++] = (byte)(n5 >>> 24 & 0xFF);
                }
                case 3: {
                    byArray2[n3++] = (byte)(n5 >>> 16 & 0xFF);
                }
                case 2: {
                    byArray2[n3++] = (byte)(n5 >>> 8 & 0xFF);
                }
                case 1: {
                    byArray2[n3++] = (byte)(n5 >>> 0 & 0xFF);
                }
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < byArray.length) {
            byArray2[n3++] = byArray[n4];
            ++n4;
        }
        return byArray2;
    }

    protected byte[] BuildNewFile(int n) throws IOException {
        CFFFont.Item item;
        this.OutputList = new LinkedList();
        this.CopyHeader();
        this.BuildIndexHeader(1, 1, 1);
        this.OutputList.addLast(new CFFFont.UInt8Item((char)(1 + this.fonts[n].name.length())));
        this.OutputList.addLast(new CFFFont.StringItem(this.fonts[n].name));
        this.BuildIndexHeader(1, 2, 1);
        CFFFont.IndexOffsetItem indexOffsetItem = new CFFFont.IndexOffsetItem(2);
        this.OutputList.addLast(indexOffsetItem);
        CFFFont.IndexBaseItem indexBaseItem = new CFFFont.IndexBaseItem();
        this.OutputList.addLast(indexBaseItem);
        CFFFont.DictOffsetItem dictOffsetItem = new CFFFont.DictOffsetItem();
        CFFFont.DictOffsetItem dictOffsetItem2 = new CFFFont.DictOffsetItem();
        CFFFont.DictOffsetItem dictOffsetItem3 = new CFFFont.DictOffsetItem();
        CFFFont.DictOffsetItem dictOffsetItem4 = new CFFFont.DictOffsetItem();
        CFFFont.DictOffsetItem dictOffsetItem5 = new CFFFont.DictOffsetItem();
        if (!this.fonts[n].isCID) {
            this.OutputList.addLast(new CFFFont.DictNumberItem(this.fonts[n].nstrings));
            this.OutputList.addLast(new CFFFont.DictNumberItem(this.fonts[n].nstrings + 1));
            this.OutputList.addLast(new CFFFont.DictNumberItem(0));
            this.OutputList.addLast(new CFFFont.UInt8Item('\f'));
            this.OutputList.addLast(new CFFFont.UInt8Item('\u001e'));
            this.OutputList.addLast(new CFFFont.DictNumberItem(this.fonts[n].nglyphs));
            this.OutputList.addLast(new CFFFont.UInt8Item('\f'));
            this.OutputList.addLast(new CFFFont.UInt8Item('\"'));
        }
        this.seek(this.topdictOffsets[n]);
        while (this.getPosition() < this.topdictOffsets[n + 1]) {
            int n2 = this.getPosition();
            this.getDictItem();
            int n3 = this.getPosition();
            if (this.key == "Encoding" || this.key == "Private" || this.key == "FDSelect" || this.key == "FDArray" || this.key == "charset" || this.key == "CharStrings") continue;
            this.OutputList.add(new CFFFont.RangeItem(this.buf, n2, n3 - n2));
        }
        this.CreateKeys(dictOffsetItem3, dictOffsetItem4, dictOffsetItem, dictOffsetItem2);
        this.OutputList.addLast(new CFFFont.IndexMarkerItem(indexOffsetItem, indexBaseItem));
        if (this.fonts[n].isCID) {
            this.OutputList.addLast(this.getEntireIndexRange(this.stringIndexOffset));
        } else {
            this.CreateNewStringIndex(n);
        }
        this.OutputList.addLast(new CFFFont.RangeItem(new RandomAccessFileOrArray(this.NewGSubrsIndex), 0, this.NewGSubrsIndex.length));
        if (this.fonts[n].isCID) {
            this.OutputList.addLast(new CFFFont.MarkerItem(dictOffsetItem4));
            if (this.fonts[n].fdselectOffset >= 0) {
                this.OutputList.addLast(new CFFFont.RangeItem(this.buf, this.fonts[n].fdselectOffset, this.fonts[n].FDSelectLength));
            } else {
                this.CreateFDSelect(dictOffsetItem4, this.fonts[n].nglyphs);
            }
            this.OutputList.addLast(new CFFFont.MarkerItem(dictOffsetItem));
            this.OutputList.addLast(new CFFFont.RangeItem(this.buf, this.fonts[n].charsetOffset, this.fonts[n].CharsetLength));
            if (this.fonts[n].fdarrayOffset >= 0) {
                this.OutputList.addLast(new CFFFont.MarkerItem(dictOffsetItem3));
                this.Reconstruct(n);
            } else {
                this.CreateFDArray(dictOffsetItem3, dictOffsetItem5, n);
            }
        } else {
            this.CreateFDSelect(dictOffsetItem4, this.fonts[n].nglyphs);
            this.CreateCharset(dictOffsetItem, this.fonts[n].nglyphs);
            this.CreateFDArray(dictOffsetItem3, dictOffsetItem5, n);
        }
        if (this.fonts[n].privateOffset >= 0) {
            CFFFont.IndexBaseItem indexBaseItem2 = new CFFFont.IndexBaseItem();
            this.OutputList.addLast(indexBaseItem2);
            this.OutputList.addLast(new CFFFont.MarkerItem(dictOffsetItem5));
            CFFFont.DictOffsetItem dictOffsetItem6 = new CFFFont.DictOffsetItem();
            this.CreateNonCIDPrivate(n, dictOffsetItem6);
            this.CreateNonCIDSubrs(n, indexBaseItem2, dictOffsetItem6);
        }
        this.OutputList.addLast(new CFFFont.MarkerItem(dictOffsetItem2));
        this.OutputList.addLast(new CFFFont.RangeItem(new RandomAccessFileOrArray(this.NewCharStringsIndex), 0, this.NewCharStringsIndex.length));
        int[] nArray = new int[]{0};
        Iterator iterator = this.OutputList.iterator();
        while (iterator.hasNext()) {
            item = (CFFFont.Item)iterator.next();
            item.increment(nArray);
        }
        iterator = this.OutputList.iterator();
        while (iterator.hasNext()) {
            item = (CFFFont.Item)iterator.next();
            item.xref();
        }
        int n4 = nArray[0];
        byte[] byArray = new byte[n4];
        iterator = this.OutputList.iterator();
        while (iterator.hasNext()) {
            CFFFont.Item item2 = (CFFFont.Item)iterator.next();
            item2.emit(byArray);
        }
        return byArray;
    }

    protected void CopyHeader() {
        this.seek(0);
        this.getCard8();
        this.getCard8();
        char c = this.getCard8();
        this.getCard8();
        this.nextIndexOffset = c;
        this.OutputList.addLast(new CFFFont.RangeItem(this.buf, 0, c));
    }

    protected void BuildIndexHeader(int n, int n2, int n3) {
        this.OutputList.addLast(new CFFFont.UInt16Item((char)n));
        this.OutputList.addLast(new CFFFont.UInt8Item((char)n2));
        switch (n2) {
            case 1: {
                this.OutputList.addLast(new CFFFont.UInt8Item((char)n3));
                break;
            }
            case 2: {
                this.OutputList.addLast(new CFFFont.UInt16Item((char)n3));
                break;
            }
            case 3: {
                this.OutputList.addLast(new CFFFont.UInt24Item((char)n3));
                break;
            }
            case 4: {
                this.OutputList.addLast(new CFFFont.UInt32Item((char)n3));
                break;
            }
        }
    }

    protected void CreateKeys(CFFFont.OffsetItem offsetItem, CFFFont.OffsetItem offsetItem2, CFFFont.OffsetItem offsetItem3, CFFFont.OffsetItem offsetItem4) {
        this.OutputList.addLast(offsetItem);
        this.OutputList.addLast(new CFFFont.UInt8Item('\f'));
        this.OutputList.addLast(new CFFFont.UInt8Item('$'));
        this.OutputList.addLast(offsetItem2);
        this.OutputList.addLast(new CFFFont.UInt8Item('\f'));
        this.OutputList.addLast(new CFFFont.UInt8Item('%'));
        this.OutputList.addLast(offsetItem3);
        this.OutputList.addLast(new CFFFont.UInt8Item('\u000f'));
        this.OutputList.addLast(offsetItem4);
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0011'));
    }

    protected void CreateNewStringIndex(int n) {
        String string = String.valueOf(this.fonts[n].name) + "-OneRange";
        if (string.length() > 127) {
            string = string.substring(0, 127);
        }
        String string2 = "AdobeIdentity" + string;
        int n2 = this.stringOffsets[this.stringOffsets.length - 1] - this.stringOffsets[0];
        int n3 = this.stringOffsets[0] - 1;
        int n4 = n2 + string2.length() <= 255 ? 1 : (n2 + string2.length() <= 65535 ? 2 : (n2 + string2.length() <= 0xFFFFFF ? 3 : 4));
        this.OutputList.addLast(new CFFFont.UInt16Item((char)(this.stringOffsets.length - 1 + 3)));
        this.OutputList.addLast(new CFFFont.UInt8Item((char)n4));
        int n5 = 0;
        while (n5 < this.stringOffsets.length) {
            this.OutputList.addLast(new CFFFont.IndexOffsetItem(n4, this.stringOffsets[n5] - n3));
            ++n5;
        }
        n5 = this.stringOffsets[this.stringOffsets.length - 1] - n3;
        this.OutputList.addLast(new CFFFont.IndexOffsetItem(n4, n5 += "Adobe".length()));
        this.OutputList.addLast(new CFFFont.IndexOffsetItem(n4, n5 += "Identity".length()));
        this.OutputList.addLast(new CFFFont.IndexOffsetItem(n4, n5 += string.length()));
        this.OutputList.addLast(new CFFFont.RangeItem(this.buf, this.stringOffsets[0], n2));
        this.OutputList.addLast(new CFFFont.StringItem(string2));
    }

    protected void CreateFDSelect(CFFFont.OffsetItem offsetItem, int n) {
        this.OutputList.addLast(new CFFFont.MarkerItem(offsetItem));
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0003'));
        this.OutputList.addLast(new CFFFont.UInt16Item('\u0001'));
        this.OutputList.addLast(new CFFFont.UInt16Item('\u0000'));
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0000'));
        this.OutputList.addLast(new CFFFont.UInt16Item((char)n));
    }

    protected void CreateCharset(CFFFont.OffsetItem offsetItem, int n) {
        this.OutputList.addLast(new CFFFont.MarkerItem(offsetItem));
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0002'));
        this.OutputList.addLast(new CFFFont.UInt16Item('\u0001'));
        this.OutputList.addLast(new CFFFont.UInt16Item((char)(n - 1)));
    }

    protected void CreateFDArray(CFFFont.OffsetItem offsetItem, CFFFont.OffsetItem offsetItem2, int n) {
        this.OutputList.addLast(new CFFFont.MarkerItem(offsetItem));
        this.BuildIndexHeader(1, 1, 1);
        CFFFont.IndexOffsetItem indexOffsetItem = new CFFFont.IndexOffsetItem(1);
        this.OutputList.addLast(indexOffsetItem);
        CFFFont.IndexBaseItem indexBaseItem = new CFFFont.IndexBaseItem();
        this.OutputList.addLast(indexBaseItem);
        int n2 = this.fonts[n].privateLength;
        int n3 = this.CalcSubrOffsetSize(this.fonts[n].privateOffset, this.fonts[n].privateLength);
        if (n3 != 0) {
            n2 += 5 - n3;
        }
        this.OutputList.addLast(new CFFFont.DictNumberItem(n2));
        this.OutputList.addLast(offsetItem2);
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0012'));
        this.OutputList.addLast(new CFFFont.IndexMarkerItem(indexOffsetItem, indexBaseItem));
    }

    void Reconstruct(int n) throws IOException {
        CFFFont.OffsetItem[] offsetItemArray = new CFFFont.DictOffsetItem[this.fonts[n].FDArrayOffsets.length - 1];
        CFFFont.IndexBaseItem[] indexBaseItemArray = new CFFFont.IndexBaseItem[this.fonts[n].fdprivateOffsets.length];
        CFFFont.OffsetItem[] offsetItemArray2 = new CFFFont.DictOffsetItem[this.fonts[n].fdprivateOffsets.length];
        this.ReconstructFDArray(n, offsetItemArray);
        this.ReconstructPrivateDict(n, offsetItemArray, indexBaseItemArray, offsetItemArray2);
        this.ReconstructPrivateSubrs(n, indexBaseItemArray, offsetItemArray2);
    }

    void ReconstructFDArray(int n, CFFFont.OffsetItem[] offsetItemArray) throws IOException {
        this.BuildIndexHeader(this.fonts[n].FDArrayCount, this.fonts[n].FDArrayOffsize, 1);
        CFFFont.IndexOffsetItem[] indexOffsetItemArray = new CFFFont.IndexOffsetItem[this.fonts[n].FDArrayOffsets.length - 1];
        int n2 = 0;
        while (n2 < this.fonts[n].FDArrayOffsets.length - 1) {
            indexOffsetItemArray[n2] = new CFFFont.IndexOffsetItem(this.fonts[n].FDArrayOffsize);
            this.OutputList.addLast(indexOffsetItemArray[n2]);
            ++n2;
        }
        CFFFont.IndexBaseItem indexBaseItem = new CFFFont.IndexBaseItem();
        this.OutputList.addLast(indexBaseItem);
        int n3 = 0;
        while (n3 < this.fonts[n].FDArrayOffsets.length - 1) {
            if (this.FDArrayUsed.containsKey(new Integer(n3))) {
                this.seek(this.fonts[n].FDArrayOffsets[n3]);
                while (this.getPosition() < this.fonts[n].FDArrayOffsets[n3 + 1]) {
                    int n4 = this.getPosition();
                    this.getDictItem();
                    int n5 = this.getPosition();
                    if (this.key == "Private") {
                        int n6 = (Integer)this.args[0];
                        int n7 = this.CalcSubrOffsetSize(this.fonts[n].fdprivateOffsets[n3], this.fonts[n].fdprivateLengths[n3]);
                        if (n7 != 0) {
                            n6 += 5 - n7;
                        }
                        this.OutputList.addLast(new CFFFont.DictNumberItem(n6));
                        offsetItemArray[n3] = new CFFFont.DictOffsetItem();
                        this.OutputList.addLast(offsetItemArray[n3]);
                        this.OutputList.addLast(new CFFFont.UInt8Item('\u0012'));
                        this.seek(n5);
                        continue;
                    }
                    this.OutputList.addLast(new CFFFont.RangeItem(this.buf, n4, n5 - n4));
                }
            }
            this.OutputList.addLast(new CFFFont.IndexMarkerItem(indexOffsetItemArray[n3], indexBaseItem));
            ++n3;
        }
    }

    void ReconstructPrivateDict(int n, CFFFont.OffsetItem[] offsetItemArray, CFFFont.IndexBaseItem[] indexBaseItemArray, CFFFont.OffsetItem[] offsetItemArray2) throws IOException {
        int n2 = 0;
        while (n2 < this.fonts[n].fdprivateOffsets.length) {
            if (this.FDArrayUsed.containsKey(new Integer(n2))) {
                this.OutputList.addLast(new CFFFont.MarkerItem(offsetItemArray[n2]));
                indexBaseItemArray[n2] = new CFFFont.IndexBaseItem();
                this.OutputList.addLast(indexBaseItemArray[n2]);
                this.seek(this.fonts[n].fdprivateOffsets[n2]);
                while (this.getPosition() < this.fonts[n].fdprivateOffsets[n2] + this.fonts[n].fdprivateLengths[n2]) {
                    int n3 = this.getPosition();
                    this.getDictItem();
                    int n4 = this.getPosition();
                    if (this.key == "Subrs") {
                        offsetItemArray2[n2] = new CFFFont.DictOffsetItem();
                        this.OutputList.addLast(offsetItemArray2[n2]);
                        this.OutputList.addLast(new CFFFont.UInt8Item('\u0013'));
                        continue;
                    }
                    this.OutputList.addLast(new CFFFont.RangeItem(this.buf, n3, n4 - n3));
                }
            }
            ++n2;
        }
    }

    void ReconstructPrivateSubrs(int n, CFFFont.IndexBaseItem[] indexBaseItemArray, CFFFont.OffsetItem[] offsetItemArray) throws IOException {
        int n2 = 0;
        while (n2 < this.fonts[n].fdprivateLengths.length) {
            if (offsetItemArray[n2] != null && this.fonts[n].PrivateSubrsOffset[n2] >= 0) {
                this.OutputList.addLast(new CFFFont.SubrMarkerItem(offsetItemArray[n2], indexBaseItemArray[n2]));
                this.OutputList.addLast(new CFFFont.RangeItem(new RandomAccessFileOrArray(this.NewLSubrsIndex[n2]), 0, this.NewLSubrsIndex[n2].length));
            }
            ++n2;
        }
    }

    int CalcSubrOffsetSize(int n, int n2) {
        int n3 = 0;
        this.seek(n);
        while (this.getPosition() < n + n2) {
            int n4 = this.getPosition();
            this.getDictItem();
            int n5 = this.getPosition();
            if (this.key != "Subrs") continue;
            n3 = n5 - n4 - 1;
        }
        return n3;
    }

    protected int countEntireIndexRange(int n) {
        this.seek(n);
        char c = this.getCard16();
        if (c == '\u0000') {
            return 2;
        }
        char c2 = this.getCard8();
        this.seek(n + 2 + 1 + c * c2);
        int n2 = this.getOffset(c2) - 1;
        return 3 + (c + '\u0001') * c2 + n2;
    }

    void CreateNonCIDPrivate(int n, CFFFont.OffsetItem offsetItem) {
        this.seek(this.fonts[n].privateOffset);
        while (this.getPosition() < this.fonts[n].privateOffset + this.fonts[n].privateLength) {
            int n2 = this.getPosition();
            this.getDictItem();
            int n3 = this.getPosition();
            if (this.key == "Subrs") {
                this.OutputList.addLast(offsetItem);
                this.OutputList.addLast(new CFFFont.UInt8Item('\u0013'));
                continue;
            }
            this.OutputList.addLast(new CFFFont.RangeItem(this.buf, n2, n3 - n2));
        }
    }

    void CreateNonCIDSubrs(int n, CFFFont.IndexBaseItem indexBaseItem, CFFFont.OffsetItem offsetItem) throws IOException {
        this.OutputList.addLast(new CFFFont.SubrMarkerItem(offsetItem, indexBaseItem));
        this.OutputList.addLast(new CFFFont.RangeItem(new RandomAccessFileOrArray(this.NewSubrsIndexNonCID), 0, this.NewSubrsIndexNonCID.length));
    }
}

