/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;

class JoinVoicesHelper {
    private TGFactory factory;
    private TGMeasure measure;

    public JoinVoicesHelper(TGFactory tGFactory, TGMeasure tGMeasure) {
        this.factory = tGFactory;
        this.measure = tGMeasure;
    }

    public void process() {
        this.orderBeats();
        this.joinBeats();
    }

    public void joinBeats() {
        TGBeat tGBeat = null;
        boolean bl = true;
        long l = this.measure.getStart();
        long l2 = l + this.measure.getLength();
        for (int i = 0; i < this.measure.countBeats(); ++i) {
            TGBeat tGBeat2 = this.measure.getBeat(i);
            long l3 = tGBeat2.getStart();
            long l4 = tGBeat2.getDuration().getTime();
            if (tGBeat != null) {
                long l5 = tGBeat.getStart();
                long l6 = tGBeat.getDuration().getTime();
                if (l5 == l3) {
                    for (int j = 0; j < tGBeat2.countNotes(); ++j) {
                        TGNote tGNote = tGBeat2.getNote(j);
                        tGBeat.addNote(tGNote);
                    }
                    if (!tGBeat.isChordBeat() && tGBeat2.isChordBeat()) {
                        tGBeat.setChord(tGBeat2.getChord());
                    }
                    if (!tGBeat.isTextBeat() && tGBeat2.isTextBeat()) {
                        tGBeat.setText(tGBeat2.getText());
                    }
                    if (l4 > l6 && l3 + l4 <= l2) {
                        tGBeat2.getDuration().copy(tGBeat.getDuration());
                    }
                    this.measure.removeBeat(tGBeat2);
                    bl = false;
                    break;
                }
                if (l5 < l3 && l5 + l6 > l3) {
                    if (tGBeat2.isRestBeat()) {
                        this.measure.removeBeat(tGBeat2);
                        bl = false;
                        break;
                    }
                    TGDuration tGDuration = TGDuration.fromTime((TGFactory)this.factory, (long)(l3 - l5));
                    tGDuration.copy(tGBeat.getDuration());
                }
            }
            if (l3 + l4 > l2) {
                if (tGBeat2.isRestBeat()) {
                    this.measure.removeBeat(tGBeat2);
                    bl = false;
                    break;
                }
                TGDuration tGDuration = TGDuration.fromTime((TGFactory)this.factory, (long)(l2 - l3));
                tGDuration.copy(tGBeat2.getDuration());
            }
            tGBeat = tGBeat2;
        }
        if (!bl) {
            this.joinBeats();
        }
    }

    public void orderBeats() {
        for (int i = 0; i < this.measure.countBeats(); ++i) {
            TGBeat tGBeat = null;
            for (int j = i; j < this.measure.countBeats(); ++j) {
                TGBeat tGBeat2 = this.measure.getBeat(j);
                if (tGBeat != null && tGBeat2.getStart() >= tGBeat.getStart()) continue;
                tGBeat = tGBeat2;
            }
            this.measure.moveBeat(i, tGBeat);
        }
    }
}

