/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.TiffImage;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.ImageFilter;
import com.lowagie.tools.arguments.OptionArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Tiff2Pdf
extends AbstractTool {
    static {
        Tiff2Pdf.addVersion("$Id: Tiff2Pdf.java,v 1.9 2005/11/29 21:05:02 blowagie Exp $");
    }

    public Tiff2Pdf() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to convert", false, new ImageFilter(false, false, false, false, false, true)));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
        OptionArgument optionArgument = new OptionArgument(this, "pagesize", "Pagesize");
        optionArgument.addOption("A4", "A4");
        optionArgument.addOption("Letter", "LETTER");
        optionArgument.addOption("Original format", "ORIGINAL");
        this.arguments.add(optionArgument);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Tiff2Pdf", true, false, true);
        this.internalFrame.setSize(550, 250);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Tiff2Pdf OPENED ===");
    }

    public void execute() {
        try {
            Object object;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            RandomAccessFileOrArray randomAccessFileOrArray = new RandomAccessFileOrArray(file.getAbsolutePath());
            int n = TiffImage.getNumberOfPages(randomAccessFileOrArray);
            boolean bl = false;
            Document document = new Document(PageSize.A4);
            if ("ORIGINAL".equals(this.getValue("pagesize"))) {
                object = TiffImage.getTiffImage(randomAccessFileOrArray, 1);
                document.setPageSize(new Rectangle(((Image)object).scaledWidth(), ((Image)object).scaledHeight()));
                bl = true;
            } else if ("LETTER".equals(this.getValue("pagesize"))) {
                document.setPageSize(PageSize.LETTER);
            }
            object = PdfWriter.getInstance(document, new FileOutputStream(file2));
            document.open();
            PdfContentByte pdfContentByte = ((PdfWriter)object).getDirectContent();
            int n2 = 0;
            while (n2 < n) {
                Image image = TiffImage.getTiffImage(randomAccessFileOrArray, n2 + 1);
                if (image != null) {
                    if (bl) {
                        document.setPageSize(new Rectangle(image.scaledWidth(), image.scaledHeight()));
                        document.newPage();
                        image.setAbsolutePosition(0.0f, 0.0f);
                    } else {
                        if (image.scaledWidth() > 500.0f || image.scaledHeight() > 700.0f) {
                            image.scaleToFit(500.0f, 700.0f);
                        }
                        image.setAbsolutePosition(20.0f, 20.0f);
                        document.newPage();
                        document.add(new Paragraph(file + " - page " + (n2 + 1)));
                    }
                    pdfContentByte.addImage(image);
                    System.out.println("Finished page " + (n2 + 1));
                }
                ++n2;
            }
            randomAccessFileOrArray.close();
            document.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Tiff2Pdf tiff2Pdf = new Tiff2Pdf();
        if (stringArray.length < 2) {
            System.err.println(tiff2Pdf.getUsage());
        }
        tiff2Pdf.setArguments(stringArray);
        tiff2Pdf.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

