/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.LabelAccessory;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class Burst
extends AbstractTool {
    static {
        Burst.addVersion("$Id: Burst.java,v 1.9 2006/08/21 13:32:23 blowagie Exp $");
    }

    public Burst() {
        FileArgument fileArgument = new FileArgument(this, "srcfile", "The file you want to split", false, new PdfFilter());
        fileArgument.setLabel(new LabelAccessory());
        this.arguments.add(fileArgument);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Burst", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Burst OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            File file2 = file.getParentFile();
            String string = file.getName();
            string = string.substring(0, string.lastIndexOf("."));
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            int n = pdfReader.getNumberOfPages();
            int n2 = 1 + n / 10;
            System.out.println("There are " + n + " pages in the original file.");
            int n3 = 0;
            while (n3 < n) {
                int n4 = n3 + 1;
                String string2 = String.valueOf(n4);
                while (string2.length() < n2) {
                    string2 = "0" + string2;
                }
                string2 = "_" + string2 + ".pdf";
                Document document = new Document(pdfReader.getPageSizeWithRotation(n4));
                PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(new File(file2, String.valueOf(string) + string2)));
                document.open();
                PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n4);
                int n5 = pdfReader.getPageRotation(n4);
                if (n5 == 90 || n5 == 270) {
                    pdfContentByte.addTemplate(pdfImportedPage, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, pdfReader.getPageSizeWithRotation(n4).height());
                } else {
                    pdfContentByte.addTemplate(pdfImportedPage, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                }
                document.close();
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Burst burst = new Burst();
        if (stringArray.length < 1) {
            System.err.println(burst.getUsage());
        }
        burst.setArguments(stringArray);
        burst.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is more than one destfile.");
    }
}

