/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfFontList;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfFont
extends Font
implements RtfExtendedElement {
    private static final byte[] FONT_FAMILY = "\\froman".getBytes();
    private static final byte[] FONT_CHARSET = "\\fcharset".getBytes();
    public static final byte[] FONT_SIZE = "\\fs".getBytes();
    private static final byte[] FONT_BOLD = "\\b".getBytes();
    private static final byte[] FONT_ITALIC = "\\i".getBytes();
    private static final byte[] FONT_UNDERLINE = "\\ul".getBytes();
    private static final byte[] FONT_STRIKETHROUGH = "\\strike".getBytes();
    private static final byte[] FONT_DOUBLE_STRIKETHROUGH = "\\striked".getBytes();
    private static final byte[] FONT_SHADOW = "\\shad".getBytes();
    private static final byte[] FONT_OUTLINE = "\\outl".getBytes();
    private static final byte[] FONT_EMBOSSED = "\\embo".getBytes();
    private static final byte[] FONT_ENGRAVED = "\\impr".getBytes();
    private static final byte[] FONT_HIDDEN = "\\v".getBytes();
    public static final int STYLE_NONE = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINE = 4;
    public static final int STYLE_STRIKETHROUGH = 8;
    public static final int STYLE_DOUBLE_STRIKETHROUGH = 16;
    public static final int STYLE_SHADOW = 32;
    public static final int STYLE_OUTLINE = 64;
    public static final int STYLE_EMBOSSED = 128;
    public static final int STYLE_ENGRAVED = 256;
    public static final int STYLE_HIDDEN = 512;
    private String fontName = "Times New Roman";
    private int fontSize = 10;
    private int fontStyle = 0;
    private int fontNumber = 0;
    private RtfColor color = null;
    private int charset = 0;
    protected RtfDocument document = null;

    public RtfFont(String string) {
        super(-1, -1.0f, -1, null);
        this.fontName = string;
    }

    public RtfFont(String string, float f) {
        super(-1, f, -1, null);
        this.fontName = string;
    }

    public RtfFont(String string, float f, int n) {
        super(-1, f, n, null);
        this.fontName = string;
    }

    public RtfFont(String string, float f, int n, Color color) {
        super(-1, f, n, color);
        this.fontName = string;
    }

    protected RtfFont(RtfDocument rtfDocument, int n) {
        this.document = rtfDocument;
        this.fontNumber = n;
        this.color = new RtfColor(rtfDocument, 0, 0, 0);
    }

    public RtfFont(RtfDocument rtfDocument, Font font) {
        this.document = rtfDocument;
        if (font != null) {
            if (font instanceof RtfFont) {
                this.fontName = ((RtfFont)font).getFontName();
            } else {
                this.setToDefaultFamily(font.getFamilyname());
            }
            if (font.getBaseFont() != null) {
                String[][] stringArray = font.getBaseFont().getFullFontName();
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n][2].equals("0")) {
                        this.fontName = stringArray[n][3];
                        break;
                    }
                    if (stringArray[n][2].equals("1033") || stringArray[n][2].equals("")) {
                        this.fontName = stringArray[n][3];
                    }
                    ++n;
                }
            }
            this.setSize(font.size());
            this.setStyle(font.style());
            this.setColor(font.color());
        }
        if (this.fontName.equalsIgnoreCase("unknown")) {
            return;
        }
        if (this.document != null) {
            this.setRtfDocument(this.document);
        }
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(FONT_FAMILY);
            byteArrayOutputStream.write(FONT_CHARSET);
            byteArrayOutputStream.write(this.intToByteArray(this.charset));
            byteArrayOutputStream.write(DELIMITER);
            byteArrayOutputStream.write(this.document.filterSpecialChar(this.fontName, true, false).getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeBegin() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (this.fontNumber != -1) {
                byteArrayOutputStream.write(RtfFontList.FONT_NUMBER);
                byteArrayOutputStream.write(this.intToByteArray(this.fontNumber));
            }
            if (this.fontSize != -1) {
                byteArrayOutputStream.write(FONT_SIZE);
                byteArrayOutputStream.write(this.intToByteArray(this.fontSize * 2));
            }
            if (this.fontStyle != -1) {
                if ((this.fontStyle & 1) == 1) {
                    byteArrayOutputStream.write(FONT_BOLD);
                }
                if ((this.fontStyle & 2) == 2) {
                    byteArrayOutputStream.write(FONT_ITALIC);
                }
                if ((this.fontStyle & 4) == 4) {
                    byteArrayOutputStream.write(FONT_UNDERLINE);
                }
                if ((this.fontStyle & 8) == 8) {
                    byteArrayOutputStream.write(FONT_STRIKETHROUGH);
                }
                if ((this.fontStyle & 0x200) == 512) {
                    byteArrayOutputStream.write(FONT_HIDDEN);
                }
                if ((this.fontStyle & 0x10) == 16) {
                    byteArrayOutputStream.write(FONT_DOUBLE_STRIKETHROUGH);
                    byteArrayOutputStream.write(this.intToByteArray(1));
                }
                if ((this.fontStyle & 0x20) == 32) {
                    byteArrayOutputStream.write(FONT_SHADOW);
                }
                if ((this.fontStyle & 0x40) == 64) {
                    byteArrayOutputStream.write(FONT_OUTLINE);
                }
                if ((this.fontStyle & 0x80) == 128) {
                    byteArrayOutputStream.write(FONT_EMBOSSED);
                }
                if ((this.fontStyle & 0x100) == 256) {
                    byteArrayOutputStream.write(FONT_ENGRAVED);
                }
            }
            if (this.color != null) {
                byteArrayOutputStream.write(this.color.writeBegin());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeEnd() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (this.fontStyle != -1) {
                if ((this.fontStyle & 1) == 1) {
                    byteArrayOutputStream.write(FONT_BOLD);
                    byteArrayOutputStream.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 2) == 2) {
                    byteArrayOutputStream.write(FONT_ITALIC);
                    byteArrayOutputStream.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 4) == 4) {
                    byteArrayOutputStream.write(FONT_UNDERLINE);
                    byteArrayOutputStream.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 8) == 8) {
                    byteArrayOutputStream.write(FONT_STRIKETHROUGH);
                    byteArrayOutputStream.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 0x200) == 512) {
                    byteArrayOutputStream.write(FONT_HIDDEN);
                    byteArrayOutputStream.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 0x10) == 16) {
                    byteArrayOutputStream.write(FONT_DOUBLE_STRIKETHROUGH);
                    byteArrayOutputStream.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 0x20) == 32) {
                    byteArrayOutputStream.write(FONT_SHADOW);
                    byteArrayOutputStream.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 0x40) == 64) {
                    byteArrayOutputStream.write(FONT_OUTLINE);
                    byteArrayOutputStream.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 0x80) == 128) {
                    byteArrayOutputStream.write(FONT_EMBOSSED);
                    byteArrayOutputStream.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 0x100) == 256) {
                    byteArrayOutputStream.write(FONT_ENGRAVED);
                    byteArrayOutputStream.write(this.intToByteArray(0));
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] write() {
        return new byte[0];
    }

    public boolean equals(Object object) {
        if (!(object instanceof RtfFont)) {
            return false;
        }
        RtfFont rtfFont = (RtfFont)object;
        boolean bl = true;
        return bl &= this.fontName.equals(rtfFont.getFontName());
    }

    public int hashCode() {
        return (String.valueOf(this.fontName) + this.fontSize + "-" + this.fontStyle).hashCode();
    }

    public String getFontName() {
        return this.fontName;
    }

    protected void setFontName(String string) {
        this.fontName = string;
        if (this.document != null) {
            this.fontNumber = this.document.getDocumentHeader().getFontNumber(this);
        }
    }

    public String getFamilyname() {
        return this.fontName;
    }

    public void setFamily(String string) {
        super.setFamily(string);
        this.setToDefaultFamily(string);
    }

    private void setToDefaultFamily(String string) {
        switch (Font.getFamilyIndex(string)) {
            case 0: {
                this.fontName = "Courier";
                break;
            }
            case 1: {
                this.fontName = "Arial";
                break;
            }
            case 3: {
                this.fontName = "Symbol";
                this.charset = 2;
                break;
            }
            case 2: {
                this.fontName = "Times New Roman";
                break;
            }
            case 4: {
                this.fontName = "Windings";
                break;
            }
            default: {
                this.fontName = string;
            }
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setSize(float f) {
        super.setSize(f);
        this.fontSize = (int)this.size();
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setStyle(int n) {
        super.setStyle(n);
        this.fontStyle = this.style();
    }

    public void setStyle(String string) {
        super.setStyle(string);
        this.fontStyle = this.style();
    }

    public int getFontNumber() {
        return this.fontNumber;
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        this.document = rtfDocument;
        if (this.document != null) {
            this.fontNumber = this.document.getDocumentHeader().getFontNumber(this);
        }
        if (this.color != null) {
            this.color.setRtfDocument(this.document);
        }
    }

    public void setInTable(boolean bl) {
    }

    public void setInHeader(boolean bl) {
    }

    public void setColor(Color color) {
        super.setColor(color);
        this.color = color != null ? new RtfColor(this.document, color) : null;
    }

    public void setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        this.color = new RtfColor(this.document, n, n2, n3);
    }

    protected byte[] intToByteArray(int n) {
        return Integer.toString(n).getBytes();
    }

    public Font difference(Font font) {
        float f;
        String string = font.getFamilyname();
        if (string == null || string.trim().equals("") || string.trim().equalsIgnoreCase("unknown")) {
            string = this.fontName;
        }
        if ((f = font.size()) == -1.0f) {
            f = this.size();
        }
        int n = -1;
        if (this.style() != -1 && font.style() != -1) {
            n = this.style() | font.style();
        } else if (this.style() != -1) {
            n = this.style();
        } else if (font.style() != -1) {
            n = font.style();
        }
        Color color = font.color();
        if (color == null) {
            color = this.color();
        }
        return new RtfFont(string, f, n, color);
    }
}

