/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Watermark;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.direct.RtfImportMappings;
import com.lowagie.text.rtf.direct.RtfParser;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfDocumentSettings;
import com.lowagie.text.rtf.text.RtfNewPage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;

public class RtfWriter2
extends DocWriter
implements DocListener {
    private RtfDocument rtfDoc = null;

    protected RtfWriter2(Document document, OutputStream outputStream) {
        super(document, outputStream);
        document.addDocListener(this);
        this.rtfDoc = new RtfDocument();
    }

    public static RtfWriter2 getInstance(Document document, OutputStream outputStream) {
        return new RtfWriter2(document, outputStream);
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.rtfDoc.getDocumentHeader().setHeader(headerFooter);
    }

    public void resetHeader() {
        this.rtfDoc.getDocumentHeader().setHeader(null);
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.rtfDoc.getDocumentHeader().setFooter(headerFooter);
    }

    public void resetFooter() {
        this.rtfDoc.getDocumentHeader().setFooter(null);
    }

    public void setPageCount(int n) {
    }

    public void resetPageCount() {
    }

    public boolean add(Watermark watermark) {
        return false;
    }

    public void removeWatermark() {
    }

    public void clearTextWrap() {
    }

    public void open() {
        super.open();
        this.rtfDoc.open();
    }

    public void close() {
        try {
            this.rtfDoc.writeDocument(this.os);
            if (this.closeStream) {
                this.os.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.rtfDoc = new RtfDocument();
        super.close();
    }

    public boolean add(Element element) throws DocumentException {
        if (this.pause) {
            return false;
        }
        RtfBasicElement rtfBasicElement = this.rtfDoc.getMapper().mapElement(element);
        if (rtfBasicElement != null) {
            this.rtfDoc.add(rtfBasicElement);
            return true;
        }
        return false;
    }

    public boolean newPage() {
        this.rtfDoc.add(new RtfNewPage(this.rtfDoc));
        return true;
    }

    public boolean setMargins(float f, float f2, float f3, float f4) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginLeft((int)((double)f * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginRight((int)((double)f2 * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginTop((int)((double)f3 * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginBottom((int)((double)f4 * 20.0));
        return true;
    }

    public boolean setPageSize(Rectangle rectangle) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setPageSize(rectangle);
        return true;
    }

    public void setAutogenerateTOCEntries(boolean bl) {
        this.rtfDoc.setAutogenerateTOCEntries(bl);
    }

    public void setDataCacheStyle(int n) throws DocumentException, IOException {
        this.rtfDoc.getDocumentSettings().setDataCacheStyle(n);
    }

    public RtfDocumentSettings getDocumentSettings() {
        return this.rtfDoc.getDocumentSettings();
    }

    public void importRtfDocument(Reader reader) throws IOException, DocumentException {
        if (!this.open) {
            throw new DocumentException("The document must be open to import RTF documents.");
        }
        RtfParser rtfParser = new RtfParser();
        rtfParser.importRtfDocument(reader, this.rtfDoc);
    }

    public void importRtfFragment(Reader reader, RtfImportMappings rtfImportMappings) throws IOException, DocumentException {
        if (!this.open) {
            throw new DocumentException("The document must be open to import RTF fragments.");
        }
        RtfParser rtfParser = new RtfParser();
        rtfParser.importRtfFragment(reader, this.rtfDoc, rtfImportMappings);
    }
}

