/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.Type3Glyph;
import java.io.IOException;
import java.util.HashMap;

public class Type3Font
extends BaseFont {
    private IntHashtable char2byte = new IntHashtable();
    private IntHashtable widths3 = new IntHashtable();
    private HashMap char2glyph = new HashMap<K, V>();
    private PdfWriter writer;
    private float llx = NaNf;
    private float lly;
    private float urx;
    private float ury;
    private PageResources pageResources = new PageResources();
    private boolean colorized;

    /*
     * Unable to fully structure code
     */
    public Type3Font(PdfWriter var1_1, char[] var2_2, boolean var3_3) {
        super();
        this.writer = var1_1;
        this.colorized = var3_3;
        this.fontType = 5;
        if (var2_2.length == 0 || var2_2.length > 256) {
            throw new IllegalArgumentException("char array size must be > 0 and <= 256");
        }
        var4_4 = 255;
        var5_5 = new boolean[var2_2.length];
        var6_6 = 0;
        while (var6_6 < var2_2.length) {
            var7_7 = var2_2[var6_6];
            if (var7_7 >= ' ' && var7_7 < '\u0100') {
                if (this.char2byte.containsKey(var7_7)) {
                    throw new IllegalArgumentException("duplicated char - " + var7_7 + ", index " + var6_6);
                }
                this.char2byte.put(var7_7, var7_7);
                var5_5[var6_6] = true;
            }
            ++var6_6;
        }
        var6_6 = 0;
        while (var6_6 < var5_5.length) {
            block7: {
                if (!var5_5[var6_6]) ** GOTO lbl30
                break block7;
lbl-1000:
                // 1 sources

                {
                    --var4_4;
lbl30:
                    // 2 sources

                    ** while (this.char2byte.containsKey((int)var4_4))
                }
lbl31:
                // 1 sources

                var7_7 = var2_2[var6_6];
                if (this.char2byte.containsKey(var7_7)) {
                    throw new IllegalArgumentException("duplicated char - " + var7_7 + ", index " + var6_6);
                }
                this.char2byte.put(var7_7, var4_4--);
            }
            ++var6_6;
        }
    }

    public PdfContentByte defineGlyph(char c, float f, float f2, float f3, float f4, float f5) {
        if (!this.char2byte.containsKey(c)) {
            throw new IllegalArgumentException("The char " + c + " doesn't belong in this Type3 font");
        }
        Integer n = new Integer(c);
        Type3Glyph type3Glyph = (Type3Glyph)this.char2glyph.get(n);
        if (type3Glyph != null) {
            return type3Glyph;
        }
        this.widths3.put(c, (int)f);
        if (!this.colorized) {
            if (Float.isNaN(this.llx)) {
                this.llx = f2;
                this.lly = f3;
                this.urx = f4;
                this.ury = f5;
            } else {
                this.llx = Math.min(this.llx, f2);
                this.lly = Math.min(this.lly, f3);
                this.urx = Math.max(this.urx, f4);
                this.ury = Math.max(this.ury, f5);
            }
        }
        type3Glyph = new Type3Glyph(this.writer, this.pageResources, f, f2, f3, f4, f5, this.colorized);
        this.char2glyph.put(n, type3Glyph);
        return type3Glyph;
    }

    public String[][] getFamilyFontName() {
        return new String[0][];
    }

    public float getFontDescriptor(int n, float f) {
        return 0.0f;
    }

    public String[][] getFullFontName() {
        return new String[0][];
    }

    public int getKerning(char c, char c2) {
        return 0;
    }

    public String getPostscriptFontName() {
        return "";
    }

    protected int[] getRawCharBBox(int n, String string) {
        return null;
    }

    int getRawWidth(int n, String string) {
        return 0;
    }

    public boolean hasKernPairs() {
        return false;
    }

    public boolean setKerning(char c, char c2, int n) {
        return false;
    }

    public void setPostscriptFontName(String string) {
    }

    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        if (this.writer != pdfWriter) {
            throw new IllegalArgumentException("Type3 font used with the wrong PdfWriter");
        }
        if (this.char2byte.size() != this.widths3.size()) {
            throw new DocumentException("Not all the glyphs in the Type3 font are defined");
        }
        IntHashtable intHashtable = new IntHashtable();
        Object object = this.char2byte.getEntryIterator();
        while (object.hasNext()) {
            IntHashtable.IntHashtableEntry intHashtableEntry = (IntHashtable.IntHashtableEntry)object.next();
            intHashtable.put(intHashtableEntry.getValue(), intHashtableEntry.getKey());
        }
        object = intHashtable.toOrderedKeys();
        Object object2 = object[0];
        Object object3 = object[((Object)object).length - 1];
        int[] nArray = new int[object3 - object2 + true];
        int n = 0;
        while (n < nArray.length) {
            if (intHashtable.containsKey(n + object2)) {
                nArray[n] = this.widths3.get(intHashtable.get(n + object2));
            }
            ++n;
        }
        PdfArray pdfArray = new PdfArray();
        PdfDictionary pdfDictionary = new PdfDictionary();
        Object object4 = -1;
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            Object object5 = object[n2];
            if (object5 > object4) {
                object4 = object5;
                pdfArray.add(new PdfNumber((int)object4));
            }
            ++object4;
            int n3 = intHashtable.get((int)object5);
            String string = GlyphList.unicodeToName(n3);
            if (string == null) {
                string = "a" + n3;
            }
            PdfName pdfName = new PdfName(string);
            pdfArray.add(pdfName);
            Type3Glyph type3Glyph = (Type3Glyph)this.char2glyph.get(new Integer(n3));
            PdfStream pdfStream = new PdfStream(type3Glyph.toPdf(null));
            pdfStream.flateCompress();
            PdfIndirectReference pdfIndirectReference2 = pdfWriter.addToBody(pdfStream).getIndirectReference();
            pdfDictionary.put(pdfName, pdfIndirectReference2);
            ++n2;
        }
        PdfDictionary pdfDictionary2 = new PdfDictionary(PdfName.FONT);
        pdfDictionary2.put(PdfName.SUBTYPE, PdfName.TYPE3);
        if (this.colorized) {
            pdfDictionary2.put(PdfName.FONTBBOX, new PdfRectangle(0.0f, 0.0f, 0.0f, 0.0f));
        } else {
            pdfDictionary2.put(PdfName.FONTBBOX, new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        }
        pdfDictionary2.put(PdfName.FONTMATRIX, new PdfArray(new float[]{0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f}));
        pdfDictionary2.put(PdfName.CHARPROCS, pdfWriter.addToBody(pdfDictionary).getIndirectReference());
        PdfDictionary pdfDictionary3 = new PdfDictionary();
        pdfDictionary3.put(PdfName.DIFFERENCES, pdfArray);
        pdfDictionary2.put(PdfName.ENCODING, pdfWriter.addToBody(pdfDictionary3).getIndirectReference());
        pdfDictionary2.put(PdfName.FIRSTCHAR, new PdfNumber((int)object2));
        pdfDictionary2.put(PdfName.LASTCHAR, new PdfNumber((int)object3));
        pdfDictionary2.put(PdfName.WIDTHS, pdfWriter.addToBody(new PdfArray(nArray)).getIndirectReference());
        if (this.pageResources.hasResources()) {
            pdfDictionary2.put(PdfName.RESOURCES, pdfWriter.addToBody(this.pageResources.getResources()).getIndirectReference());
        }
        pdfWriter.addToBody((PdfObject)pdfDictionary2, pdfIndirectReference);
    }

    byte[] convertToBytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (this.char2byte.containsKey(c)) {
                byArray[n++] = (byte)this.char2byte.get(c);
            }
            ++n2;
        }
        if (byArray.length == n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public int getWidth(char c) {
        if (!this.widths3.containsKey(c)) {
            throw new IllegalArgumentException("The char " + c + " is not defined in a Type3 font");
        }
        return this.widths3.get(c);
    }

    public int getWidth(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            n += this.getWidth(cArray[n2]);
            ++n2;
        }
        return n;
    }

    public int[] getCharBBox(char c) {
        return null;
    }

    public boolean charExists(char c) {
        return this.char2byte.containsKey(c);
    }

    public boolean setCharAdvance(char c, int n) {
        return false;
    }
}

