/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class PdfDictionary
extends PdfObject {
    public static final PdfName FONT = PdfName.FONT;
    public static final PdfName OUTLINES = PdfName.OUTLINES;
    public static final PdfName PAGE = PdfName.PAGE;
    public static final PdfName PAGES = PdfName.PAGES;
    public static final PdfName CATALOG = PdfName.CATALOG;
    private PdfName dictionaryType = null;
    protected HashMap hashMap = new HashMap();

    public PdfDictionary() {
        super(6);
    }

    public PdfDictionary(PdfName pdfName) {
        this();
        this.dictionaryType = pdfName;
        this.put(PdfName.TYPE, this.dictionaryType);
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        outputStream.write(60);
        outputStream.write(60);
        int n = 0;
        Iterator iterator = this.hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            PdfObject pdfObject = (PdfObject)this.hashMap.get(pdfName);
            pdfName.toPdf(pdfWriter, outputStream);
            n = pdfObject.type();
            if (n != 5 && n != 6 && n != 4 && n != 3) {
                outputStream.write(32);
            }
            pdfObject.toPdf(pdfWriter, outputStream);
        }
        outputStream.write(62);
        outputStream.write(62);
    }

    public void put(PdfName pdfName, PdfObject pdfObject) {
        if (pdfObject == null || pdfObject.isNull()) {
            this.hashMap.remove(pdfName);
        } else {
            this.hashMap.put(pdfName, pdfObject);
        }
    }

    public void putEx(PdfName pdfName, PdfObject pdfObject) {
        if (pdfObject == null) {
            return;
        }
        this.put(pdfName, pdfObject);
    }

    public void remove(PdfName pdfName) {
        this.hashMap.remove(pdfName);
    }

    public PdfObject get(PdfName pdfName) {
        return (PdfObject)this.hashMap.get(pdfName);
    }

    public boolean isDictionaryType(PdfName pdfName) {
        return this.dictionaryType.compareTo(pdfName) == 0;
    }

    public boolean isFont() {
        return this.dictionaryType.compareTo(FONT) == 0;
    }

    public boolean isPage() {
        return this.dictionaryType.compareTo(PAGE) == 0;
    }

    public boolean isPages() {
        return this.dictionaryType.compareTo(PAGES) == 0;
    }

    public boolean isCatalog() {
        return this.dictionaryType.compareTo(CATALOG) == 0;
    }

    public boolean isOutlineTree() {
        return this.dictionaryType.compareTo(OUTLINES) == 0;
    }

    public void merge(PdfDictionary pdfDictionary) {
        this.hashMap.putAll(pdfDictionary.hashMap);
    }

    public void mergeDifferent(PdfDictionary pdfDictionary) {
        Iterator iterator = pdfDictionary.hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (this.hashMap.containsKey(k)) continue;
            this.hashMap.put(k, pdfDictionary.hashMap.get(k));
        }
    }

    public Set getKeys() {
        return this.hashMap.keySet();
    }

    public void putAll(PdfDictionary pdfDictionary) {
        this.hashMap.putAll(pdfDictionary.hashMap);
    }

    public int size() {
        return this.hashMap.size();
    }

    public boolean contains(PdfName pdfName) {
        return this.hashMap.containsKey(pdfName);
    }

    public String toString() {
        return "Dictionary of type: " + this.get(PdfName.TYPE);
    }
}

