/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodeInter25
extends Barcode {
    static byte[][] BARS;

    static {
        byte[][] byArrayArray = new byte[10][];
        byte[] byArray = new byte[5];
        byArray[2] = 1;
        byArray[3] = 1;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[0] = 1;
        byArray2[4] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[5];
        byArray3[1] = 1;
        byArray3[4] = 1;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[5];
        byArray4[0] = 1;
        byArray4[1] = 1;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[5];
        byArray5[2] = 1;
        byArray5[4] = 1;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[5];
        byArray6[0] = 1;
        byArray6[2] = 1;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[5];
        byArray7[1] = 1;
        byArray7[2] = 1;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[5];
        byArray8[3] = 1;
        byArray8[4] = 1;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[5];
        byArray9[0] = 1;
        byArray9[3] = 1;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[5];
        byArray10[1] = 1;
        byArray10[3] = 1;
        byArrayArray[9] = byArray10;
        BARS = byArrayArray;
    }

    public BarcodeInter25() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static String keepNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= '0' && c <= '9') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static char getChecksum(String string) {
        int n = 3;
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            int n4 = string.charAt(n3) - 48;
            n2 += n * n4;
            n ^= 2;
            --n3;
        }
        return (char)((10 - n2 % 10) % 10 + 48);
    }

    public static byte[] getBarsInter25(String string) {
        if (((string = BarcodeInter25.keepNumbers(string)).length() & 1) != 0) {
            throw new IllegalArgumentException("The text length must be even.");
        }
        byte[] byArray = new byte[string.length() * 5 + 7];
        int n = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        int n2 = string.length() / 2;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = string.charAt(n3 * 2) - 48;
            int n5 = string.charAt(n3 * 2 + 1) - 48;
            byte[] byArray2 = BARS[n4];
            byte[] byArray3 = BARS[n5];
            int n6 = 0;
            while (n6 < 5) {
                byArray[n++] = byArray2[n6];
                byArray[n++] = byArray3[n6];
                ++n6;
            }
            ++n3;
        }
        byArray[n++] = 1;
        byArray[n++] = 0;
        byArray[n++] = 0;
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        String string;
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.font != null) {
            f2 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.generateChecksum && this.checksumText) {
                string = String.valueOf(string) + BarcodeInter25.getChecksum(string);
            }
            f = this.font.getWidthPoint(this.altText != null ? this.altText : string, this.size);
        }
        string = BarcodeInter25.keepNumbers(this.code);
        int n = string.length();
        if (this.generateChecksum) {
            ++n;
        }
        float f3 = (float)n * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        f3 = Math.max(f3, f);
        float f4 = this.barHeight + f2;
        return new Rectangle(f3, f4);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        String string = this.code;
        float f = 0.0f;
        if (this.font != null) {
            if (this.generateChecksum && this.checksumText) {
                string = String.valueOf(string) + BarcodeInter25.getChecksum(string);
            }
            string = this.altText != null ? this.altText : string;
            f = this.font.getWidthPoint(string, this.size);
        }
        String string2 = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            string2 = String.valueOf(string2) + BarcodeInter25.getChecksum(string2);
        }
        int n = string2.length();
        float f2 = (float)n * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f > f2) {
                    f3 = f - f2;
                    break;
                }
                f4 = f2 - f;
                break;
            }
            default: {
                if (f > f2) {
                    f3 = (f - f2) / 2.0f;
                    break;
                }
                f4 = (f2 - f) / 2.0f;
            }
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f6 = this.barHeight - this.baseline;
            } else {
                f6 = -this.font.getFontDescriptor(3, this.size);
                f5 = f6 + this.baseline;
            }
        }
        byte[] byArray = BarcodeInter25.getBarsInter25(string2);
        boolean bl = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            float f7;
            float f8 = f7 = byArray[n2] == 0 ? this.x : this.x * this.n;
            if (bl) {
                pdfContentByte.rectangle(f3, f5, f7 - this.inkSpreading, this.barHeight);
            }
            bl = !bl;
            f3 += f7;
            ++n2;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f4, f6);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        int n = color.getRGB();
        int n2 = color2.getRGB();
        Canvas canvas = new Canvas();
        String string = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            string = String.valueOf(string) + BarcodeInter25.getChecksum(string);
        }
        int n3 = string.length();
        int n4 = (int)this.n;
        int n5 = n3 * (3 + 2 * n4) + (6 + n4);
        byte[] byArray = BarcodeInter25.getBarsInter25(string);
        boolean bl = true;
        int n6 = 0;
        int n7 = (int)this.barHeight;
        int[] nArray = new int[n5 * n7];
        int n8 = 0;
        while (n8 < byArray.length) {
            int n9 = byArray[n8] == 0 ? 1 : n4;
            int n10 = n2;
            if (bl) {
                n10 = n;
            }
            bl = !bl;
            int n11 = 0;
            while (n11 < n9) {
                nArray[n6++] = n10;
                ++n11;
            }
            ++n8;
        }
        n8 = n5;
        while (n8 < nArray.length) {
            System.arraycopy(nArray, 0, nArray, n8, n5);
            n8 += n5;
        }
        Image image = canvas.createImage(new MemoryImageSource(n5, n7, nArray, 0, n5));
        return image;
    }
}

