/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.ImgCCITT;
import com.lowagie.text.ImgPostscript;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.ImgTemplate;
import com.lowagie.text.ImgWMF;
import com.lowagie.text.Jpeg;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfOCG;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.BmpImage;
import com.lowagie.text.pdf.codec.CCITTG4Encoder;
import com.lowagie.text.pdf.codec.GifImage;
import com.lowagie.text.pdf.codec.PngImage;
import com.lowagie.text.pdf.codec.TiffImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.color.ICC_Profile;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public abstract class Image
extends Rectangle
implements Element,
MarkupAttributes {
    public static final int DEFAULT = 0;
    public static final int RIGHT = 2;
    public static final int LEFT = 0;
    public static final int MIDDLE = 1;
    public static final int TEXTWRAP = 4;
    public static final int UNDERLYING = 8;
    public static final int AX = 0;
    public static final int AY = 1;
    public static final int BX = 2;
    public static final int BY = 3;
    public static final int CX = 4;
    public static final int CY = 5;
    public static final int DX = 6;
    public static final int DY = 7;
    public static final int ORIGINAL_NONE = 0;
    public static final int ORIGINAL_JPEG = 1;
    public static final int ORIGINAL_PNG = 2;
    public static final int ORIGINAL_GIF = 3;
    public static final int ORIGINAL_BMP = 4;
    public static final int ORIGINAL_TIFF = 5;
    public static final int ORIGINAL_WMF = 6;
    public static final int ORIGINAL_PS = 7;
    protected boolean invert = false;
    protected int type;
    protected URL url;
    protected byte[] rawData;
    protected PdfTemplate[] template = new PdfTemplate[1];
    protected int alignment;
    protected String alt;
    protected float absoluteX = Float.NaN;
    protected float absoluteY = Float.NaN;
    protected float plainWidth;
    protected float plainHeight;
    protected float scaledWidth;
    protected float scaledHeight;
    protected float rotation;
    protected int colorspace = -1;
    protected int bpc = 1;
    protected int[] transparency;
    protected float indentationLeft = 0.0f;
    protected float indentationRight = 0.0f;
    protected Long mySerialId = Image.getSerialId();
    static long serialId = 0L;
    protected int dpiX = 0;
    protected int dpiY = 0;
    protected boolean mask = false;
    protected Image imageMask;
    protected boolean interpolation;
    protected Annotation annotation = null;
    protected Properties markupAttributes;
    protected ICC_Profile profile = null;
    protected boolean deflated = false;
    private PdfDictionary additional = null;
    private boolean smask;
    private float XYRatio = 0.0f;
    protected int originalType = 0;
    protected byte[] originalData;
    protected float spacingBefore;
    protected float spacingAfter;
    private float widthPercentage = 100.0f;
    protected PdfOCG layer;
    private float initialRotation;
    private static String excUri = " <>#%\"{}[]|\\^`";
    private static String[] excUriEsc = new String[]{"%20", "%3C", "%3E", "%23", "%25", "%22", "%7B", "%7D", "%5B", "%5D", "%7C", "%5C", "%5E", "%60"};
    private PdfIndirectReference directReference;
    static /* synthetic */ Class class$0;

    public Image(URL uRL) {
        super(0.0f, 0.0f);
        this.url = uRL;
        this.alignment = 0;
        this.rotation = 0.0f;
    }

    protected Image(Image image) {
        super(image);
        this.type = image.type;
        this.url = image.url;
        this.alignment = image.alignment;
        this.alt = image.alt;
        this.absoluteX = image.absoluteX;
        this.absoluteY = image.absoluteY;
        this.plainWidth = image.plainWidth;
        this.plainHeight = image.plainHeight;
        this.scaledWidth = image.scaledWidth;
        this.scaledHeight = image.scaledHeight;
        this.rotation = image.rotation;
        this.colorspace = image.colorspace;
        this.rawData = image.rawData;
        this.template = image.template;
        this.bpc = image.bpc;
        this.transparency = image.transparency;
        this.mySerialId = image.mySerialId;
        this.invert = image.invert;
        this.dpiX = image.dpiX;
        this.dpiY = image.dpiY;
        this.mask = image.mask;
        this.imageMask = image.imageMask;
        this.interpolation = image.interpolation;
        this.annotation = image.annotation;
        this.markupAttributes = image.markupAttributes;
        this.profile = image.profile;
        this.deflated = image.deflated;
        this.additional = image.additional;
        this.smask = image.smask;
        this.XYRatio = image.XYRatio;
        this.originalData = image.originalData;
        this.originalType = image.originalType;
        this.spacingAfter = image.spacingAfter;
        this.spacingBefore = image.spacingBefore;
        this.widthPercentage = image.widthPercentage;
        this.layer = image.layer;
        this.initialRotation = image.initialRotation;
        this.directReference = image.directReference;
    }

    public static Image getInstance(Image image) {
        if (image == null) {
            return null;
        }
        try {
            Class<?> clazz = image.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.lowagie.text.Image");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            return (Image)constructor.newInstance(image);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getInstance(URL uRL) throws BadElementException, MalformedURLException, IOException {
        Object object;
        InputStream inputStream;
        block20: {
            Image image;
            block19: {
                ImgWMF imgWMF;
                block18: {
                    ImgPostscript imgPostscript;
                    block17: {
                        Image image2;
                        block16: {
                            Jpeg jpeg;
                            block15: {
                                Image image3;
                                block14: {
                                    inputStream = null;
                                    try {
                                        inputStream = uRL.openStream();
                                        int n = inputStream.read();
                                        int n2 = inputStream.read();
                                        int n3 = inputStream.read();
                                        int n4 = inputStream.read();
                                        inputStream.close();
                                        inputStream = null;
                                        if (n == 71 && n2 == 73 && n3 == 70) {
                                            Image image4;
                                            GifImage gifImage = new GifImage(uRL);
                                            image3 = image4 = gifImage.getImage(1);
                                            Object var11_16 = null;
                                            if (inputStream == null) return image3;
                                            break block14;
                                        }
                                        if (n == 255 && n2 == 216) {
                                            jpeg = new Jpeg(uRL);
                                            break block15;
                                        }
                                        if (n == PngImage.PNGID[0] && n2 == PngImage.PNGID[1] && n3 == PngImage.PNGID[2] && n4 == PngImage.PNGID[3]) {
                                            image2 = PngImage.getImage(uRL);
                                            break block16;
                                        }
                                        if (n == 37 && n2 == 33 && n3 == 80 && n4 == 83) {
                                            imgPostscript = new ImgPostscript(uRL);
                                            break block17;
                                        }
                                        if (n == 215 && n2 == 205) {
                                            imgWMF = new ImgWMF(uRL);
                                            break block18;
                                        }
                                        if (n == 66 && n2 == 77) {
                                            image = BmpImage.getImage(uRL);
                                            break block19;
                                        }
                                        if (n != 77 || n2 != 77 || n3 != 0 || n4 != 42) {
                                            if (n != 73) throw new IOException(String.valueOf(uRL.toString()) + " is not a recognized imageformat.");
                                            if (n2 != 73) throw new IOException(String.valueOf(uRL.toString()) + " is not a recognized imageformat.");
                                            if (n3 != 42) throw new IOException(String.valueOf(uRL.toString()) + " is not a recognized imageformat.");
                                            if (n4 != 0) throw new IOException(String.valueOf(uRL.toString()) + " is not a recognized imageformat.");
                                        }
                                        RandomAccessFileOrArray randomAccessFileOrArray = null;
                                        try {
                                            Object object2;
                                            if (uRL.getProtocol().equals("file")) {
                                                object2 = uRL.getFile();
                                                object2 = Image.unEscapeURL((String)object2);
                                                randomAccessFileOrArray = new RandomAccessFileOrArray((String)object2);
                                            } else {
                                                randomAccessFileOrArray = new RandomAccessFileOrArray(uRL);
                                            }
                                            object2 = TiffImage.getTiffImage(randomAccessFileOrArray, 1);
                                            ((Image)object2).url = uRL;
                                            object = object2;
                                            Object var8_25 = null;
                                            if (randomAccessFileOrArray == null) break block20;
                                        }
                                        catch (Throwable throwable) {
                                            Object var8_26 = null;
                                            if (randomAccessFileOrArray == null) throw throwable;
                                            randomAccessFileOrArray.close();
                                            throw throwable;
                                        }
                                        randomAccessFileOrArray.close();
                                        break block20;
                                    }
                                    catch (Throwable throwable) {
                                        Object var11_23 = null;
                                        if (inputStream == null) throw throwable;
                                        inputStream.close();
                                        throw throwable;
                                    }
                                }
                                inputStream.close();
                                return image3;
                            }
                            Object var11_17 = null;
                            if (inputStream == null) return jpeg;
                            inputStream.close();
                            return jpeg;
                        }
                        Object var11_18 = null;
                        if (inputStream == null) return image2;
                        inputStream.close();
                        return image2;
                    }
                    Object var11_19 = null;
                    if (inputStream == null) return imgPostscript;
                    inputStream.close();
                    return imgPostscript;
                }
                Object var11_20 = null;
                if (inputStream == null) return imgWMF;
                inputStream.close();
                return imgWMF;
            }
            Object var11_21 = null;
            if (inputStream == null) return image;
            inputStream.close();
            return image;
        }
        Object var11_22 = null;
        if (inputStream == null) return object;
        inputStream.close();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getInstance(byte[] byArray) throws BadElementException, MalformedURLException, IOException {
        Image image;
        ByteArrayInputStream byteArrayInputStream;
        block19: {
            Image image2;
            block18: {
                ImgWMF imgWMF;
                block17: {
                    ImgPostscript imgPostscript;
                    block16: {
                        Image image3;
                        block15: {
                            Jpeg jpeg;
                            block14: {
                                Image image4;
                                block13: {
                                    byteArrayInputStream = null;
                                    try {
                                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                                        int n = ((InputStream)byteArrayInputStream).read();
                                        int n2 = ((InputStream)byteArrayInputStream).read();
                                        int n3 = ((InputStream)byteArrayInputStream).read();
                                        int n4 = ((InputStream)byteArrayInputStream).read();
                                        ((InputStream)byteArrayInputStream).close();
                                        byteArrayInputStream = null;
                                        if (n == 71 && n2 == 73 && n3 == 70) {
                                            GifImage gifImage = new GifImage(byArray);
                                            image4 = gifImage.getImage(1);
                                            Object var11_14 = null;
                                            if (byteArrayInputStream == null) return image4;
                                            break block13;
                                        }
                                        if (n == 255 && n2 == 216) {
                                            jpeg = new Jpeg(byArray);
                                            break block14;
                                        }
                                        if (n == PngImage.PNGID[0] && n2 == PngImage.PNGID[1] && n3 == PngImage.PNGID[2] && n4 == PngImage.PNGID[3]) {
                                            image3 = PngImage.getImage(byArray);
                                            break block15;
                                        }
                                        if (n == 37 && n2 == 33 && n3 == 80 && n4 == 83) {
                                            imgPostscript = new ImgPostscript(byArray);
                                            break block16;
                                        }
                                        if (n == 215 && n2 == 205) {
                                            imgWMF = new ImgWMF(byArray);
                                            break block17;
                                        }
                                        if (n == 66 && n2 == 77) {
                                            image2 = BmpImage.getImage(byArray);
                                            break block18;
                                        }
                                        if (n != 77 || n2 != 77 || n3 != 0 || n4 != 42) {
                                            if (n != 73) throw new IOException("The byte array is not a recognized imageformat.");
                                            if (n2 != 73) throw new IOException("The byte array is not a recognized imageformat.");
                                            if (n3 != 42) throw new IOException("The byte array is not a recognized imageformat.");
                                            if (n4 != 0) throw new IOException("The byte array is not a recognized imageformat.");
                                        }
                                        RandomAccessFileOrArray randomAccessFileOrArray = null;
                                        try {
                                            randomAccessFileOrArray = new RandomAccessFileOrArray(byArray);
                                            Image image5 = TiffImage.getTiffImage(randomAccessFileOrArray, 1);
                                            if (image5.getOriginalData() == null) {
                                                image5.setOriginalData(byArray);
                                            }
                                            image = image5;
                                            Object var8_24 = null;
                                            if (randomAccessFileOrArray == null) break block19;
                                        }
                                        catch (Throwable throwable) {
                                            Object var8_25 = null;
                                            if (randomAccessFileOrArray == null) throw throwable;
                                            randomAccessFileOrArray.close();
                                            throw throwable;
                                        }
                                        randomAccessFileOrArray.close();
                                        break block19;
                                    }
                                    catch (Throwable throwable) {
                                        Object var11_21 = null;
                                        if (byteArrayInputStream == null) throw throwable;
                                        ((InputStream)byteArrayInputStream).close();
                                        throw throwable;
                                    }
                                }
                                ((InputStream)byteArrayInputStream).close();
                                return image4;
                            }
                            Object var11_15 = null;
                            if (byteArrayInputStream == null) return jpeg;
                            ((InputStream)byteArrayInputStream).close();
                            return jpeg;
                        }
                        Object var11_16 = null;
                        if (byteArrayInputStream == null) return image3;
                        ((InputStream)byteArrayInputStream).close();
                        return image3;
                    }
                    Object var11_17 = null;
                    if (byteArrayInputStream == null) return imgPostscript;
                    ((InputStream)byteArrayInputStream).close();
                    return imgPostscript;
                }
                Object var11_18 = null;
                if (byteArrayInputStream == null) return imgWMF;
                ((InputStream)byteArrayInputStream).close();
                return imgWMF;
            }
            Object var11_19 = null;
            if (byteArrayInputStream == null) return image2;
            ((InputStream)byteArrayInputStream).close();
            return image2;
        }
        Object var11_20 = null;
        if (byteArrayInputStream == null) return image;
        ((InputStream)byteArrayInputStream).close();
        return image;
    }

    public static Image getInstance(java.awt.Image image, Color color, boolean bl) throws BadElementException, IOException {
        int n;
        int n2;
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("java.awt.Image Interrupted waiting for pixels!");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new IOException("java.awt.Image fetch aborted or errored");
        }
        int n3 = pixelGrabber.getWidth();
        int n4 = pixelGrabber.getHeight();
        int[] nArray = (int[])pixelGrabber.getPixels();
        if (bl) {
            int n5 = n3 / 8 + ((n3 & 7) != 0 ? 1 : 0);
            byte[] byArray = new byte[n5 * n4];
            int n6 = 0;
            int n7 = n4 * n3;
            boolean bl2 = true;
            if (color != null) {
                bl2 = color.getRed() + color.getGreen() + color.getBlue() >= 384;
            }
            int[] nArray2 = null;
            int n8 = 128;
            int n9 = 0;
            int n10 = 0;
            if (color != null) {
                int n11 = 0;
                while (n11 < n7) {
                    int n12 = nArray[n11] >> 24 & 0xFF;
                    if (n12 < 250) {
                        if (bl2) {
                            n10 |= n8;
                        }
                    } else if ((nArray[n11] & 0x888) != 0) {
                        n10 |= n8;
                    }
                    if ((n8 >>= 1) == 0 || n9 + 1 >= n3) {
                        byArray[n6++] = (byte)n10;
                        n8 = 128;
                        n10 = 0;
                    }
                    if (++n9 >= n3) {
                        n9 = 0;
                    }
                    ++n11;
                }
            } else {
                int n13 = 0;
                while (n13 < n7) {
                    int n14;
                    if (nArray2 == null && (n14 = nArray[n13] >> 24 & 0xFF) == 0) {
                        nArray2 = new int[2];
                        nArray2[1] = (nArray[n13] & 0x888) != 0 ? 1 : 0;
                        nArray2[0] = nArray2[1];
                    }
                    if ((nArray[n13] & 0x888) != 0) {
                        n10 |= n8;
                    }
                    if ((n8 >>= 1) == 0 || n9 + 1 >= n3) {
                        byArray[n6++] = (byte)n10;
                        n8 = 128;
                        n10 = 0;
                    }
                    if (++n9 >= n3) {
                        n9 = 0;
                    }
                    ++n13;
                }
            }
            return Image.getInstance(n3, n4, 1, 1, byArray, nArray2);
        }
        byte[] byArray = new byte[n3 * n4 * 3];
        byte[] byArray2 = null;
        int n15 = 0;
        int n16 = n4 * n3;
        int n17 = 255;
        int n18 = 255;
        int n19 = 255;
        if (color != null) {
            n17 = color.getRed();
            n18 = color.getGreen();
            n19 = color.getBlue();
        }
        int[] nArray3 = null;
        if (color != null) {
            n2 = 0;
            while (n2 < n16) {
                n = nArray[n2] >> 24 & 0xFF;
                if (n < 250) {
                    byArray[n15++] = (byte)n17;
                    byArray[n15++] = (byte)n18;
                    byArray[n15++] = (byte)n19;
                } else {
                    byArray[n15++] = (byte)(nArray[n2] >> 16 & 0xFF);
                    byArray[n15++] = (byte)(nArray[n2] >> 8 & 0xFF);
                    byArray[n15++] = (byte)(nArray[n2] & 0xFF);
                }
                ++n2;
            }
        } else {
            n2 = 0;
            byArray2 = new byte[n3 * n4];
            n = 0;
            int n20 = 0;
            while (n20 < n16) {
                byte by = byArray2[n20] = (byte)(nArray[n20] >> 24 & 0xFF);
                if (n == 0) {
                    if (by != 0 && by != -1) {
                        n = 1;
                    } else if (nArray3 == null) {
                        if (by == 0) {
                            n2 = nArray[n20] & 0xFFFFFF;
                            nArray3 = new int[6];
                            nArray3[0] = nArray3[1] = n2 >> 16 & 0xFF;
                            nArray3[2] = nArray3[3] = n2 >> 8 & 0xFF;
                            nArray3[4] = nArray3[5] = n2 & 0xFF;
                        }
                    } else if ((nArray[n20] & 0xFFFFFF) != n2) {
                        n = 1;
                    }
                }
                byArray[n15++] = (byte)(nArray[n20] >> 16 & 0xFF);
                byArray[n15++] = (byte)(nArray[n20] >> 8 & 0xFF);
                byArray[n15++] = (byte)(nArray[n20] & 0xFF);
                ++n20;
            }
            if (n != 0) {
                nArray3 = null;
            } else {
                byArray2 = null;
            }
        }
        Image image2 = Image.getInstance(n3, n4, 3, 8, byArray, nArray3);
        if (byArray2 != null) {
            Image image3 = Image.getInstance(n3, n4, 1, 8, byArray2);
            try {
                image3.makeMask();
                image2.setImageMask(image3);
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
        }
        return image2;
    }

    public static Image getInstance(java.awt.Image image, Color color) throws BadElementException, IOException {
        return Image.getInstance(image, color, false);
    }

    public static Image getInstance(PdfWriter pdfWriter, java.awt.Image image, float f) throws BadElementException, IOException {
        return Image.getInstance(new PdfContentByte(pdfWriter), image, f);
    }

    public static Image getInstance(PdfContentByte pdfContentByte, java.awt.Image image, float f) throws BadElementException, IOException {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("java.awt.Image Interrupted waiting for pixels!");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new IOException("java.awt.Image fetch aborted or errored");
        }
        int n = pixelGrabber.getWidth();
        int n2 = pixelGrabber.getHeight();
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate(n, n2);
        Graphics2D graphics2D = pdfTemplate.createGraphics(n, n2, true, f);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return Image.getInstance(pdfTemplate);
    }

    public static Image getInstance(String string) throws BadElementException, MalformedURLException, IOException {
        return Image.getInstance(Image.toURL(string));
    }

    public static Image getInstance(int n, int n2, int n3, int n4, byte[] byArray) throws BadElementException {
        return Image.getInstance(n, n2, n3, n4, byArray, null);
    }

    public static Image getInstance(PRIndirectReference pRIndirectReference) throws BadElementException {
        Object object;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pRIndirectReference);
        int n = ((PdfNumber)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.WIDTH))).intValue();
        int n2 = ((PdfNumber)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.HEIGHT))).intValue();
        Image image = null;
        PdfObject pdfObject = pdfDictionary.get(PdfName.SMASK);
        if (pdfObject != null && pdfObject.isIndirect()) {
            image = Image.getInstance((PRIndirectReference)pdfObject);
        } else {
            pdfObject = pdfDictionary.get(PdfName.MASK);
            if (pdfObject != null && pdfObject.isIndirect() && (object = PdfReader.getPdfObjectRelease(pdfObject)) instanceof PdfDictionary) {
                image = Image.getInstance((PRIndirectReference)pdfObject);
            }
        }
        object = new ImgRaw(n, n2, 1, 1, null);
        ((Image)object).imageMask = image;
        ((Image)object).directReference = pRIndirectReference;
        return object;
    }

    public static Image getInstance(PdfTemplate pdfTemplate) throws BadElementException {
        return new ImgTemplate(pdfTemplate);
    }

    public static Image getInstance(int n, int n2, boolean bl, int n3, int n4, byte[] byArray) throws BadElementException {
        return Image.getInstance(n, n2, bl, n3, n4, byArray, null);
    }

    public static Image getInstance(int n, int n2, boolean bl, int n3, int n4, byte[] byArray, int[] nArray) throws BadElementException {
        if (nArray != null && nArray.length != 2) {
            throw new BadElementException("Transparency length must be equal to 2 with CCITT images");
        }
        ImgCCITT imgCCITT = new ImgCCITT(n, n2, bl, n3, n4, byArray);
        imgCCITT.transparency = nArray;
        return imgCCITT;
    }

    public static Image getInstance(int n, int n2, int n3, int n4, byte[] byArray, int[] nArray) throws BadElementException {
        if (nArray != null && nArray.length != n3 * 2) {
            throw new BadElementException("Transparency length must be equal to (componentes * 2)");
        }
        if (n3 == 1 && n4 == 1) {
            byte[] byArray2 = CCITTG4Encoder.compress(byArray, n, n2);
            return Image.getInstance(n, n2, false, 256, 1, byArray2, nArray);
        }
        ImgRaw imgRaw = new ImgRaw(n, n2, n3, n4, byArray);
        imgRaw.transparency = nArray;
        return imgRaw;
    }

    public static Image getInstance(Properties properties) throws BadElementException, MalformedURLException, IOException {
        String string;
        String string2;
        String string3 = (String)properties.remove("url");
        if (string3 == null) {
            throw new MalformedURLException("The URL of the image is missing.");
        }
        Image image = Image.getInstance(string3);
        int n = 0;
        string3 = (String)properties.remove("align");
        if (string3 != null) {
            if ("Left".equalsIgnoreCase(string3)) {
                n |= 0;
            } else if ("Right".equalsIgnoreCase(string3)) {
                n |= 2;
            } else if ("Middle".equalsIgnoreCase(string3)) {
                n |= 1;
            }
        }
        if ((string3 = (String)properties.remove("underlying")) != null && new Boolean(string3).booleanValue()) {
            n |= 8;
        }
        if ((string3 = (String)properties.remove("textwrap")) != null && new Boolean(string3).booleanValue()) {
            n |= 4;
        }
        image.setAlignment(n);
        string3 = (String)properties.remove("alt");
        if (string3 != null) {
            image.setAlt(string3);
        }
        if ((string2 = (String)properties.remove("absolutex")) != null && (string = (String)properties.remove("absolutey")) != null) {
            image.setAbsolutePosition(Float.valueOf(String.valueOf(string2) + "f").floatValue(), Float.valueOf(String.valueOf(string) + "f").floatValue());
        }
        if ((string3 = (String)properties.remove("plainwidth")) != null) {
            image.scaleAbsoluteWidth(Float.valueOf(String.valueOf(string3) + "f").floatValue());
        }
        if ((string3 = (String)properties.remove("plainheight")) != null) {
            image.scaleAbsoluteHeight(Float.valueOf(String.valueOf(string3) + "f").floatValue());
        }
        if ((string3 = (String)properties.remove("rotation")) != null) {
            image.setRotation(Float.valueOf(String.valueOf(string3) + "f").floatValue());
        }
        if (properties.size() > 0) {
            image.setMarkupAttributes(properties);
        }
        return image;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setAlt(String string) {
        this.alt = string;
    }

    public void setAbsolutePosition(float f, float f2) {
        this.absoluteX = f;
        this.absoluteY = f2;
    }

    public void scaleAbsolute(float f, float f2) {
        this.plainWidth = f;
        this.plainHeight = f2;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleAbsoluteWidth(float f) {
        this.plainWidth = f;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleAbsoluteHeight(float f) {
        this.plainHeight = f;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scalePercent(float f) {
        this.scalePercent(f, f);
    }

    public void scalePercent(float f, float f2) {
        this.plainWidth = this.width() * f / 100.0f;
        this.plainHeight = this.height() * f2 / 100.0f;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleToFit(float f, float f2) {
        this.scalePercent(100.0f);
        float f3 = f * 100.0f / this.scaledWidth();
        float f4 = f2 * 100.0f / this.scaledHeight();
        this.scalePercent(f3 < f4 ? f3 : f4);
    }

    public float getImageRotation() {
        float f = (float)((double)(this.rotation - this.initialRotation) % (Math.PI * 2));
        if (f < 0.0f) {
            f = (float)((double)f + Math.PI * 2);
        }
        return f;
    }

    public void setRotation(float f) {
        double d = Math.PI;
        this.rotation = (float)((double)(f + this.initialRotation) % (2.0 * d));
        if (this.rotation < 0.0f) {
            this.rotation = (float)((double)this.rotation + 2.0 * d);
        }
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void setRotationDegrees(float f) {
        double d = Math.PI;
        this.setRotation(f / 180.0f * (float)d);
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public Annotation annotation() {
        return this.annotation;
    }

    public int bpc() {
        return this.bpc;
    }

    public byte[] rawData() {
        return this.rawData;
    }

    public PdfTemplate templateData() {
        return this.template[0];
    }

    public void setTemplateData(PdfTemplate pdfTemplate) {
        this.template[0] = pdfTemplate;
    }

    public boolean hasAbsolutePosition() {
        return !Float.isNaN(this.absoluteY);
    }

    public boolean hasAbsoluteX() {
        return !Float.isNaN(this.absoluteX);
    }

    public float absoluteX() {
        return this.absoluteX;
    }

    public float absoluteY() {
        return this.absoluteY;
    }

    public int type() {
        return this.type;
    }

    public boolean isJpeg() {
        return this.type == 32;
    }

    public boolean isImgRaw() {
        return this.type == 34;
    }

    public boolean isImgTemplate() {
        return this.type == 35;
    }

    public URL url() {
        return this.url;
    }

    public int alignment() {
        return this.alignment;
    }

    public String alt() {
        return this.alt;
    }

    public float scaledWidth() {
        return this.scaledWidth;
    }

    public float scaledHeight() {
        return this.scaledHeight;
    }

    public int colorspace() {
        return this.colorspace;
    }

    public float[] matrix() {
        float[] fArray = new float[8];
        float f = (float)Math.cos(this.rotation);
        float f2 = (float)Math.sin(this.rotation);
        fArray[0] = this.plainWidth * f;
        fArray[1] = this.plainWidth * f2;
        fArray[2] = -this.plainHeight * f2;
        fArray[3] = this.plainHeight * f;
        if ((double)this.rotation < 1.5707963267948966) {
            fArray[4] = fArray[2];
            fArray[5] = 0.0f;
            fArray[6] = fArray[0];
            fArray[7] = fArray[1] + fArray[3];
        } else if ((double)this.rotation < Math.PI) {
            fArray[4] = fArray[0] + fArray[2];
            fArray[5] = fArray[3];
            fArray[6] = 0.0f;
            fArray[7] = fArray[1];
        } else if ((double)this.rotation < 4.71238898038469) {
            fArray[4] = fArray[0];
            fArray[5] = fArray[1] + fArray[3];
            fArray[6] = fArray[2];
            fArray[7] = 0.0f;
        } else {
            fArray[4] = 0.0f;
            fArray[5] = fArray[1];
            fArray[6] = fArray[0] + fArray[2];
            fArray[7] = fArray[3];
        }
        return fArray;
    }

    public static void skip(InputStream inputStream, int n) throws IOException {
        while (n > 0) {
            long l = inputStream.skip(n);
            if (l <= 0L) break;
            n = (int)((long)n - l);
        }
    }

    public static URL toURL(String string) throws MalformedURLException {
        if (string.startsWith("file:/") || string.startsWith("http://") || string.startsWith("https://") || string.startsWith("jar:")) {
            return new URL(string);
        }
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && file.isDirectory()) {
            string2 = String.valueOf(string2) + "/";
        }
        char[] cArray = string2.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            int n2 = excUri.indexOf(c);
            if (n2 >= 0) {
                stringBuffer.append(excUriEsc[n2]);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return new URL("file", "", stringBuffer.toString());
    }

    public static String unEscapeURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c == '%') {
                if (n + 2 >= cArray.length) {
                    stringBuffer.append(c);
                } else {
                    int n2 = PRTokeniser.getHex(cArray[n + 1]);
                    int n3 = PRTokeniser.getHex(cArray[n + 2]);
                    if (n2 < 0 || n3 < 0) {
                        stringBuffer.append(c);
                    } else {
                        stringBuffer.append((char)(n2 * 16 + n3));
                        n += 2;
                    }
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int[] getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int[] nArray) {
        this.transparency = nArray;
    }

    public static boolean isTag(String string) {
        return "image".equals(string);
    }

    public float plainWidth() {
        return this.plainWidth;
    }

    public float plainHeight() {
        return this.plainHeight;
    }

    protected static synchronized Long getSerialId() {
        return new Long(++serialId);
    }

    public Long getMySerialId() {
        return this.mySerialId;
    }

    public int getDpiX() {
        return this.dpiX;
    }

    public int getDpiY() {
        return this.dpiY;
    }

    public void setDpi(int n, int n2) {
        this.dpiX = n;
        this.dpiY = n2;
    }

    public boolean isMaskCandidate() {
        if (this.type == 34 && this.bpc > 255) {
            return true;
        }
        return this.colorspace == 1;
    }

    public void makeMask() throws DocumentException {
        if (!this.isMaskCandidate()) {
            throw new DocumentException("This image can not be an image mask.");
        }
        this.mask = true;
    }

    public void setImageMask(Image image) throws DocumentException {
        if (this.mask) {
            throw new DocumentException("An image mask cannot contain another image mask.");
        }
        if (!image.mask) {
            throw new DocumentException("The image mask is not a mask. Did you do makeMask()?");
        }
        this.imageMask = image;
        this.smask = image.bpc > 1 && image.bpc <= 8;
    }

    public Image getImageMask() {
        return this.imageMask;
    }

    public boolean isMask() {
        return this.mask;
    }

    public void setInvertMask(boolean bl) {
        this.invert = bl;
    }

    public boolean isInvertMask() {
        return this.invert;
    }

    public boolean isInverted() {
        return this.invert;
    }

    public void setInverted(boolean bl) {
        this.invert = bl;
    }

    public boolean isInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(boolean bl) {
        this.interpolation = bl;
    }

    public void setMarkupAttribute(String string, String string2) {
        if (this.markupAttributes == null) {
            this.markupAttributes = new Properties();
        }
        this.markupAttributes.put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    public void tagICC(ICC_Profile iCC_Profile) {
        this.profile = iCC_Profile;
    }

    public boolean hasICCProfile() {
        return this.profile != null;
    }

    public ICC_Profile getICCProfile() {
        return this.profile;
    }

    public boolean isDeflated() {
        return this.deflated;
    }

    public void setDeflated(boolean bl) {
        this.deflated = bl;
    }

    public PdfDictionary getAdditional() {
        return this.additional;
    }

    public void setAdditional(PdfDictionary pdfDictionary) {
        this.additional = pdfDictionary;
    }

    public boolean isSmask() {
        return this.smask;
    }

    public void setSmask(boolean bl) {
        this.smask = bl;
    }

    public float getXYRatio() {
        return this.XYRatio;
    }

    public void setXYRatio(float f) {
        this.XYRatio = f;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public void setIndentationLeft(float f) {
        this.indentationLeft = f;
    }

    public void setIndentationRight(float f) {
        this.indentationRight = f;
    }

    public int getOriginalType() {
        return this.originalType;
    }

    public void setOriginalType(int n) {
        this.originalType = n;
    }

    public byte[] getOriginalData() {
        return this.originalData;
    }

    public void setOriginalData(byte[] byArray) {
        this.originalData = byArray;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public void setSpacingBefore(float f) {
        this.spacingBefore = f;
    }

    public void setSpacingAfter(float f) {
        this.spacingAfter = f;
    }

    public float spacingBefore() {
        return this.spacingBefore;
    }

    public float spacingAfter() {
        return this.spacingAfter;
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setWidthPercentage(float f) {
        this.widthPercentage = f;
    }

    public PdfOCG getLayer() {
        return this.layer;
    }

    public void setLayer(PdfOCG pdfOCG) {
        this.layer = pdfOCG;
    }

    private PdfObject simplifyColorspace(PdfObject pdfObject) {
        if (pdfObject == null || !pdfObject.isArray()) {
            return pdfObject;
        }
        PdfObject pdfObject2 = (PdfObject)((PdfArray)pdfObject).getArrayList().get(0);
        if (PdfName.CALGRAY.equals(pdfObject2)) {
            return PdfName.DEVICEGRAY;
        }
        if (PdfName.CALRGB.equals(pdfObject2)) {
            return PdfName.DEVICERGB;
        }
        return pdfObject;
    }

    public void simplifyColorspace() {
        if (this.additional == null) {
            return;
        }
        PdfObject pdfObject = this.additional.get(PdfName.COLORSPACE);
        if (pdfObject == null || !pdfObject.isArray()) {
            return;
        }
        PdfObject pdfObject2 = this.simplifyColorspace(pdfObject);
        if (pdfObject2.isName()) {
            pdfObject = pdfObject2;
        } else {
            ArrayList arrayList;
            PdfObject pdfObject3 = (PdfObject)((PdfArray)pdfObject).getArrayList().get(0);
            if (PdfName.INDEXED.equals(pdfObject3) && (arrayList = ((PdfArray)pdfObject).getArrayList()).size() >= 2 && ((PdfObject)arrayList.get(1)).isArray()) {
                arrayList.set(1, this.simplifyColorspace((PdfObject)arrayList.get(1)));
            }
        }
        this.additional.put(PdfName.COLORSPACE, pdfObject);
    }

    public float getInitialRotation() {
        return this.initialRotation;
    }

    public void setInitialRotation(float f) {
        float f2 = this.rotation - this.initialRotation;
        this.initialRotation = f;
        this.setRotation(f2);
    }

    public PdfIndirectReference getDirectReference() {
        return this.directReference;
    }

    public void setDirectReference(PdfIndirectReference pdfIndirectReference) {
        this.directReference = pdfIndirectReference;
    }
}

