/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGSongImporter;
import org.herac.tuxguitar.io.midi.MidiFileReader;
import org.herac.tuxguitar.io.midi.MidiSettings;
import org.herac.tuxguitar.io.midi.MidiSettingsDialog;
import org.herac.tuxguitar.io.midi.SongAdjuster;
import org.herac.tuxguitar.io.midi.base.MidiEvent;
import org.herac.tuxguitar.io.midi.base.MidiMessage;
import org.herac.tuxguitar.io.midi.base.MidiSequence;
import org.herac.tuxguitar.io.midi.base.MidiTrack;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;

public class MidiSongImporter
implements TGSongImporter {
    private static final long MIN_START = 1000L;
    private static final int MIN_DURATION_VALUE = 64;
    private int resolution;
    private List headers;
    private List tracks;
    private List tempNotes;
    private List tempChannels;
    private List trackTuningHelpers;
    private MidiSettings settings;
    protected TGFactory factory;

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("Midi", "*.mid;*.midi");
    }

    public String getImportName() {
        return "Midi";
    }

    public boolean configure() {
        this.settings = new MidiSettingsDialog().open();
        return this.settings != null;
    }

    public TGSong importSong(TGFactory tGFactory, InputStream inputStream) throws TGFileFormatException {
        try {
            Object object;
            if (this.settings == null) {
                return null;
            }
            this.factory = tGFactory;
            MidiSequence midiSequence = new MidiFileReader().getSequence(inputStream);
            this.initFields(midiSequence);
            for (int i = 0; i < midiSequence.countTracks(); ++i) {
                object = midiSequence.getTrack(i);
                int n = this.getNextTrackNumber();
                int n2 = ((MidiTrack)object).size();
                for (int j = 0; j < n2; ++j) {
                    MidiEvent midiEvent = ((MidiTrack)object).get(j);
                    this.parseMessage(n, midiEvent.getTick(), midiEvent.getMessage());
                }
            }
            this.checkAll();
            TGSong tGSong = this.factory.newSong();
            object = this.headers.iterator();
            while (object.hasNext()) {
                tGSong.addMeasureHeader((TGMeasureHeader)object.next());
            }
            Iterator iterator = this.tracks.iterator();
            while (iterator.hasNext()) {
                tGSong.addTrack((TGTrack)iterator.next());
            }
            return new SongAdjuster(this.factory, tGSong).adjustSong();
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private void initFields(MidiSequence midiSequence) {
        this.resolution = midiSequence.getResolution();
        this.headers = new ArrayList();
        this.tracks = new ArrayList();
        this.tempNotes = new ArrayList();
        this.tempChannels = new ArrayList();
        this.trackTuningHelpers = new ArrayList();
    }

    private int getNextTrackNumber() {
        return this.tracks.size() + 1;
    }

    private void parseMessage(int n, long l, MidiMessage midiMessage) {
        long l2 = this.parseTick(l + (long)this.resolution);
        if (midiMessage.getType() == 1 && midiMessage.getCommand() == 144) {
            this.parseNoteOn(n, l2, midiMessage.getData());
        } else if (midiMessage.getType() == 1 && midiMessage.getCommand() == 128) {
            this.parseNoteOff(n, l2, midiMessage.getData());
        } else if (midiMessage.getType() == 1 && midiMessage.getCommand() == 192) {
            this.parseProgramChange(midiMessage.getData());
        } else if (midiMessage.getType() == 1 && midiMessage.getCommand() == 176) {
            this.parseControlChange(midiMessage.getData());
        } else if (midiMessage.getType() == 2 && midiMessage.getCommand() == 88) {
            this.parseTimeSignature(l2, midiMessage.getData());
        } else if (midiMessage.getType() == 2 && midiMessage.getCommand() == 81) {
            this.parseTempo(l2, midiMessage.getData());
        }
    }

    private long parseTick(long l) {
        return Math.abs(1000L * l / (long)this.resolution);
    }

    private void parseNoteOn(int n, long l, byte[] byArray) {
        int n2;
        int n3 = byArray.length;
        int n4 = n3 > 0 ? byArray[0] & 0xFF & 0xF : 0;
        int n5 = n3 > 1 ? byArray[1] & 0xFF : 0;
        int n6 = n2 = n3 > 2 ? byArray[2] & 0xFF : 0;
        if (n2 == 0) {
            this.parseNoteOff(n, l, byArray);
        } else if (n5 > 0) {
            this.makeTempNotesBefore(l, n);
            this.getTempChannel(n4).setTrack(n);
            this.getTrackTuningHelper(n).checkValue(n5);
            this.tempNotes.add(new TempNote(n, n4, n5, l));
        }
    }

    private void parseNoteOff(int n, long l, byte[] byArray) {
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : 0;
        int n4 = n2 > 1 ? byArray[1] & 0xFF : 0;
        this.makeNote(l, n, n3, n4);
    }

    private void parseProgramChange(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : -1;
        int n4 = n = n2 > 1 ? byArray[1] & 0xFF : -1;
        if (n3 != -1 && n != -1) {
            this.getTempChannel(n3).setInstrument(n);
        }
    }

    private void parseControlChange(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : -1;
        int n4 = n2 > 1 ? byArray[1] & 0xFF : -1;
        int n5 = n = n2 > 2 ? byArray[2] & 0xFF : -1;
        if (n3 != -1 && n4 != -1 && n != -1) {
            if (n4 == 7) {
                this.getTempChannel(n3).setVolume(n);
            } else if (n4 == 10) {
                this.getTempChannel(n3).setBalance(n);
            }
        }
    }

    private void parseTimeSignature(long l, byte[] byArray) {
        if (byArray.length >= 2) {
            TGTimeSignature tGTimeSignature = this.factory.newTimeSignature();
            tGTimeSignature.setNumerator((int)byArray[0]);
            tGTimeSignature.getDenominator().setValue(4);
            if (byArray[1] == 0) {
                tGTimeSignature.getDenominator().setValue(1);
            } else if (byArray[1] == 1) {
                tGTimeSignature.getDenominator().setValue(2);
            } else if (byArray[1] == 2) {
                tGTimeSignature.getDenominator().setValue(4);
            } else if (byArray[1] == 3) {
                tGTimeSignature.getDenominator().setValue(8);
            } else if (byArray[1] == 4) {
                tGTimeSignature.getDenominator().setValue(16);
            } else if (byArray[1] == 5) {
                tGTimeSignature.getDenominator().setValue(32);
            }
            this.getHeader(l).setTimeSignature(tGTimeSignature);
        }
    }

    private void parseTempo(long l, byte[] byArray) {
        if (byArray.length >= 3) {
            TGTempo tGTempo = TGTempo.fromUSQ((TGFactory)this.factory, (int)(byArray[2] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[0] & 0xFF) << 16));
            this.getHeader(l).setTempo(tGTempo);
        }
    }

    private TGTrack getTrack(int n) {
        TGTrack tGTrack;
        Iterator iterator = this.tracks.iterator();
        while (iterator.hasNext()) {
            tGTrack = (TGTrack)iterator.next();
            if (tGTrack.getNumber() != n) continue;
            return tGTrack;
        }
        tGTrack = this.factory.newChannel();
        tGTrack.setChannel((short)-1);
        tGTrack.setEffectChannel((short)-1);
        tGTrack.setInstrument((short)0);
        TGTrack tGTrack2 = this.factory.newTrack();
        tGTrack2.setNumber(n);
        tGTrack2.setChannel((TGChannel)tGTrack);
        TGColor.RED.copy(tGTrack2.getColor());
        this.tracks.add(tGTrack2);
        return tGTrack2;
    }

    private TGMeasureHeader getHeader(long l) {
        TGMeasureHeader tGMeasureHeader;
        long l2 = l >= 1000L ? l : 1000L;
        Iterator iterator = this.headers.iterator();
        while (iterator.hasNext()) {
            tGMeasureHeader = (TGMeasureHeader)iterator.next();
            if (l2 < tGMeasureHeader.getStart() || l2 >= tGMeasureHeader.getStart() + tGMeasureHeader.getLength()) continue;
            return tGMeasureHeader;
        }
        tGMeasureHeader = this.getLastHeader();
        TGMeasureHeader tGMeasureHeader2 = this.factory.newHeader();
        tGMeasureHeader2.setNumber(tGMeasureHeader != null ? tGMeasureHeader.getNumber() + 1 : 1);
        tGMeasureHeader2.setStart(tGMeasureHeader != null ? tGMeasureHeader.getStart() + tGMeasureHeader.getLength() : 1000L);
        tGMeasureHeader2.getTempo().setValue(tGMeasureHeader != null ? tGMeasureHeader.getTempo().getValue() : 120);
        if (tGMeasureHeader != null) {
            tGMeasureHeader.getTimeSignature().copy(tGMeasureHeader2.getTimeSignature());
        } else {
            tGMeasureHeader2.getTimeSignature().setNumerator(4);
            tGMeasureHeader2.getTimeSignature().getDenominator().setValue(4);
        }
        this.headers.add(tGMeasureHeader2);
        if (l2 >= tGMeasureHeader2.getStart() && l2 < tGMeasureHeader2.getStart() + tGMeasureHeader2.getLength()) {
            return tGMeasureHeader2;
        }
        return this.getHeader(l2);
    }

    private TGMeasureHeader getLastHeader() {
        if (!this.headers.isEmpty()) {
            return (TGMeasureHeader)this.headers.get(this.headers.size() - 1);
        }
        return null;
    }

    private TGMeasure getMeasure(TGTrack tGTrack, long l) {
        long l2 = l >= 1000L ? l : 1000L;
        Iterator iterator = tGTrack.getMeasures();
        while (iterator.hasNext()) {
            TGMeasure tGMeasure = (TGMeasure)iterator.next();
            if (l2 < tGMeasure.getStart() || l2 >= tGMeasure.getStart() + tGMeasure.getLength()) continue;
            return tGMeasure;
        }
        this.getHeader(l2);
        for (int i = 0; i < this.headers.size(); ++i) {
            boolean bl = false;
            TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)this.headers.get(i);
            int n = tGTrack.countMeasures();
            for (int j = 0; j < n; ++j) {
                TGMeasure tGMeasure = tGTrack.getMeasure(j);
                if (!tGMeasure.getHeader().equals(tGMeasureHeader)) continue;
                bl = true;
            }
            if (bl) continue;
            TGMeasure tGMeasure = this.factory.newMeasure(tGMeasureHeader);
            tGTrack.addMeasure(tGMeasure);
        }
        return this.getMeasure(tGTrack, l2);
    }

    private TGBeat getBeat(TGMeasure tGMeasure, long l) {
        int n = tGMeasure.countBeats();
        for (int i = 0; i < n; ++i) {
            TGBeat tGBeat = tGMeasure.getBeat(i);
            if (tGBeat.getStart() != l) continue;
            return tGBeat;
        }
        TGBeat tGBeat = this.factory.newBeat();
        tGBeat.setStart(l);
        tGMeasure.addBeat(tGBeat);
        return tGBeat;
    }

    private TempNote getTempNote(int n, int n2, int n3, boolean bl) {
        for (int i = 0; i < this.tempNotes.size(); ++i) {
            TempNote tempNote = (TempNote)this.tempNotes.get(i);
            if (tempNote.getTrack() != n || tempNote.getChannel() != n2 || tempNote.getValue() != n3) continue;
            if (bl) {
                this.tempNotes.remove(i);
            }
            return tempNote;
        }
        return null;
    }

    protected TrackTuningHelper getTrackTuningHelper(int n) {
        TrackTuningHelper trackTuningHelper;
        Iterator iterator = this.trackTuningHelpers.iterator();
        while (iterator.hasNext()) {
            trackTuningHelper = (TrackTuningHelper)iterator.next();
            if (trackTuningHelper.getTrack() != n) continue;
            return trackTuningHelper;
        }
        trackTuningHelper = new TrackTuningHelper(n);
        this.trackTuningHelpers.add(trackTuningHelper);
        return trackTuningHelper;
    }

    private void makeTempNotesBefore(long l, int n) {
        long l2 = l;
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            for (int i = 0; i < this.tempNotes.size(); ++i) {
                TempNote tempNote = (TempNote)this.tempNotes.get(i);
                if (tempNote.getTick() >= l2 || tempNote.getTrack() != n) continue;
                l2 = tempNote.getTick() + 5000L;
                this.makeNote(l2, n, tempNote.getChannel(), tempNote.getValue());
                bl = true;
                continue block0;
            }
        }
    }

    private void makeNote(long l, int n, int n2, int n3) {
        TempNote tempNote = this.getTempNote(n, n2, n3, true);
        if (tempNote != null) {
            int n4 = 0;
            int n5 = tempNote.getValue() + this.settings.getTranspose();
            int n6 = 64;
            long l2 = tempNote.getTick();
            TGDuration tGDuration = this.newDuration(64);
            TGDuration tGDuration2 = TGDuration.fromTime((TGFactory)this.factory, (long)(l - tempNote.getTick()), (TGDuration)tGDuration);
            TGMeasure tGMeasure = this.getMeasure(this.getTrack(n), tempNote.getTick());
            TGBeat tGBeat = this.getBeat(tGMeasure, l2);
            tGDuration2.copy(tGBeat.getDuration());
            TGNote tGNote = this.factory.newNote();
            tGNote.setValue(n5);
            tGNote.setString(n4);
            tGNote.setVelocity(n6);
            tGBeat.addNote(tGNote);
        }
    }

    public TempChannel getTempChannel(int n) {
        TempChannel tempChannel;
        Iterator iterator = this.tempChannels.iterator();
        while (iterator.hasNext()) {
            tempChannel = (TempChannel)iterator.next();
            if (tempChannel.getChannel() != n) continue;
            return tempChannel;
        }
        tempChannel = new TempChannel(n);
        this.tempChannels.add(tempChannel);
        return tempChannel;
    }

    private void checkAll() throws Exception {
        this.checkTracks();
        int n = this.headers.size();
        for (int i = 0; i < this.tracks.size(); ++i) {
            TGTrack tGTrack = (TGTrack)this.tracks.get(i);
            while (tGTrack.countMeasures() < n) {
                TGMeasure tGMeasure;
                long l = 1000L;
                TGMeasure tGMeasure2 = tGMeasure = tGTrack.countMeasures() > 0 ? tGTrack.getMeasure(tGTrack.countMeasures() - 1) : null;
                if (tGMeasure != null) {
                    l = tGMeasure.getStart() + tGMeasure.getLength();
                }
                tGTrack.addMeasure(this.factory.newMeasure(this.getHeader(l)));
            }
        }
        if (this.headers.isEmpty() || this.tracks.isEmpty()) {
            throw new Exception("Empty Song");
        }
    }

    private void checkTracks() {
        Iterator iterator = this.tracks.iterator();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            Iterator iterator2 = this.tempChannels.iterator();
            while (iterator2.hasNext()) {
                TempChannel tempChannel = (TempChannel)iterator2.next();
                if (tempChannel.getTrack() != tGTrack.getNumber()) continue;
                if (tGTrack.getChannel().getChannel() < 0) {
                    tGTrack.getChannel().setChannel((short)tempChannel.getChannel());
                    tGTrack.getChannel().setInstrument((short)tempChannel.getInstrument());
                    tGTrack.getChannel().setVolume((short)tempChannel.getVolume());
                    tGTrack.getChannel().setBalance((short)tempChannel.getBalance());
                    continue;
                }
                if (tGTrack.getChannel().getEffectChannel() >= 0) continue;
                tGTrack.getChannel().setEffectChannel((short)tempChannel.getChannel());
            }
            if (tGTrack.getChannel().getChannel() < 0) {
                tGTrack.getChannel().setChannel((short)15);
                tGTrack.getChannel().setInstrument((short)0);
                tGTrack.getChannel().setVolume((short)127);
                tGTrack.getChannel().setBalance((short)64);
            }
            if (tGTrack.getChannel().getEffectChannel() < 0) {
                tGTrack.getChannel().setEffectChannel(tGTrack.getChannel().getChannel());
            }
            if (!tGTrack.isPercussionTrack()) {
                tGTrack.setStrings(this.getTrackTuningHelper(tGTrack.getNumber()).getStrings());
                continue;
            }
            tGTrack.setStrings(TGSongManager.createPercusionStrings((TGFactory)this.factory, (int)6));
        }
    }

    protected TGDuration newDuration(int n) {
        TGDuration tGDuration = this.factory.newDuration();
        tGDuration.setValue(n);
        return tGDuration;
    }

    private class TrackTuningHelper {
        private int track;
        private int maxValue;
        private int minValue;

        public TrackTuningHelper(int n) {
            this.track = n;
            this.maxValue = -1;
            this.minValue = -1;
        }

        public void checkValue(int n) {
            if (this.minValue < 0 || n < this.minValue) {
                this.minValue = n;
            }
            if (this.maxValue < 0 || n > this.maxValue) {
                this.maxValue = n;
            }
        }

        public List getStrings() {
            ArrayList<TGString> arrayList = new ArrayList<TGString>();
            int n = 24;
            if (this.minValue >= 40 && this.maxValue <= 64 + n) {
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)1, (int)64));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)2, (int)59));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)3, (int)55));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)4, (int)50));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)5, (int)45));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)6, (int)40));
            } else if (this.minValue >= 38 && this.maxValue <= 64 + n) {
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)1, (int)64));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)2, (int)59));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)3, (int)55));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)4, (int)50));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)5, (int)45));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)6, (int)38));
            } else if (this.minValue >= 35 && this.maxValue <= 64 + n) {
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)1, (int)64));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)2, (int)59));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)3, (int)55));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)4, (int)50));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)5, (int)45));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)6, (int)40));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)7, (int)35));
            } else if (this.minValue >= 28 && this.maxValue <= 43 + n) {
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)1, (int)43));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)2, (int)38));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)3, (int)33));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)4, (int)28));
            } else if (this.minValue >= 23 && this.maxValue <= 43 + n) {
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)1, (int)43));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)2, (int)38));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)3, (int)33));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)4, (int)28));
                arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)5, (int)23));
            } else {
                int n2 = 6;
                int n3 = (this.maxValue - (n - 4) - this.minValue) / n2;
                if (n3 > 5) {
                    n2 = 7;
                    n3 = (this.maxValue - (n - 4) - this.minValue) / n2;
                }
                int n4 = this.minValue + n2 * n3;
                while (arrayList.size() < n2) {
                    arrayList.add(TGSongManager.newString((TGFactory)MidiSongImporter.this.factory, (int)(arrayList.size() + 1), (int)(n4 -= n3)));
                }
            }
            return arrayList;
        }

        public int getMaxValue() {
            return this.maxValue;
        }

        public int getMinValue() {
            return this.minValue;
        }

        public int getTrack() {
            return this.track;
        }
    }

    private class TempChannel {
        private int channel;
        private int instrument;
        private int volume;
        private int balance;
        private int track;

        public TempChannel(int n) {
            this.channel = n;
            this.instrument = 0;
            this.volume = 127;
            this.balance = 64;
            this.track = -1;
        }

        public int getBalance() {
            return this.balance;
        }

        public void setBalance(int n) {
            this.balance = n;
        }

        public int getChannel() {
            return this.channel;
        }

        public void setChannel(int n) {
            this.channel = n;
        }

        public int getInstrument() {
            return this.instrument;
        }

        public void setInstrument(int n) {
            this.instrument = n;
        }

        public int getTrack() {
            return this.track;
        }

        public void setTrack(int n) {
            this.track = n;
        }

        public int getVolume() {
            return this.volume;
        }

        public void setVolume(int n) {
            this.volume = n;
        }
    }

    private class TempNote {
        private int track;
        private int channel;
        private int value;
        private long tick;

        public TempNote(int n, int n2, int n3, long l) {
            this.track = n;
            this.channel = n2;
            this.value = n3;
            this.tick = l;
        }

        public int getChannel() {
            return this.channel;
        }

        public void setChannel(int n) {
            this.channel = n;
        }

        public long getTick() {
            return this.tick;
        }

        public void setTick(long l) {
            this.tick = l;
        }

        public int getTrack() {
            return this.track;
        }

        public void setTrack(int n) {
            this.track = n;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }
    }
}

