/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XClientMessageEvent;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    ToolTip toolTip;
    String toolTipText;
    int imageHandle;
    int tooltipsHandle;
    ImageList imageList;

    public TrayItem(Tray tray, int n) {
        super(tray, n);
        this.parent = tray;
        this.createWidget(tray.getItemCount());
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.parent.createItem(this, n);
    }

    void createHandle(int n) {
        this.state |= 8;
        this.handle = OS.gtk_plug_new(0);
        if (this.handle == 0) {
            this.error(2);
        }
        this.imageHandle = OS.gtk_image_new();
        if (this.imageHandle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.handle, this.imageHandle);
        OS.gtk_widget_show(this.handle);
        OS.gtk_widget_show(this.imageHandle);
        int n2 = OS.gtk_plug_get_id(this.handle);
        int n3 = 0;
        int n4 = OS.gdk_screen_get_default();
        if (n4 != 0) {
            n3 = OS.gdk_screen_get_number(n4);
        }
        byte[] byArray = Converter.wcsToMbcs(null, "_NET_SYSTEM_TRAY_S" + n3, true);
        int n5 = OS.gdk_atom_intern(byArray, true);
        int n6 = OS.gdk_x11_atom_to_xatom(n5);
        int n7 = OS.GDK_DISPLAY();
        int n8 = OS.XGetSelectionOwner(n7, n6);
        byte[] byArray2 = Converter.wcsToMbcs(null, "_NET_SYSTEM_TRAY_OPCODE", true);
        int n9 = OS.gdk_atom_intern(byArray2, true);
        int n10 = OS.gdk_x11_atom_to_xatom(n9);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        xClientMessageEvent.type = 33;
        xClientMessageEvent.window = n8;
        xClientMessageEvent.message_type = n10;
        xClientMessageEvent.format = 32;
        xClientMessageEvent.data[0] = 0;
        xClientMessageEvent.data[1] = 0;
        xClientMessageEvent.data[2] = n2;
        int n11 = OS.g_malloc(XClientMessageEvent.sizeof);
        OS.memmove(n11, xClientMessageEvent, XClientMessageEvent.sizeof);
        OS.XSendEvent(n7, n8, false, 0, n11);
        OS.g_free(n11);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.imageHandle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    int gtk_button_press_event(int n, int n2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        if (gdkEventButton.type == 6) {
            return 0;
        }
        if (gdkEventButton.button == 3 && gdkEventButton.type == 4) {
            this.sendEvent(35);
            return 0;
        }
        if (gdkEventButton.type == 5) {
            this.postEvent(14);
        } else {
            this.postEvent(13);
        }
        return 0;
    }

    int gtk_size_allocate(int n, int n2) {
        if (this.image != null && this.image.mask != 0 && OS.gdk_drawable_get_depth(this.image.mask) == 1) {
            int n3 = (int)Math.floor((double)OS.GTK_WIDGET_X(n) + (double)(OS.GTK_WIDGET_WIDTH(n) - OS.GTK_WIDGET_REQUISITION_WIDTH(n)) * 0.5 + 0.5);
            int n4 = (int)Math.floor((double)OS.GTK_WIDGET_Y(n) + (double)(OS.GTK_WIDGET_HEIGHT(n) - OS.GTK_WIDGET_REQUISITION_HEIGHT(n)) * 0.5 + 0.5);
            Rectangle rectangle = this.image.getBounds();
            int n5 = OS.gdk_drawable_get_image(this.image.mask, 0, 0, rectangle.width, rectangle.height);
            if (n5 == 0) {
                SWT.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove(gdkImage, n5);
            byte[] byArray = new byte[gdkImage.bpl * gdkImage.height];
            OS.memmove(byArray, gdkImage.mem, byArray.length);
            OS.g_object_unref(n5);
            Region region = new Region(this.display);
            int n6 = 0;
            while (n6 < rectangle.height) {
                int n7 = 0;
                while (n7 < rectangle.width) {
                    int n8 = n6 * gdkImage.bpl + (n7 >> 3);
                    int n9 = byArray[n8] & 0xFF;
                    int n10 = 1 << (n7 & 7);
                    if ((n9 & n10) != 0) {
                        region.add(n3 + n7, n4 + n6, 1, 1);
                    }
                    ++n7;
                }
                ++n6;
            }
            OS.gtk_widget_realize(this.handle);
            n6 = OS.GTK_WIDGET_WINDOW(this.handle);
            OS.gdk_window_shape_combine_region(n6, region.handle, 0, 0);
            region.dispose();
        }
        return 0;
    }

    void hookEvents() {
        int n = 256;
        OS.gtk_widget_add_events(this.handle, n);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.closures[2], false);
        OS.g_signal_connect_closure_by_id(this.imageHandle, this.display.signalIds[46], 0, this.display.closures[46], false);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.GTK_WIDGET_VISIBLE(this.handle);
    }

    void register() {
        super.register();
        this.display.addWidget(this.imageHandle, this);
    }

    void releaseHandle() {
        if (this.handle != 0) {
            OS.gtk_widget_destroy(this.handle);
        }
        this.imageHandle = 0;
        this.handle = 0;
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.tooltipsHandle != 0) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.toolTipText = null;
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            int n;
            Rectangle rectangle = image.getBounds();
            OS.gtk_widget_set_size_request(this.handle, rectangle.width, rectangle.height);
            if (this.imageList == null) {
                this.imageList = new ImageList();
            }
            if ((n = this.imageList.indexOf(image)) == -1) {
                n = this.imageList.add(image);
            } else {
                this.imageList.put(n, image);
            }
            int n2 = this.imageList.getPixbuf(n);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, n2);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            OS.gtk_widget_set_size_request(this.handle, 1, 1);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip toolTip2 = this.toolTip;
        ToolTip toolTip3 = toolTip;
        if (toolTip2 != null) {
            toolTip2.item = null;
        }
        this.toolTip = toolTip3;
        if (toolTip3 != null) {
            toolTip3.item = this;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        byte[] byArray = null;
        if (string != null && string.length() > 0) {
            byArray = Converter.wcsToMbcs(null, string, true);
        }
        if (this.tooltipsHandle == 0) {
            this.tooltipsHandle = OS.gtk_tooltips_new();
            if (this.tooltipsHandle == 0) {
                this.error(2);
            }
            OS.g_object_ref(this.tooltipsHandle);
            OS.gtk_object_sink(this.tooltipsHandle);
        }
        OS.gtk_tooltips_set_tip(this.tooltipsHandle, this.handle, byArray, null);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (OS.GTK_WIDGET_VISIBLE(this.handle) == bl) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.gtk_widget_show(this.handle);
        } else {
            OS.gtk_widget_hide(this.handle);
            this.sendEvent(23);
        }
    }
}

