/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.musicxml;

import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.herac.tuxguitar.player.base.MidiInstrument;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGTupleto;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MusicXMLWriter {
    private static final String[] NATURAL_NOTES = new String[]{"C", "C", "D", "D", "E", "F", "F", "G", "G", "A", "A", "B"};
    private static final boolean[] ACCIDENTAL_NOTES = new boolean[]{false, true, false, true, false, false, true, false, true, false, true, false};
    private TGSongManager manager;
    private OutputStream stream;
    private Document document;

    public MusicXMLWriter(OutputStream outputStream) {
        this.stream = outputStream;
    }

    public void writeSong(TGSong tGSong) {
        this.manager = new TGSongManager();
        this.manager.setSong(tGSong);
        this.document = this.newDocument();
        Node node = this.addNode(this.document, "score-partwise");
        this.writeHeaders(node);
        this.writeSong(node);
        this.saveDocument();
    }

    public Document newDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return document;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void saveDocument() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(this.document);
            StreamResult streamResult = new StreamResult(this.stream);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private Node addAttribute(Node node, String string, String string2) {
        Attr attr = this.document.createAttribute(string);
        attr.setNodeValue(string2);
        node.getAttributes().setNamedItem(attr);
        return node;
    }

    private Node addNode(Node node, String string) {
        Element element = this.document.createElement(string);
        node.appendChild(element);
        return element;
    }

    private Node addNode(Node node, String string, String string2) {
        Node node2 = this.addNode(node, string);
        node2.setTextContent(string2);
        return node2;
    }

    private void writeHeaders(Node node) {
        this.writeWork(node);
        this.writeIdentification(node);
    }

    private void writeWork(Node node) {
        this.addNode(this.addNode(node, "work"), "work-title", this.manager.getSong().getName());
    }

    private void writeIdentification(Node node) {
        Node node2 = this.addNode(node, "identification");
        this.addNode(this.addNode(node2, "encoding"), "software", "TuxGuitar");
        this.addAttribute(this.addNode(node2, "creator", this.manager.getSong().getAuthor()), "type", "composer");
    }

    private void writeSong(Node node) {
        this.writePartList(node);
        this.writeParts(node);
    }

    private void writePartList(Node node) {
        Node node2 = this.addNode(node, "part-list");
        Iterator iterator = this.manager.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            Node node3 = this.addNode(node2, "score-part");
            this.addAttribute(node3, "id", "P" + tGTrack.getNumber());
            this.addNode(node3, "part-name", tGTrack.getName());
            Node node4 = this.addAttribute(this.addNode(node3, "score-instrument"), "id", "P" + tGTrack.getNumber() + "-I1");
            this.addNode(node4, "instrument-name", MidiInstrument.INSTRUMENT_LIST[tGTrack.getChannel().getInstrument()].getName());
            Node node5 = this.addAttribute(this.addNode(node3, "midi-instrument"), "id", "P" + tGTrack.getNumber() + "-I1");
            this.addNode(node5, "midi-channel", Integer.toString(tGTrack.getChannel().getChannel() + 1));
            this.addNode(node5, "midi-program", Integer.toString(tGTrack.getChannel().getInstrument() + 1));
        }
    }

    private void writeParts(Node node) {
        Iterator iterator = this.manager.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            Node node2 = this.addAttribute(this.addNode(node, "part"), "id", "P" + tGTrack.getNumber());
            TGMeasure tGMeasure = null;
            Iterator iterator2 = tGTrack.getMeasures();
            while (iterator2.hasNext()) {
                TGMeasure tGMeasure2 = (TGMeasure)iterator2.next();
                Node node3 = this.addAttribute(this.addNode(node2, "measure"), "number", Integer.toString(tGMeasure2.getNumber()));
                this.writeMeasureAttributes(node3, tGMeasure2, tGMeasure);
                this.writeDirection(node3, tGMeasure2, tGMeasure);
                this.writeNotes(node3, tGMeasure2);
                tGMeasure = tGMeasure2;
            }
        }
    }

    private void writeMeasureAttributes(Node node, TGMeasure tGMeasure, TGMeasure tGMeasure2) {
        boolean bl;
        boolean bl2 = tGMeasure2 == null;
        boolean bl3 = tGMeasure2 == null || tGMeasure.getKeySignature() != tGMeasure2.getKeySignature();
        boolean bl4 = tGMeasure2 == null || tGMeasure.getClef() != tGMeasure2.getClef();
        boolean bl5 = bl = tGMeasure2 == null || !tGMeasure.getTimeSignature().isEqual(tGMeasure2.getTimeSignature());
        if (bl2 || bl3 || bl4 || bl) {
            Node node2 = this.addNode(node, "attributes");
            if (bl2) {
                this.addNode(node2, "divisions", Integer.toString(64));
            }
            if (bl3) {
                this.writeKeySignature(node2, 0);
            }
            if (bl4) {
                this.writeClef(node2, tGMeasure.getClef());
            }
            if (bl) {
                this.writeTimeSignature(node2, tGMeasure.getTimeSignature());
            }
        }
    }

    private void writeTimeSignature(Node node, TGTimeSignature tGTimeSignature) {
        Node node2 = this.addNode(node, "time");
        this.addNode(node2, "beats", Integer.toString(tGTimeSignature.getNumerator()));
        this.addNode(node2, "beat-type", Integer.toString(tGTimeSignature.getDenominator().getValue()));
    }

    private void writeKeySignature(Node node, int n) {
        int n2 = n;
        if (n2 != 0) {
            n2 = ((n - 1) % 7 + 1) * (n > 7 ? -1 : 1);
        }
        Node node2 = this.addNode(node, "key");
        this.addNode(node2, "fifths", Integer.toString(n2));
        this.addNode(node2, "mode", "major");
    }

    private void writeClef(Node node, int n) {
        Node node2 = this.addNode(node, "clef");
        if (n == 1) {
            this.addNode(node2, "sign", "G");
            this.addNode(node2, "line", "2");
        } else if (n == 2) {
            this.addNode(node2, "sign", "F");
            this.addNode(node2, "line", "4");
        } else if (n == 3) {
            this.addNode(node2, "sign", "G");
            this.addNode(node2, "line", "2");
        } else if (n == 4) {
            this.addNode(node2, "sign", "G");
            this.addNode(node2, "line", "2");
        }
    }

    private void writeDirection(Node node, TGMeasure tGMeasure, TGMeasure tGMeasure2) {
        boolean bl;
        boolean bl2 = bl = tGMeasure2 == null || tGMeasure.getTempo().getValue() != tGMeasure.getTempo().getValue();
        if (bl) {
            Node node2 = this.addAttribute(this.addNode(node, "direction"), "placement", "above");
            this.writeMeasureTempo(node2, tGMeasure.getTempo());
        }
    }

    private void writeMeasureTempo(Node node, TGTempo tGTempo) {
        this.addAttribute(this.addNode(node, "sound"), "tempo", Integer.toString(tGTempo.getValue()));
    }

    private void writeNotes(Node node, TGMeasure tGMeasure) {
        int n = tGMeasure.countBeats();
        for (int i = 0; i < n; ++i) {
            TGBeat tGBeat = tGMeasure.getBeat(i);
            if (tGBeat.isRestBeat()) {
                Node node2 = this.addNode(node, "note");
                this.addNode(node2, "rest");
                this.addNode(node2, "voice", "1");
                this.writeDuration(node2, tGBeat.getDuration());
                continue;
            }
            int n2 = tGBeat.countNotes();
            for (int j = 0; j < n2; ++j) {
                TGNote tGNote = tGBeat.getNote(j);
                Node node3 = this.addNode(node, "note");
                int n3 = tGNote.getBeat().getMeasure().getTrack().getString(tGNote.getString()).getValue() + tGNote.getValue();
                Node node4 = this.addNode(node3, "pitch");
                this.addNode(node4, "step", NATURAL_NOTES[n3 % 12]);
                this.addNode(node4, "octave", Integer.toString(n3 / 12));
                if (ACCIDENTAL_NOTES[n3 % 12]) {
                    this.addNode(node3, "accidental", "sharp");
                }
                this.addNode(node3, "voice", "1");
                this.writeDuration(node3, tGBeat.getDuration());
                if (j <= 0) continue;
                this.addNode(node3, "chord");
            }
        }
    }

    private void writeDuration(Node node, TGDuration tGDuration) {
        this.addNode(node, "duration", Integer.toString(tGDuration.getValue()));
        if (tGDuration.getValue() == 1) {
            this.addNode(node, "type", "quarter");
        } else if (tGDuration.getValue() == 1) {
            this.addNode(node, "type", "whole");
        } else if (tGDuration.getValue() == 2) {
            this.addNode(node, "type", "half");
        } else if (tGDuration.getValue() == 4) {
            this.addNode(node, "type", "quarter");
        } else if (tGDuration.getValue() == 8) {
            this.addNode(node, "type", "eighth");
        } else if (tGDuration.getValue() == 16) {
            this.addNode(node, "type", "16th");
        } else if (tGDuration.getValue() == 32) {
            this.addNode(node, "type", "32nd");
        } else if (tGDuration.getValue() == 64) {
            this.addNode(node, "type", "64th");
        }
        if (tGDuration.isDotted()) {
            this.addNode(node, "dot");
        } else if (tGDuration.isDoubleDotted()) {
            this.addNode(node, "dot");
            this.addNode(node, "dot");
        }
        if (!tGDuration.getTupleto().isEqual(TGTupleto.NORMAL)) {
            Node node2 = this.addNode(node, "time-modification");
            this.addNode(node2, "actual-notes", Integer.toString(tGDuration.getTupleto().getEnters()));
            this.addNode(node2, "normal-notes", Integer.toString(tGDuration.getTupleto().getTimes()));
        }
    }
}

