/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.sequencer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.player.base.MidiSequencerProvider;
import org.herac.tuxguitar.player.impl.jsa.sequencer.MidiSequencerImpl;

public class MidiSequencerProviderImpl
implements MidiSequencerProvider {
    public List listSequencers() throws MidiPlayerException {
        try {
            ArrayList<MidiSequencerImpl> arrayList = new ArrayList<MidiSequencerImpl>();
            MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
            for (int i = 0; i < infoArray.length; ++i) {
                try {
                    MidiDevice midiDevice;
                    Iterator iterator = arrayList.iterator();
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        if (!((MidiSequencer)iterator.next()).getKey().equals(infoArray[i].getName())) continue;
                        bl = true;
                        break;
                    }
                    if (bl || !((midiDevice = MidiSystem.getMidiDevice(infoArray[i])) instanceof Sequencer)) continue;
                    arrayList.add(new MidiSequencerImpl((Sequencer)midiDevice));
                    continue;
                }
                catch (MidiUnavailableException midiUnavailableException) {
                    throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.midi.unavailable"), (Throwable)midiUnavailableException);
                }
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.unknown"), throwable);
        }
    }

    public void closeAll() throws MidiPlayerException {
    }
}

