/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.midiport;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import org.herac.tuxguitar.player.base.MidiOut;
import org.herac.tuxguitar.player.impl.jsa.utils.MidiMessageUtils;

class MidiOutImpl
implements MidiOut {
    private MidiDevice device;
    private Receiver receiver;

    public MidiOutImpl(MidiDevice midiDevice) {
        this.device = midiDevice;
    }

    protected void openReceiver() throws MidiUnavailableException {
        if (!this.device.isOpen()) {
            this.device.open();
        }
        if (this.receiver == null) {
            this.receiver = this.device.getReceiver();
        }
    }

    protected void closeReceiver() {
        if (this.receiver != null) {
            this.receiver.close();
        }
    }

    protected Receiver getReceiver() {
        try {
            this.openReceiver();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            // empty catch block
        }
        return this.receiver;
    }

    public void sendSystemReset() {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageUtils.systemReset(), -1L);
        }
    }

    public void sendAllNotesOff() {
        if (this.getReceiver() != null) {
            for (int i = 0; i < 16; ++i) {
                this.getReceiver().send(MidiMessageUtils.controlChange(i, 123, 0), -1L);
            }
        }
    }

    public void sendNoteOn(int n, int n2, int n3) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageUtils.noteOn(n, n2, n3), -1L);
        }
    }

    public void sendNoteOff(int n, int n2, int n3) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageUtils.noteOff(n, n2, n3), -1L);
        }
    }

    public void sendControlChange(int n, int n2, int n3) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageUtils.controlChange(n, n2, n3), -1L);
        }
    }

    public void sendProgramChange(int n, int n2) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageUtils.programChange(n, n2), -1L);
        }
    }

    public void sendPitchBend(int n, int n2) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageUtils.pitchBend(n, n2), -1L);
        }
    }
}

