/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.pdf;

import java.io.OutputStream;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.TGFactoryImpl;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintDocumentData;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGSongExporter;
import org.herac.tuxguitar.io.pdf.PDFWriter;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;

public class PDFSongExporter
implements TGSongExporter {
    private static final int PAGE_WIDTH = 550;
    private static final int PAGE_HEIGHT = 800;
    private PrintDocumentData data;

    public String getExportName() {
        return "PDF";
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("PDF", "*.pdf");
    }

    public boolean configure() {
        this.data = PrintDocumentData.openDialog((Shell)TuxGuitar.instance().getShell());
        return this.data != null;
    }

    public void exportSong(OutputStream outputStream, TGSong tGSong) {
        try {
            if (this.data != null) {
                this.export(outputStream, tGSong, this.data);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return;
        }
    }

    public void export(final OutputStream outputStream, final TGSong tGSong, final PrintDocumentData printDocumentData) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    TGSongManager tGSongManager = new TGSongManager();
                    tGSongManager.setFactory((TGFactory)new TGFactoryImpl());
                    tGSongManager.setSong(tGSong.clone(tGSongManager.getFactory()));
                    PDFSongExporter.this.export(outputStream, tGSongManager, printDocumentData);
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage((Throwable)throwable);
                }
            }
        }).start();
    }

    public void export(final OutputStream outputStream, final TGSongManager tGSongManager, final PrintDocumentData printDocumentData) {
        new SyncThread(new Runnable(){

            public void run() {
                try {
                    Tablature tablature = new Tablature((Composite)TuxGuitar.instance().getShell());
                    tablature.setSongManager(tGSongManager);
                    PrinterViewLayout printerViewLayout = new PrinterViewLayout(tablature, printDocumentData, 1.0f);
                    PDFSongExporter.this.export(outputStream, printerViewLayout);
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage((Throwable)throwable);
                }
            }
        }).start();
    }

    public void export(final OutputStream outputStream, final PrinterViewLayout printerViewLayout) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    printerViewLayout.getTablature().updateTablature();
                    printerViewLayout.getTablature().getCaret().update(TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getTrack().getNumber());
                    new SyncThread(new Runnable(){

                        public void run() {
                            final PrintDocument printDocument = printerViewLayout.makeDocument(550, 800);
                            printerViewLayout.getTablature().dispose();
                            new Thread(new Runnable(){

                                public void run() {
                                    try {
                                        PDFWriter.write(outputStream, printDocument);
                                    }
                                    catch (Throwable throwable) {
                                        MessageDialog.errorMessage((Throwable)throwable);
                                    }
                                }
                            }).start();
                        }
                    }).start();
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage((Throwable)throwable);
                }
            }
        }).start();
    }
}

