/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;

public abstract class TGTupleto {
    public static final TGTupleto NORMAL = TGTupleto.newTupleto(1, 1);
    private int enters = 1;
    private int times = 1;

    public int getEnters() {
        return this.enters;
    }

    public void setEnters(int n) {
        this.enters = n;
    }

    public int getTimes() {
        return this.times;
    }

    public void setTimes(int n) {
        this.times = n;
    }

    public long convertTime(long l) {
        return l * (long)this.times / (long)this.enters;
    }

    public boolean isEqual(TGTupleto tGTupleto) {
        return tGTupleto.getEnters() == this.getEnters() && tGTupleto.getTimes() == this.getTimes();
    }

    public TGTupleto clone(TGFactory tGFactory) {
        TGTupleto tGTupleto = tGFactory.newTupleto();
        this.copy(tGTupleto);
        return tGTupleto;
    }

    public void copy(TGTupleto tGTupleto) {
        tGTupleto.setEnters(this.enters);
        tGTupleto.setTimes(this.times);
    }

    private static TGTupleto newTupleto(int n, int n2) {
        TGTupleto tGTupleto = new TGFactory().newTupleto();
        tGTupleto.setEnters(n);
        tGTupleto.setTimes(n2);
        return tGTupleto;
    }
}

